/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.util.Random;
import rice.pastry.Id;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.routing.SendOptions;
import rice.pastry.security.Credentials;
import rice.pastry.security.PermissiveCredentials;
import rice.pastry.testing.HelloMsg;

public class HelloWorldApp
extends PastryAppl {
    private int msgid = 0;
    private static Address addr = new HelloAddress();
    private static Credentials cred = new PermissiveCredentials();

    public HelloWorldApp(PastryNode pn) {
        super(pn);
    }

    public Address getAddress() {
        return addr;
    }

    public Credentials getCredentials() {
        return cred;
    }

    public void sendRndMsg(Random rng) {
        Id rndid = Id.makeRandomId(rng);
        if (Log.ifp(5)) {
            System.out.println("Sending message from " + this.getNodeId() + " to random dest " + rndid);
        }
        HelloMsg msg = new HelloMsg(addr, this.thePastryNode.getLocalHandle(), rndid, ++this.msgid);
        this.routeMsg(rndid, msg, cred, new SendOptions());
    }

    public void messageForAppl(Message msg) {
        if (Log.ifp(5)) {
            System.out.println("Received " + msg + " at " + this.getNodeId());
        }
    }

    public boolean enrouteMessage(Message msg, Id key, NodeId nextHop, SendOptions opt) {
        if (Log.ifp(5)) {
            System.out.println("Enroute " + msg + " at " + this.getNodeId());
        }
        return true;
    }

    public void leafSetChange(NodeHandle nh, boolean wasAdded) {
        if (Log.ifp(5)) {
            System.out.print("In " + this.getNodeId() + "'s leaf set, " + "node " + nh.getNodeId() + " was ");
            if (wasAdded) {
                System.out.println("added");
            } else {
                System.out.println("removed");
            }
        }
    }

    public void routeSetChange(NodeHandle nh, boolean wasAdded) {
        if (Log.ifp(5)) {
            System.out.print("In " + this.getNodeId() + "'s route set, " + "node " + nh.getNodeId() + " was ");
            if (wasAdded) {
                System.out.println("added");
            } else {
                System.out.println("removed");
            }
        }
    }

    public void notifyReady() {
        System.out.println("Node " + this.getNodeId() + " ready, waking up any clients");
    }

    private static class HelloAddress
    implements Address {
        private int myCode = 428125133;

        private HelloAddress() {
        }

        public int hashCode() {
            return this.myCode;
        }

        public boolean equals(Object obj) {
            return obj instanceof HelloAddress;
        }

        public String toString() {
            return "[HelloAddress]";
        }
    }
}

