/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.util.Random;
import rice.pastry.Id;
import rice.pastry.IdRange;
import rice.pastry.PastrySeed;

public class IdRangeUnit {
    private Random rng = new Random(PastrySeed.getSeed());

    public IdRangeUnit() {
        System.out.println("IdRangeUnit test starting...");
        for (int i = 0; i < 1000; ++i) {
            IdRange r1 = this.createEmptyIdRange();
            IdRange r2 = this.createEmptyIdRange();
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r2 = this.createFullIdRange();
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r2 = this.createRandomIdRange();
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r1 = this.createFullIdRange();
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r2 = this.createFullIdRange();
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r2 = this.createEmptyIdRange();
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r1 = this.createRandomIdRange();
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r2 = this.createIdRangeStartingWith(r1.getCW());
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r2 = this.createIdRangeStartingWith(r1.getCCW());
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r2 = this.createIdRangeEndingIn(r1.getCW());
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r2 = this.createIdRangeEndingIn(r1.getCCW());
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r2 = r1.complement();
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r1 = this.createFullIdRange();
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r2 = this.createIdRangeStartingWith(r1.getCW());
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r2 = this.createIdRangeStartingWith(r1.getCCW());
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r2 = this.createIdRangeEndingIn(r1.getCW());
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r2 = this.createIdRangeEndingIn(r1.getCCW());
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r1 = this.createEmptyIdRange();
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r2 = this.createIdRangeStartingWith(r1.getCW());
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r2 = this.createIdRangeStartingWith(r1.getCCW());
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r2 = this.createIdRangeEndingIn(r1.getCW());
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r2 = this.createIdRangeEndingIn(r1.getCCW());
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
            r1 = new IdRange(this.createIdWithPrefix((byte)-64), this.createIdWithPrefix((byte)64));
            r2 = new IdRange(this.createIdWithPrefix((byte)-32), this.createIdWithPrefix((byte)32));
            this.equalityTest(r1, r2);
            this.mergeIntersectTest(r1, r2);
            this.diffSubtractTest(r1, r2);
            this.mergeTest(r1, r2);
        }
        System.out.println("IdRangeUnit test finished.");
    }

    public IdRange createRandomIdRange() {
        IdRange r = new IdRange(Id.makeRandomId(this.rng), Id.makeRandomId(this.rng));
        return r;
    }

    public IdRange createFullIdRange() {
        Id id = Id.makeRandomId(this.rng);
        IdRange r = new IdRange(id, id);
        return r;
    }

    public IdRange createEmptyIdRange() {
        IdRange r = new IdRange();
        return r;
    }

    public IdRange createIdRangeStartingWith(Id ccw) {
        IdRange r = new IdRange(ccw, Id.makeRandomId(this.rng));
        return r;
    }

    public IdRange createIdRangeEndingIn(Id cw) {
        IdRange r = new IdRange(Id.makeRandomId(this.rng), cw);
        return r;
    }

    public Id createIdWithPrefix(byte b) {
        byte[] data = new byte[20];
        data[data.length - 1] = b;
        return Id.build(data);
    }

    public void equalityTest(IdRange r1, IdRange r2) {
        IdRange r5;
        IdRange r4;
        if (r1.equals(r2) && !r1.isEmpty() && !r1.isFull()) {
            System.out.println("ALERT: equality failed with high probability" + r1 + r2);
        }
        if (!r1.equals(r1)) {
            System.out.println("ALERT: equality is not reflexive." + r1);
        }
        IdRange r3 = new IdRange(r2.getCCW(), r2.getCW());
        IdRange r31 = new IdRange(r3);
        if (!r3.equals(r2) && !r2.isEmpty() || !r3.equals(r31)) {
            System.out.println("ALERT: equality failed." + r2 + r3 + r31);
        }
        if ((r4 = new IdRange()).equals(r5 = new IdRange(r1.getCCW(), r1.getCCW()))) {
            System.out.println("ALERT: equality failed" + r4 + r4);
        }
        if (!r4.isEmpty() || r5.isEmpty()) {
            System.out.println("ALERT: isEmpty failed" + r4 + r5);
        }
    }

    public void mergeIntersectTest(IdRange r1, IdRange r2) {
        IdRange m1 = r1.merge(r2);
        IdRange m2 = r2.merge(r1);
        IdRange i1 = r1.intersect(r2);
        if (!(m1.equals(m2) || i1.isEmpty() && !r1.isAdjacent(r2) || r1.isEmpty())) {
            System.out.println("ALERT: merge is not symmetric 1" + r1 + r2 + m1 + m2);
        }
        boolean intersect = !i1.isEmpty();
        boolean adjacent = r1.isAdjacent(r2);
        boolean intersectOrAdjacent = intersect || adjacent;
        IdRange i2 = r2.intersect(r1);
        if (i1.isEmpty() != i2.isEmpty()) {
            System.out.println("ALERT: intersect error 1." + i1 + i2);
        }
        if (intersectOrAdjacent) {
            if (m1.equals(r1) && !i1.isEmpty() && !i1.equals(r2)) {
                System.out.println("ALERT: merge is not symmetric 2" + r1 + r2 + m1 + i1);
            }
            if (m1.equals(r2) && !i1.isEmpty() && !i1.equals(r1)) {
                System.out.println("ALERT: merge is not symmetric 3" + r1 + r2 + m1 + i1);
            }
            IdRange re1 = m1.intersect(r1);
            IdRange re2 = m1.intersect(r2);
            if (!r1.equals(re1) || !r2.equals(re2)) {
                System.out.println("ALERT: intersect error 2." + r1 + re1 + r2 + re2 + m1);
            }
        } else if (!m1.equals(r1) && !r1.isEmpty()) {
            System.out.println("ALERT: merge error 0." + r1 + r2 + m1);
        }
        if ((r1.isEmpty() || r2.isEmpty()) && !i1.isEmpty()) {
            System.out.println("ALERT: intersect error 3." + r1 + r2 + i1);
        }
        if (r1.isEmpty() && !m1.equals(r2)) {
            System.out.println("ALERT: merge error 1." + r1 + r2 + m1);
        }
        if (r2.isEmpty() && !m1.equals(r1)) {
            System.out.println("ALERT: merge error 2." + r1 + r2 + m1);
        }
        if ((r1.isFull() || r2.isFull()) && !m1.isFull()) {
            System.out.println("ALERT: merge error 3." + r1 + r2 + m1);
        }
        if (r1.isFull() && !i1.equals(r2)) {
            System.out.println("ALERT: intersect error 4." + r1 + r2 + i1);
        }
        if (r2.isFull() && !i1.equals(r1)) {
            System.out.println("ALERT: intersect error 5." + r1 + r2 + m1);
        }
    }

    public void diffSubtractTest(IdRange r1, IdRange r2) {
        int i;
        IdRange d1 = r1.diff(r2);
        IdRange d2 = r2.diff(r1);
        IdRange i1 = r1.intersect(r2);
        IdRange i2 = r2.intersect(r1);
        if (!(d1.intersect(i1).isEmpty() && d1.intersect(i2).isEmpty() && d2.intersect(i1).isEmpty() && d2.intersect(i2).isEmpty())) {
            System.out.println("ALERT: diff error 1." + r1 + r2 + d1 + d2 + i1 + i2);
        }
        if (!i1.equals(i2) && d1.equals(d2)) {
            System.out.println("ALERT: diff error 15." + r1 + r2 + d1 + d2 + i1 + i2);
        }
        IdRange re1 = d1;
        IdRange re2 = d2;
        for (int i3 = 0; i3 < 3; ++i3) {
            re1 = re1.merge(d1);
            re1 = re1.merge(i1);
            re1 = re1.merge(d2);
            re1 = re1.merge(i2);
            re2 = re2.merge(d1);
            re2 = re2.merge(i1);
            re2 = re2.merge(d2);
            re2 = re2.merge(i2);
        }
        IdRange r12 = r1.merge(r2);
        if (!re1.equals(r1) && !re1.equals(r2) && !re1.equals(r12) || !re2.equals(r1) && !re2.equals(r2) && !re2.equals(r12)) {
            System.out.println("ALERT: diff error 2." + r1 + r2 + d1 + d2 + i1 + i2 + re1 + re2);
        }
        d1 = r1.subtract(r2, false);
        d2 = r1.subtract(r2, true);
        if (!(d1.intersect(i1).isEmpty() && d1.intersect(i2).isEmpty() && d2.intersect(i1).isEmpty() && d2.intersect(i2).isEmpty())) {
            System.out.println("ALERT: subtract error 1." + r1 + r2 + d1 + d2 + i1 + i2);
        }
        if (!d1.isEmpty() && d1.intersect(r1).isEmpty() || !d2.isEmpty() && d2.intersect(r1).isEmpty()) {
            System.out.println("ALERT: subtract error 2." + r1 + r2 + d1 + d2);
        }
        re1 = d1;
        re2 = d2;
        for (i = 0; i < 3; ++i) {
            re1 = re1.merge(d1);
            re1 = re1.merge(i1);
            re1 = re1.merge(d2);
            re1 = re1.merge(i2);
            re2 = re2.merge(d1);
            re2 = re2.merge(i1);
            re2 = re2.merge(d2);
            re2 = re2.merge(i2);
        }
        r12 = r1.merge(r2);
        if (!re1.equals(r1) && !re2.equals(r1)) {
            System.out.println("ALERT: subtract error 25." + r1 + r2 + d1 + d2 + i1 + i2 + re1 + re2);
        }
        d1 = r2.subtract(r1, false);
        d2 = r2.subtract(r1, true);
        if (!(d1.intersect(i1).isEmpty() && d1.intersect(i2).isEmpty() && d2.intersect(i1).isEmpty() && d2.intersect(i2).isEmpty())) {
            System.out.println("ALERT: subtract error 3." + r1 + r2 + d1 + d2 + i1 + i2);
        }
        if (!d1.isEmpty() && d1.intersect(r2).isEmpty() || !d2.isEmpty() && d2.intersect(r2).isEmpty()) {
            System.out.println("ALERT: subtract error 4." + r1 + r2 + d1 + d2);
        }
        re1 = d1;
        re2 = d2;
        for (i = 0; i < 3; ++i) {
            re1 = re1.merge(d1);
            re1 = re1.merge(i1);
            re1 = re1.merge(d2);
            re1 = re1.merge(i2);
            re2 = re2.merge(d1);
            re2 = re2.merge(i1);
            re2 = re2.merge(d2);
            re2 = re2.merge(i2);
        }
        r12 = r1.merge(r2);
        if (!re1.equals(r2) && !re2.equals(r2)) {
            System.out.println("ALERT: subtract error 5." + r1 + r2 + d1 + d2 + i1 + i2 + re1 + re2);
        }
    }

    public void mergeTest(IdRange r1, IdRange r2) {
        IdRange cw;
        IdRange ccw = r1.ccwHalf();
        if (!ccw.intersect(cw = r1.cwHalf()).isEmpty()) {
            System.out.println("ALERT: ccw and cw halves intersect." + r1 + ccw + cw);
        }
        if (!r1.equals(ccw.merge(cw))) {
            System.out.println("ALERT: merge cw/ccw failure." + r1 + ccw + cw);
        }
        if (!(ccw = r2.ccwHalf()).intersect(cw = r2.cwHalf()).isEmpty()) {
            System.out.println("ALERT: ccw and cw halves intersect." + r2 + ccw + cw);
        }
        if (!r2.equals(ccw.merge(cw))) {
            System.out.println("ALERT: merge cw/ccw failure." + r2 + ccw + cw);
        }
    }

    public static void main(String[] args) {
        IdRangeUnit niu = new IdRangeUnit();
    }
}

