/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import rice.pastry.IdRange;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeIdFactory;
import rice.pastry.NodeSetUpdate;
import rice.pastry.leafset.LeafSet;
import rice.pastry.leafset.SimilarSet;
import rice.pastry.messaging.Message;
import rice.pastry.standard.RandomNodeIdFactory;

public class LeafSetTest {
    protected NodeIdFactory factory = new RandomNodeIdFactory();
    protected Random random = new Random();

    public void start() {
        this.testCumulativeRange();
        this.testNonCumulativeRange();
        this.testObservers();
    }

    public void testObservers() {
        int halfLeafSet = 3;
        LeafSet leafset = this.generateLeafSet(halfLeafSet * 2, halfLeafSet * 2, false);
        System.out.println(leafset);
        leafset.addObserver(new MyObserver(leafset));
        NodeHandle handle = leafset.get(halfLeafSet);
        System.out.println("Removing " + handle);
        leafset.remove(handle);
        System.out.println("Adding " + handle);
        leafset.put(handle);
        System.out.println();
        halfLeafSet = 6;
        leafset = this.generateLeafSet(halfLeafSet * 2, halfLeafSet, false);
        System.out.println(leafset);
        leafset.addObserver(new MyObserver(leafset));
        for (int j = 0; j < 10; ++j) {
            System.out.println();
            for (int i = 0; i < halfLeafSet * 5; ++i) {
                handle = new TestNodeHandle(this.factory.generateNodeId());
                System.out.println("Adding " + handle);
                leafset.put(handle);
            }
            boolean rightSide = false;
            while (leafset.size() > 2) {
                int r;
                boolean bl = rightSide = !rightSide;
                if (rightSide) {
                    r = this.random.nextInt(leafset.cwSize());
                    if (r == 0) continue;
                    handle = leafset.get(r);
                    System.out.println("Removing " + handle);
                    leafset.remove(handle);
                    continue;
                }
                r = this.random.nextInt(leafset.ccwSize());
                if (r == 0) continue;
                handle = leafset.get(-r);
                System.out.println("Removing " + handle);
                leafset.remove(handle);
            }
        }
    }

    protected final void assertTrue(String intention, boolean test) {
        if (!test) {
            System.out.println(intention + " - failed.");
            System.exit(0);
        }
    }

    protected int min(int x, int y) {
        if (y < x) {
            return y;
        }
        return x;
    }

    protected int abs(int x) {
        if (x < 0) {
            return -x;
        }
        return x;
    }

    public void testCumulativeRange() {
        for (int nodes = 2; nodes < 20; ++nodes) {
            for (int size = 2; size < 17; size += 2) {
                LeafSet leafset = this.generateLeafSet(size, nodes, false);
                System.out.println("Testing cumulative ranges with " + nodes + " nodes and leafset size of " + size);
                for (int pos = -this.min(size / 2, nodes / 2); pos <= this.min(size / 2, nodes / 2); ++pos) {
                    for (int q = 0; q < size; ++q) {
                        IdRange range = leafset.range(leafset.get(pos), q);
                        if (q < size / 2 - this.abs(pos) || size + 1 > nodes) {
                            this.assertTrue("Range of node " + pos + " with q " + q + " nodes " + nodes + " size " + size + " should be defined in leafset " + leafset, range != null);
                            if (q >= nodes - 1) {
                                this.assertTrue("Range of node " + pos + " with q " + q + " nodes " + nodes + " size " + size + " should be full in leafset " + leafset, range.isFull());
                                continue;
                            }
                            this.assertTrue("Range of node " + pos + " with q " + q + " nodes " + nodes + " size " + size + " should be full in leafset " + leafset, !range.isFull());
                            continue;
                        }
                        this.assertTrue("Range of node " + pos + " with q " + q + " nodes " + nodes + " size " + size + " should be not defined in leafset " + leafset, range == null);
                    }
                }
            }
        }
    }

    public void testNonCumulativeRange() {
        for (int nodes = 1; nodes < 20; ++nodes) {
            for (int size = 2; size < 17; size += 2) {
                int q;
                LeafSet leafset = this.generateLeafSet(size, nodes, false);
                System.out.println("Testing non-cumulative ranges with " + nodes + " nodes and leafset size of " + size);
                for (int pos = -this.min(size / 2, nodes / 2); pos <= this.min(size / 2, nodes / 2); ++pos) {
                    for (q = 0; q < size; ++q) {
                        IdRange range = leafset.range(leafset.get(pos), q, true);
                        if (q < size / 2 - this.abs(pos) || size + 1 > nodes) {
                            this.assertTrue("Range of node " + pos + " with q " + q + " nodes " + nodes + " size " + size + " should not be null in leafset " + leafset, range != null);
                            if (q >= nodes) {
                                this.assertTrue("Range of node " + pos + " with q " + q + " nodes " + nodes + " size " + size + " should be empty in leafset " + leafset, range.isEmpty());
                                continue;
                            }
                            this.assertTrue("Range of node " + pos + " with q " + q + " nodes " + nodes + " size " + size + " should be defined in leafset " + leafset, !range.isEmpty());
                            continue;
                        }
                        this.assertTrue("Range of node " + pos + " with q " + q + " nodes " + nodes + " size " + size + " should be not defined in leafset " + leafset, range == null);
                    }
                }
                if (size + 1 <= nodes) continue;
                IdRange total = new IdRange();
                for (q = 0; q < size; ++q) {
                    total = total.merge(leafset.range(leafset.get(0), q, true));
                    total = total.merge(leafset.range(leafset.get(0), q, false));
                }
                this.assertTrue("Sum of individual ranges should produce entire range with nodes " + nodes + " size " + size + " in leafset " + leafset + " with total " + total, total.isFull());
            }
        }
    }

    protected LeafSet generateLeafSet(int size, int nodes, boolean crossover) {
        int i;
        Object[] handles = new NodeHandle[nodes];
        for (i = 0; i < nodes; ++i) {
            handles[i] = new TestNodeHandle(this.factory.generateNodeId());
        }
        Arrays.sort(handles);
        i = 0;
        i = crossover ? (nodes - size + this.random.nextInt(size)) % nodes : this.random.nextInt(nodes);
        int base = (i + size / 2) % nodes;
        LeafSet set = new LeafSet((NodeHandle)handles[base], size);
        for (int j = 0; j < nodes; ++j) {
            set.put((NodeHandle)handles[j]);
        }
        return set;
    }

    public static void main(String[] args) {
        LeafSetTest test = new LeafSetTest();
        test.start();
    }

    public static class TestNodeHandle
    extends NodeHandle
    implements Comparable {
        private NodeId id;

        public TestNodeHandle(NodeId id) {
            this.id = id;
        }

        public NodeId getNodeId() {
            return this.id;
        }

        public int getLiveness() {
            return 1;
        }

        public int proximity() {
            return 1;
        }

        public boolean ping() {
            return true;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TestNodeHandle) {
                return ((TestNodeHandle)obj).id.equals(this.id);
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public void receiveMessage(Message m) {
        }

        public int compareTo(Object o) {
            return this.id.compareTo(((TestNodeHandle)o).id);
        }

        public String toString() {
            return this.id.toString();
        }
    }

    class MyObserver
    implements Observer {
        LeafSet ls;

        public MyObserver(LeafSet ls) {
            this.ls = ls;
        }

        public void update(Observable arg0, Object arg1) {
            if (arg0 instanceof SimilarSet) {
                SimilarSet similarSet = (SimilarSet)arg0;
            }
            if (this.ls.overlaps() && this.ls.ccwSize() != this.ls.cwSize()) {
                System.out.println("FAILURE: overlaps and different size" + this.ls);
            }
            if (arg1 instanceof NodeSetUpdate) {
                NodeSetUpdate nsu = (NodeSetUpdate)arg1;
                if (nsu.wasAdded()) {
                    boolean consistent;
                    boolean bl = consistent = !this.ls.directTest(nsu.handle());
                    if (!consistent) {
                        System.out.println("FAILURE:" + nsu.handle() + " was added, but ls is inconsistent.");
                        System.out.println(this.ls);
                    } else {
                        System.out.println("OK:" + nsu.handle() + " was added");
                    }
                } else {
                    boolean consistent;
                    boolean bl = consistent = !this.ls.member(nsu.handle().getNodeId());
                    if (!consistent) {
                        System.out.println("FAILURE:" + nsu.handle() + " was removed, but ls is inconsistent.");
                        System.out.println(this.ls);
                    } else {
                        System.out.println("OK:" + nsu.handle() + " was removed");
                    }
                }
            }
        }
    }
}

