/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSet;
import rice.pastry.leafset.LeafSet;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketPastryNodeFactory;

public class PastryNetworkTest {
    protected SocketPastryNodeFactory factory;
    protected InetSocketAddress bootstrap;
    protected HashSet nodes;
    protected HashSet dead;
    protected HashSet unknown;
    int numThreads = 0;

    public PastryNetworkTest(SocketPastryNodeFactory factory, InetSocketAddress bootstrap) {
        this.factory = factory;
        this.bootstrap = bootstrap;
        this.nodes = new HashSet();
        this.dead = new HashSet();
        this.unknown = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap fetchLeafSets() throws Exception {
        final HashMap leafsets = new HashMap();
        final HashSet<NodeHandle> unseen = new HashSet<NodeHandle>();
        unseen.add(this.factory.getNodeHandle(this.bootstrap));
        HashSet<NodeHandle> hashSet = unseen;
        synchronized (hashSet) {
            while (true) {
                if (this.numThreads > 20) {
                    unseen.wait();
                }
                if (unseen.size() > 0) {
                    ++this.numThreads;
                    final SocketNodeHandle handle = (SocketNodeHandle)unseen.iterator().next();
                    unseen.remove(handle);
                    this.nodes.add(handle);
                    System.out.println("Fetching leafset of " + handle + " (thread " + this.numThreads + " of 20)");
                    Thread t = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() {
                            HashSet hashSet;
                            try {
                                try {
                                    LeafSet ls = PastryNetworkTest.this.factory.getLeafSet(handle);
                                    leafsets.put(handle, ls);
                                    NodeSet ns = ls.neighborSet(Integer.MAX_VALUE);
                                    if (!ns.get(0).equals(handle)) {
                                        PastryNetworkTest.this.dead.add(handle);
                                        PastryNetworkTest.this.nodes.remove(handle);
                                        leafsets.remove(handle);
                                        leafsets.put(ns.get(0), ls);
                                    }
                                    for (int i = 1; i < ns.size(); ++i) {
                                        if (PastryNetworkTest.this.nodes.contains(ns.get(i)) || PastryNetworkTest.this.dead.contains(ns.get(i))) continue;
                                        unseen.add(ns.get(i));
                                    }
                                    Object var5_7 = null;
                                    hashSet = unseen;
                                }
                                catch (ConnectException e) {
                                    PastryNetworkTest.this.dead.add(handle);
                                    Object var5_8 = null;
                                    HashSet hashSet3 = unseen;
                                    synchronized (hashSet3) {
                                        --PastryNetworkTest.this.numThreads;
                                        unseen.notifyAll();
                                        return;
                                    }
                                }
                                catch (SocketTimeoutException e) {
                                    PastryNetworkTest.this.unknown.add(handle);
                                    Object var5_9 = null;
                                    HashSet hashSet4 = unseen;
                                    synchronized (hashSet4) {
                                        --PastryNetworkTest.this.numThreads;
                                        unseen.notifyAll();
                                        return;
                                    }
                                }
                                catch (IOException e) {
                                    System.err.println("GOT OTHER ERROR CONNECTING TO " + handle + " - " + e);
                                    Object var5_10 = null;
                                    HashSet hashSet5 = unseen;
                                    synchronized (hashSet5) {
                                        --PastryNetworkTest.this.numThreads;
                                        unseen.notifyAll();
                                        return;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                Object var5_11 = null;
                                HashSet hashSet2 = unseen;
                                synchronized (hashSet2) {
                                    --PastryNetworkTest.this.numThreads;
                                    unseen.notifyAll();
                                    throw throwable;
                                }
                            }
                            synchronized (hashSet) {
                                --PastryNetworkTest.this.numThreads;
                                unseen.notifyAll();
                                return;
                            }
                        }
                    };
                    t.start();
                    continue;
                }
                if (this.numThreads <= 0) break;
                unseen.wait();
            }
        }
        System.out.println("Fetched all leafsets - return...  Found " + this.nodes.size() + " nodes.");
        return leafsets;
    }

    protected void testLeafSets() throws Exception {
        HashMap leafsets = this.fetchLeafSets();
        Iterator sets = leafsets.values().iterator();
        while (sets.hasNext()) {
            Iterator nodes = leafsets.keySet().iterator();
            LeafSet set = (LeafSet)sets.next();
            if (set == null) continue;
            while (nodes.hasNext()) {
                NodeHandle node = (NodeHandle)nodes.next();
                if (this.dead.contains(node) && set.member(node)) {
                    System.err.println("LEAFSET ERROR: Leafset for " + set.get(0) + " contains dead node " + node);
                    continue;
                }
                if (this.dead.contains(node) || !set.isComplete() || !set.test(node)) continue;
                System.err.println("LEAFSET ERROR: Leafset for " + set.get(0) + " is missing " + node);
            }
        }
        System.out.println("Done testing...");
    }

    protected HashMap fetchRouteRow(int row) throws IOException {
        HashMap<NodeHandle, RouteSet[]> routerows = new HashMap<NodeHandle, RouteSet[]>();
        Iterator i = this.nodes.iterator();
        while (i.hasNext()) {
            NodeHandle handle = (NodeHandle)i.next();
            System.out.println("Fetching route row " + row + " of " + handle);
            RouteSet[] set = this.factory.getRouteRow(handle, row);
            if (set == null) continue;
            routerows.put(handle, set);
        }
        System.out.println("Fetched all route rows - return...");
        return routerows;
    }

    protected void testRouteRow(int row) throws IOException {
        HashMap routerows = this.fetchRouteRow(row);
        Iterator i = this.nodes.iterator();
        while (i.hasNext()) {
            NodeHandle node = (NodeHandle)i.next();
            RoutingTable rt = new RoutingTable(node, 1);
            Iterator j = this.nodes.iterator();
            while (j.hasNext()) {
                rt.put((NodeHandle)j.next());
            }
            RouteSet[] ideal = rt.getRow(row);
            RouteSet[] actual = (RouteSet[])routerows.get(node);
            for (int k = 0; k < ideal.length; ++k) {
                if ((actual[k] == null || actual[k].size() == 0) && ideal[k] != null && ideal[k].size() > 0) {
                    System.err.println("ROUTING TABLE ERROR: " + node + " has no entry in row " + row + " column " + k + " but " + ideal[k].get(0) + " exists");
                }
                if (actual[k] == null || actual[k].size() <= 0 || ideal[k] != null && ideal[k].size() != 0) continue;
                System.err.println("ROUTING TABLE ERROR: " + node + " has no non-existent entry in row " + row + " column " + k + " entry " + actual[k].get(0) + " exists");
            }
        }
        System.out.println("Done testing...");
    }

    protected void testRoutingTables() throws Exception {
        this.testRouteRow(39);
        this.testRouteRow(38);
    }

    public void start() throws Exception {
        this.testLeafSets();
        this.testRoutingTables();
    }

    public static void main(String[] args) throws Exception {
        PastryNetworkTest test = new PastryNetworkTest(new SocketPastryNodeFactory(null, 1), new InetSocketAddress(args[0], Integer.parseInt(args[1])));
        test.start();
    }
}

