/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastrySeed;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.EuclideanNetwork;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.pastry.testing.PingClient;

public class PastryTest {
    private DirectPastryNodeFactory factory;
    private NetworkSimulator simulator = new EuclideanNetwork();
    private Vector pastryNodes;
    private Vector pingClients;
    private Random rng;

    public PastryTest() {
        this.factory = new DirectPastryNodeFactory(new RandomNodeIdFactory(), this.simulator);
        this.pastryNodes = new Vector();
        this.pingClients = new Vector();
        this.rng = new Random(PastrySeed.getSeed());
    }

    private NodeHandle getBootstrap() {
        NodeHandle bootstrap = null;
        try {
            PastryNode lastnode = (PastryNode)this.pastryNodes.lastElement();
            bootstrap = lastnode.getLocalHandle();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return bootstrap;
    }

    public void makePastryNode() {
        PastryNode pn = this.factory.newNode(this.getBootstrap());
        this.pastryNodes.addElement(pn);
        PingClient pc = new PingClient(pn);
        this.pingClients.addElement(pc);
    }

    public void sendPings(int k) {
        int n = this.pingClients.size();
        for (int i = 0; i < k; ++i) {
            int from = this.rng.nextInt(n);
            int to = this.rng.nextInt(n);
            PingClient pc = (PingClient)this.pingClients.get(from);
            PastryNode pn = (PastryNode)this.pastryNodes.get(to);
            pc.sendTrace(pn.getNodeId());
            while (this.simulate()) {
            }
            System.out.println("-------------------");
        }
    }

    public boolean simulate() {
        return this.simulator.simulate();
    }

    public static void main(String[] args) {
        PastryTest pt = new PastryTest();
        int n = 4000;
        int m = 100;
        int k = 10;
        int msgCount = 0;
        Date old = new Date();
        for (int i = 0; i < n; ++i) {
            pt.makePastryNode();
            while (pt.simulate()) {
                ++msgCount;
            }
            if ((i + 1) % m != 0) continue;
            Date now = new Date();
            System.out.println(i + 1 + " " + (now.getTime() - old.getTime()) + " " + msgCount);
            msgCount = 0;
            old = now;
        }
        System.out.println(n + " nodes constructed");
        pt.sendPings(k);
    }
}

