/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.routing.SendOptions;
import rice.pastry.security.Credentials;
import rice.pastry.security.PermissiveCredentials;
import rice.pastry.testing.PingAddress;
import rice.pastry.testing.PingMessageNew;
import rice.pastry.testing.PingTestRecord;

public class Ping
extends PastryAppl {
    private Credentials pingCred = new PermissiveCredentials();
    private static Address pingAddress = new PingAddress();

    public Ping(PastryNode pn) {
        super(pn);
    }

    public Address getAddress() {
        return pingAddress;
    }

    public Credentials getCredentials() {
        return this.pingCred;
    }

    public void sendPing(NodeId nid) {
        this.routeMsg(nid, new PingMessageNew(pingAddress, this.getNodeId(), nid), this.pingCred, new SendOptions());
    }

    public void messageForAppl(Message msg) {
        PingMessageNew pMsg = (PingMessageNew)msg;
        int nHops = pMsg.getHops() - 1;
        double fDistance = pMsg.getDistance();
        NetworkSimulator sim = ((DirectNodeHandle)((DirectPastryNode)this.thePastryNode).getLocalHandle()).getSimulator();
        PingTestRecord tr = (PingTestRecord)sim.getTestRecord();
        double dDistance = sim.proximity(this.thePastryNode.getNodeId(), pMsg.getSource());
        double rDistance = dDistance == 0.0 ? 0.0 : fDistance / dDistance;
        tr.addHops(nHops);
        tr.addDistance(rDistance);
    }

    public boolean enrouteMessage(Message msg, Id from, NodeId nextHop, SendOptions opt) {
        PingMessageNew pMsg = (PingMessageNew)msg;
        pMsg.incrHops();
        pMsg.incrDistance(((DirectNodeHandle)((DirectPastryNode)this.thePastryNode).getLocalHandle()).getSimulator().proximity(this.thePastryNode.getNodeId(), nextHop));
        return true;
    }

    public void leafSetChange(NodeHandle nh, boolean wasAdded) {
    }

    public void routeSetChange(NodeHandle nh, boolean wasAdded) {
    }
}

