/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.routing.SendOptions;
import rice.pastry.security.Credentials;
import rice.pastry.security.PermissiveCredentials;
import rice.pastry.testing.PingMessage;

public class PingClient
extends PastryAppl {
    private Credentials pingCred = new PermissiveCredentials();
    private static Address pingAddress = new PingAddress();

    public PingClient(PastryNode pn) {
        super(pn);
    }

    public Address getAddress() {
        return pingAddress;
    }

    public Credentials getCredentials() {
        return this.pingCred;
    }

    public void sendPing(NodeId nid) {
        this.routeMsg(nid, new PingMessage(pingAddress, this.getNodeId(), nid), this.pingCred, new SendOptions());
    }

    public void sendTrace(NodeId nid) {
        System.out.println("sending a trace from " + this.getNodeId() + " to " + nid);
        this.routeMsg(nid, new PingMessage(pingAddress, this.getNodeId(), nid), this.pingCred, new SendOptions());
    }

    public void messageForAppl(Message msg) {
        System.out.print(msg);
        System.out.println(" received");
    }

    public boolean enrouteMessage(Message msg, Id from, NodeId nextHop, SendOptions opt) {
        System.out.print(msg);
        System.out.println(" at " + this.getNodeId());
        return true;
    }

    public void leafSetChange(NodeHandle nh, boolean wasAdded) {
        System.out.println("at... " + this.getNodeId() + "'s leaf set");
        System.out.print("node " + nh.getNodeId() + " was ");
        if (wasAdded) {
            System.out.println("added");
        } else {
            System.out.println("removed");
        }
    }

    public void routeSetChange(NodeHandle nh, boolean wasAdded) {
        System.out.println("at... " + this.getNodeId() + "'s route set");
        System.out.print("node " + nh.getNodeId() + " was ");
        if (wasAdded) {
            System.out.println("added");
        } else {
            System.out.println("removed");
        }
    }

    private static class PingAddress
    implements Address {
        private int myCode = -1843799809;

        private PingAddress() {
        }

        public int hashCode() {
            return this.myCode;
        }

        public boolean equals(Object obj) {
            return obj instanceof PingAddress;
        }

        public String toString() {
            return "[PingAddress]";
        }
    }
}

