/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastrySeed;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.EuclideanNetwork;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.TestRecord;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.pastry.testing.Ping;

public class SinglePingTest {
    private DirectPastryNodeFactory factory;
    private NetworkSimulator simulator = new EuclideanNetwork();
    private TestRecord testRecord;
    private Vector pastryNodes;
    private Vector pingClients;
    private Random rng;

    public SinglePingTest(TestRecord tr) {
        this.factory = new DirectPastryNodeFactory(new RandomNodeIdFactory(), this.simulator);
        this.simulator.setTestRecord(tr);
        this.testRecord = tr;
        this.pastryNodes = new Vector();
        this.pingClients = new Vector();
        this.rng = new Random(PastrySeed.getSeed());
    }

    private NodeHandle getBootstrap() {
        NodeHandle bootstrap = null;
        try {
            PastryNode lastnode = (PastryNode)this.pastryNodes.lastElement();
            bootstrap = lastnode.getLocalHandle();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return bootstrap;
    }

    public void makePastryNode() {
        PastryNode pn = this.factory.newNode(this.getBootstrap());
        this.pastryNodes.addElement(pn);
        Ping pc = new Ping(pn);
        this.pingClients.addElement(pc);
    }

    public void sendPings(int k) {
        int n = this.pingClients.size();
        for (int i = 0; i < k; ++i) {
            int from = this.rng.nextInt(n);
            int to = this.rng.nextInt(n);
            Ping pc = (Ping)this.pingClients.get(from);
            PastryNode pn = (PastryNode)this.pastryNodes.get(to);
            pc.sendPing(pn.getNodeId());
            while (this.simulate()) {
            }
        }
    }

    public boolean simulate() {
        return this.simulator.simulate();
    }

    public void checkRoutingTable() {
        int i;
        Date prev = new Date();
        for (i = 0; i < this.testRecord.getNodeNumber(); ++i) {
            this.makePastryNode();
            while (this.simulate()) {
            }
            if (i == 0 || i % 1000 != 0) continue;
            System.out.println(i + " nodes constructed");
        }
        System.out.println(i + " nodes constructed");
        Date curr = new Date();
        long msec = curr.getTime() - prev.getTime();
        System.out.println("time used " + msec / 60000L + ":" + msec % 60000L / 1000L + ":" + msec % 60000L % 1000L);
    }

    public void test() {
        int i;
        Date prev = new Date();
        System.out.println("-------------------------");
        for (i = 0; i < this.testRecord.getNodeNumber(); ++i) {
            this.makePastryNode();
            while (this.simulate()) {
            }
            if (i == 0 || i % 500 != 0) continue;
            System.out.println(i + " nodes constructed");
        }
        System.out.println(i + " nodes constructed");
        Date curr = new Date();
        long msec = curr.getTime() - prev.getTime();
        System.out.println("time used " + msec / 60000L + ":" + msec % 60000L / 1000L + ":" + msec % 60000L % 1000L);
        prev = curr;
        this.sendPings(this.testRecord.getTestNumber());
        System.out.println(this.testRecord.getTestNumber() + " lookups done");
        curr = new Date();
        msec = curr.getTime() - prev.getTime();
        System.out.println("time used " + msec / 60000L + ":" + msec % 60000L / 1000L + ":" + msec % 60000L % 1000L);
        this.testRecord.doneTest();
    }
}

