/*
 * Decompiled with CFR 0.152.
 */
package rice.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.SortedMap;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import rice.Continuation;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.util.ImmutableSortedMap;
import rice.p2p.util.RedBlackMap;
import rice.p2p.util.ReverseTreeMap;
import rice.p2p.util.XMLObjectInputStream;
import rice.p2p.util.XMLObjectOutputStream;
import rice.persistence.Storage;
import rice.selector.SelectorManager;
import rice.selector.Timer;
import rice.selector.TimerTask;

public class PersistentStorage
implements Storage {
    private Object statLock = new Object();
    private long statsLastWritten = System.currentTimeMillis();
    private long statsWriteInterval = 60000L;
    private long numWrites = 0L;
    private long numReads = 0L;
    private long numRenames = 0L;
    private long numDeletes = 0L;
    private long numMetadataWrites = 0L;
    private IdFactory factory;
    private String name;
    private File rootDirectory;
    private File backupDirectory;
    private File appDirectory;
    private File lostDirectory;
    private boolean index;
    private HashMap directories;
    private HashSet dirty;
    private ReverseTreeMap metadata;
    private String rootDir;
    private long storageSize;
    private long usedSize;
    private Random rng;
    private static boolean logWriteTypes = false;
    public static final long PERSISTENCE_MAGIC_NUMBER = 8038844221L;
    public static final long PERSISTENCE_VERSION_2 = 2L;
    public static final long PERSISTENCE_REVISION_2_0 = 0L;
    public static final String BACKUP_DIRECTORY = "/FreePastry-Storage-Root/";
    public static final String LOST_AND_FOUND_DIRECTORY = "lost+found";
    public static final String METADATA_FILENAME = "metadata.cache";
    public static final String METADATA_FILENAME_EXTENSION = ".metadata";
    public static final int MAX_FILES = 256;
    public static final int MAX_DIRECTORIES = 32;
    public static final int METADATA_SYNC_TIME = 300000;
    public static final boolean DEBUG = false;
    public static WorkQueue QUEUE = new WorkQueue();
    public static Thread WORK_THREAD = new PersistenceThread(QUEUE);
    protected static final boolean verbose = false;

    public PersistentStorage(IdFactory factory, String rootDir, int size) throws IOException {
        this(factory, "default", rootDir, size);
    }

    public PersistentStorage(IdFactory factory, String name, String rootDir, int size) throws IOException {
        this(factory, name, rootDir, size, true);
    }

    public PersistentStorage(IdFactory factory, String name, String rootDir, int size, boolean index) throws IOException {
        this.factory = factory;
        this.name = name;
        this.rootDir = rootDir;
        this.storageSize = size;
        this.index = index;
        this.rng = new Random();
        this.directories = new HashMap();
        if (index) {
            this.dirty = new HashSet();
            this.metadata = new ReverseTreeMap();
        }
        this.debug("Launching persistent storage in " + rootDir + " with name " + name + " spliting factor " + 256);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable getMetadata(Id id) {
        if (this.index) {
            ReverseTreeMap reverseTreeMap = this.metadata;
            synchronized (reverseTreeMap) {
                return (Serializable)this.metadata.get(id);
            }
        }
        throw new UnsupportedOperationException("getMetadata() not supported without indexing");
    }

    public void getObject(final Id id, Continuation c) {
        this.printStats();
        if (this.index && !this.exists(id)) {
            c.receiveResult(null);
        } else {
            QUEUE.enqueue(new WorkRequest(c){

                public String toString() {
                    return "getObject " + id;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object doWork() throws Exception {
                    Object object = PersistentStorage.this.statLock;
                    synchronized (object) {
                        PersistentStorage.this.numReads++;
                    }
                    File objFile = PersistentStorage.this.getFile(id);
                    try {
                        if (objFile == null || !objFile.exists()) {
                            return null;
                        }
                        return PersistentStorage.readData(objFile);
                    }
                    catch (Exception e) {
                        if (PersistentStorage.this.index) {
                            ReverseTreeMap reverseTreeMap = PersistentStorage.this.metadata;
                            synchronized (reverseTreeMap) {
                                PersistentStorage.this.metadata.remove(id);
                                PersistentStorage.this.dirty.add(objFile.getParentFile());
                            }
                        }
                        PersistentStorage.this.moveToLost(objFile);
                        throw e;
                    }
                }
            });
        }
    }

    public long getTotalSize() {
        return this.usedSize;
    }

    public int getSize() {
        if (this.index) {
            return this.metadata.size();
        }
        throw new UnsupportedOperationException("getSize() not supported without indexing");
    }

    private String[] getMatchingDirectories(String prefix, String[] dirNames) {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < dirNames.length; ++i) {
            if (!dirNames[i].startsWith(prefix)) continue;
            result.add(dirNames[i]);
        }
        return result.toArray(new String[0]);
    }

    private String[] getDirectories(String[] names, int offset) {
        int length = this.getPrefixLength(names);
        String prefix = names[0].substring(0, length);
        CharacterHashSet set = new CharacterHashSet();
        for (int i = 0; i < names.length; ++i) {
            set.put(names[i].charAt(length));
        }
        char[] splits = set.get();
        String[] result = new String[splits.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = prefix.substring(offset) + splits[i];
        }
        return result;
    }

    private int getPrefixLength(String[] names) {
        int length = names[0].length();
        for (int i = 0; i < names.length; ++i) {
            length = this.getPrefixLength(names[0], names[i], length);
        }
        return length;
    }

    private int getPrefixLength(String a, String b, int max) {
        int i;
        for (i = 0; i < a.length() && i < b.length() && i < max; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return i;
        }
        return i;
    }

    private boolean isAncestor(File file, File ancestor) {
        while (file != null && !file.equals(ancestor)) {
            file = file.getParentFile();
        }
        return file != null;
    }

    private File getFile(Id id) throws IOException {
        return new File(this.getDirectoryForId(id), id.toStringFull());
    }

    private File getDirectoryForId(Id id) throws IOException {
        return this.getDirectoryForName(id.toStringFull());
    }

    private File getDirectoryForName(String name) throws IOException {
        return this.getDirectoryForName(name, this.appDirectory);
    }

    private File getDirectoryForName(String name, File dir) throws IOException {
        File[] subDirs = (File[])this.directories.get(dir);
        if (subDirs.length == 0) {
            return dir;
        }
        for (int i = 0; i < subDirs.length; ++i) {
            if (!name.startsWith(subDirs[i].getName())) continue;
            return this.getDirectoryForName(name.substring(subDirs[i].getName().length()), subDirs[i]);
        }
        if (name.length() >= subDirs[0].getName().length()) {
            File newDir = new File(dir, name.substring(0, subDirs[0].getName().length()));
            this.debug("Necessarily creating dir " + newDir.getName());
            PersistentStorage.createDirectory(newDir);
            this.directories.put(dir, this.append(subDirs, newDir));
            this.directories.put(newDir, new File[0]);
            if (this.checkDirectory(dir)) {
                return this.getDirectoryForName(name, dir);
            }
            return newDir;
        }
        String[] dirs = new String[subDirs.length + 1];
        for (int i = 0; i < subDirs.length; ++i) {
            dirs[i] = subDirs[i].getName();
        }
        dirs[subDirs.length] = name;
        this.reformatDirectory(dir, this.getDirectories(dirs, 0));
        return this.getDirectoryForName(name, dir);
    }

    private int getPrefixLength(File dir) {
        if (dir.equals(this.appDirectory)) {
            return 0;
        }
        return dir.getName().length() + this.getPrefixLength(dir.getParentFile());
    }

    private boolean isFile(File parent, String name) {
        return name.length() >= this.factory.getIdToStringLength();
    }

    private boolean isDirectory(File parent, String name) {
        return name.length() < this.factory.getIdToStringLength() && new File(parent, name).isDirectory();
    }

    protected IdRange getRangeForDirectory(File dir) {
        String result = "";
        while (!dir.equals(this.appDirectory)) {
            result = dir.getName() + result;
            dir = dir.getParentFile();
        }
        return this.factory.buildIdRangeFromPrefix(result);
    }

    public String getRoot() {
        return this.rootDir;
    }

    public long getStorageSize() {
        if (this.storageSize > 0L) {
            return this.storageSize;
        }
        return Long.MAX_VALUE;
    }

    private long getUsedSpace() {
        return this.usedSize;
    }

    public String getName() {
        return this.name;
    }

    public void setTimer(Timer timer) {
        if (this.index) {
            timer.scheduleAtFixedRate(new TimerTask(){

                public String toString() {
                    return "persistence dirty purge enqueue";
                }

                public void run() {
                    QUEUE.enqueue(new WorkRequest(this, (Continuation)new Continuation.ListenerContinuation("Enqueue of writeMetadataFile")){
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public String toString() {
                            return "persistence dirty purge";
                        }

                        public Object doWork() throws Exception {
                            4.access$900(this.this$1).writeDirty();
                            return Boolean.TRUE;
                        }
                    });
                }

                static /* synthetic */ PersistentStorage access$900(4 x0) {
                    return x0.PersistentStorage.this;
                }
            }, new Random(this.name.hashCode()).nextInt(300000), 300000L);
        }
    }

    public void setMetadata(final Id id, final Serializable metadata, Continuation c) {
        this.printStats();
        if (!this.exists(id)) {
            c.receiveResult(new Boolean(false));
        } else {
            QUEUE.enqueue(new WorkRequest(c){

                public String toString() {
                    return "setMetadata " + id;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object doWork() throws Exception {
                    Object object = PersistentStorage.this.statLock;
                    synchronized (object) {
                        PersistentStorage.this.numMetadataWrites++;
                    }
                    File objFile = PersistentStorage.this.getFile(id);
                    PersistentStorage.writeMetadata(objFile, metadata);
                    if (PersistentStorage.this.index) {
                        ReverseTreeMap reverseTreeMap = PersistentStorage.this.metadata;
                        synchronized (reverseTreeMap) {
                            PersistentStorage.this.metadata.put(id, metadata);
                            PersistentStorage.this.dirty.add(objFile.getParentFile());
                        }
                    }
                    return Boolean.TRUE;
                }
            });
        }
    }

    public boolean setRoot(String dir) {
        this.rootDir = dir;
        return true;
    }

    public boolean setStorageSize(int size) {
        if (this.storageSize <= (long)size) {
            this.storageSize = size;
            return true;
        }
        if ((long)size > this.usedSize) {
            this.storageSize = size;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStats() {
        if (logWriteTypes) {
            Object object = this.statLock;
            synchronized (object) {
                long now = System.currentTimeMillis();
                if (this.statsLastWritten / this.statsWriteInterval != now / this.statsWriteInterval) {
                    System.out.println("@L.PE name=" + this.name + " interval=" + this.statsLastWritten + "-" + now);
                    this.statsLastWritten = now;
                    System.out.println("@L.PE   objsTotal=" + (this.index ? "" + this.metadata.keySet().size() : "?") + " objsBytesTotal=" + this.getTotalSize());
                    System.out.println("@L.PE   numWrites=" + this.numWrites + " numReads=" + this.numReads + " numDeletes=" + this.numDeletes);
                    System.out.println("@L.PE   numMetadataWrites=" + this.numMetadataWrites + " numRenames=" + this.numRenames);
                }
            }
        }
    }

    public void rename(final Id oldId, final Id newId, Continuation c) {
        this.printStats();
        QUEUE.enqueue(new WorkRequest(c){

            public String toString() {
                return "rename " + oldId + " " + newId;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doWork() throws Exception {
                Object object = PersistentStorage.this.statLock;
                synchronized (object) {
                    PersistentStorage.this.numRenames++;
                }
                File f = PersistentStorage.this.getFile(oldId);
                if (f != null && f.exists()) {
                    File g = PersistentStorage.this.getFile(newId);
                    PersistentStorage.renameFile(f, g);
                    PersistentStorage.this.checkDirectory(g.getParentFile());
                    if (PersistentStorage.this.index) {
                        ReverseTreeMap reverseTreeMap = PersistentStorage.this.metadata;
                        synchronized (reverseTreeMap) {
                            PersistentStorage.this.metadata.put(newId, PersistentStorage.this.metadata.get(oldId));
                            PersistentStorage.this.metadata.remove(oldId);
                        }
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
    }

    public void store(final Id id, final Serializable metadata, final Serializable obj, Continuation c) {
        this.printStats();
        QUEUE.enqueue(new WorkRequest(c){

            public String toString() {
                return "store " + id;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doWork() throws Exception {
                Object object = PersistentStorage.this.statLock;
                synchronized (object) {
                    PersistentStorage.this.numWrites++;
                }
                PersistentStorage.this.debug("Storing object " + obj + " under id " + id + " in root " + PersistentStorage.this.appDirectory);
                File objFile = PersistentStorage.this.getFile(id);
                File transcFile = PersistentStorage.this.makeTemporaryFile(id);
                try {
                    PersistentStorage.writeObject(obj, metadata, id, System.currentTimeMillis(), transcFile);
                    PersistentStorage.this.debug("Done writing object " + obj + " under id " + id + " in root " + PersistentStorage.this.appDirectory);
                    if (PersistentStorage.this.getUsedSpace() + PersistentStorage.getFileLength(transcFile) > PersistentStorage.this.getStorageSize()) {
                        throw new OutofDiskSpaceException();
                    }
                }
                catch (Exception e) {
                    PersistentStorage.deleteFile(transcFile);
                    throw e;
                }
                PersistentStorage.this.decreaseUsedSpace(PersistentStorage.getFileLength(objFile));
                PersistentStorage.this.increaseUsedSpace(PersistentStorage.getFileLength(transcFile));
                PersistentStorage.renameFile(transcFile, objFile);
                if (PersistentStorage.this.index) {
                    ReverseTreeMap reverseTreeMap = PersistentStorage.this.metadata;
                    synchronized (reverseTreeMap) {
                        PersistentStorage.this.metadata.put(id, metadata);
                        PersistentStorage.this.dirty.add(objFile.getParentFile());
                    }
                }
                PersistentStorage.this.checkDirectory(objFile.getParentFile());
                return Boolean.TRUE;
            }
        });
    }

    public void unstore(final Id id, Continuation c) {
        this.printStats();
        QUEUE.enqueue(new WorkRequest(c){

            public String toString() {
                return "unstore " + id;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doWork() throws Exception {
                Object object = PersistentStorage.this.statLock;
                synchronized (object) {
                    PersistentStorage.this.numDeletes++;
                }
                File objFile = PersistentStorage.this.getFile(id);
                if (PersistentStorage.this.index) {
                    ReverseTreeMap reverseTreeMap = PersistentStorage.this.metadata;
                    synchronized (reverseTreeMap) {
                        PersistentStorage.this.metadata.remove(id);
                        PersistentStorage.this.dirty.add(objFile.getParentFile());
                    }
                }
                if (objFile == null || !objFile.exists()) {
                    return Boolean.FALSE;
                }
                PersistentStorage.this.decreaseUsedSpace(objFile.length());
                PersistentStorage.deleteFile(objFile);
                return Boolean.TRUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(Id id) {
        if (this.index) {
            ReverseTreeMap reverseTreeMap = this.metadata;
            synchronized (reverseTreeMap) {
                return this.metadata.containsKey(id);
            }
        }
        throw new UnsupportedOperationException("exists() not supported without indexing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdSet scan(IdRange range) {
        if (this.index) {
            if (range.isEmpty()) {
                return this.factory.buildIdSet();
            }
            if (range.getCCWId().equals(range.getCWId())) {
                return this.scan();
            }
            ReverseTreeMap reverseTreeMap = this.metadata;
            synchronized (reverseTreeMap) {
                return this.factory.buildIdSet(new ImmutableSortedMap(this.metadata.keySubMap(range.getCCWId(), range.getCWId())));
            }
        }
        throw new UnsupportedOperationException("scan() not supported without indexing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdSet scan() {
        if (this.index) {
            ReverseTreeMap reverseTreeMap = this.metadata;
            synchronized (reverseTreeMap) {
                return this.factory.buildIdSet(new ImmutableSortedMap(this.metadata.keyMap()));
            }
        }
        throw new UnsupportedOperationException("scan() not supported without indexing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap scanMetadata(IdRange range) {
        if (this.index) {
            if (range.isEmpty()) {
                return new RedBlackMap();
            }
            if (range.getCCWId().equals(range.getCWId())) {
                return this.scanMetadata();
            }
            ReverseTreeMap reverseTreeMap = this.metadata;
            synchronized (reverseTreeMap) {
                return new ImmutableSortedMap(this.metadata.keySubMap(range.getCCWId(), range.getCWId()));
            }
        }
        throw new UnsupportedOperationException("scanMetadata() not supported without indexing");
    }

    public SortedMap scanMetadata() {
        if (this.index) {
            return new ImmutableSortedMap(this.metadata.keyMap());
        }
        throw new UnsupportedOperationException("scanMetadata() not supported without indexing");
    }

    public SortedMap scanMetadataValuesHead(Object value) {
        if (this.index) {
            return new ImmutableSortedMap(this.metadata.valueHeadMap(value));
        }
        throw new UnsupportedOperationException("scanMetadataValuesHead() not supported without indexing");
    }

    public SortedMap scanMetadataValuesNull() {
        if (this.index) {
            return new ImmutableSortedMap(this.metadata.valueNullMap());
        }
        throw new UnsupportedOperationException("scanMetadataValuesNull() not supported without indexing");
    }

    private void init() throws IOException {
        this.debug("Initing directories");
        this.initDirectories();
        this.debug("Initing directory map");
        this.initDirectoryMap(this.appDirectory);
        this.debug("Initing files");
        this.initFiles(this.appDirectory);
        this.debug("Initing file map");
        this.initFileMap(this.appDirectory);
        this.debug("Syncing metadata");
        if (this.index) {
            this.writeDirty();
        }
        this.debug("Done initing");
    }

    private void initDirectories() throws IOException {
        this.rootDirectory = new File(this.rootDir);
        PersistentStorage.createDirectory(this.rootDirectory);
        this.backupDirectory = new File(this.rootDirectory, BACKUP_DIRECTORY);
        PersistentStorage.createDirectory(this.backupDirectory);
        this.appDirectory = new File(this.backupDirectory, this.getName());
        PersistentStorage.createDirectory(this.appDirectory);
        this.lostDirectory = new File(this.backupDirectory, LOST_AND_FOUND_DIRECTORY);
        PersistentStorage.createDirectory(this.lostDirectory);
    }

    private void initDirectoryMap(File dir) {
        File[] files = dir.listFiles(new DirectoryFilter());
        this.directories.put(dir, files);
        for (int i = 0; i < files.length; ++i) {
            this.initDirectoryMap(files[i]);
        }
    }

    private void initFiles(File dir) throws IOException {
        String[] files = dir.list();
        boolean metadata = true;
        for (int i = 0; i < files.length; ++i) {
            if (this.isFile(dir, files[i])) {
                try {
                    files[i] = this.initTemporaryFile(dir, files[i]);
                    if (files[i] == null) continue;
                    this.moveFileToCorrectDirectory(dir, files[i]);
                }
                catch (Exception e) {
                    this.moveToLost(new File(dir, files[i]));
                }
                continue;
            }
            if (!this.isDirectory(dir, files[i])) continue;
            this.initFiles(new File(dir, files[i]));
            metadata = false;
        }
        if (!metadata) {
            PersistentStorage.deleteFile(new File(dir, METADATA_FILENAME));
        }
    }

    private String initTemporaryFile(File parent, String name) throws IOException {
        if (!PersistentStorage.isTemporaryFile(name)) {
            return name;
        }
        this.moveToLost(new File(parent, name));
        return null;
    }

    private void initFileMap(File dir) throws IOException {
        this.checkDirectory(dir);
        long modified = 0L;
        if (this.index) {
            try {
                modified = this.readMetadataFile(dir);
            }
            catch (IOException e) {
                System.out.println("ERROR: Got exception " + e + " reading metadata file - regenerating");
            }
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            try {
                if (this.isFile(dir, files[i].getName())) {
                    Id id = this.readKey(files[i]);
                    long len = PersistentStorage.getFileLength(files[i]);
                    if (id == null) {
                        System.out.println("READING " + files[i] + " RETURNED NULL!");
                    }
                    if (len > 0L) {
                        this.increaseUsedSpace(len);
                        if (!this.index || this.metadata.containsKey(id) && files[i].lastModified() <= modified) continue;
                        this.metadata.put(id, PersistentStorage.readMetadata(files[i]));
                        this.dirty.add(dir);
                        continue;
                    }
                    this.moveToLost(files[i]);
                    if (!this.index || !this.metadata.containsKey(id)) continue;
                    this.metadata.remove(id);
                    this.dirty.add(dir);
                    continue;
                }
                if (!files[i].isDirectory()) continue;
                this.initFileMap(files[i]);
                continue;
            }
            catch (Exception e) {
                System.err.println("ERROR: Received Exception " + e + " while initing file " + files[i] + " - moving to lost+found.");
                e.printStackTrace();
                this.moveToLost(files[i]);
            }
        }
    }

    private void resolveConflict(File file1, File file2, File output) throws IOException {
        if (!file2.exists()) {
            PersistentStorage.renameFile(file1, output);
        } else if (!file1.exists()) {
            PersistentStorage.renameFile(file2, output);
        } else if (file1.equals(file2)) {
            PersistentStorage.renameFile(file1, output);
        } else {
            this.debug("resolving conflict between " + file1 + " and " + file2);
            if (PersistentStorage.readVersion(file1) < PersistentStorage.readVersion(file2)) {
                this.moveToLost(file1);
                PersistentStorage.renameFile(file2, output);
            } else {
                this.moveToLost(file2);
                PersistentStorage.renameFile(file1, output);
            }
        }
    }

    private void moveToLost(File file) throws IOException {
        PersistentStorage.renameFile(file, new File(this.lostDirectory, file.getName()));
    }

    private void checkFile(File file) throws IOException {
        if (!this.getDirectoryForName(file.getName()).equals(file.getParentFile())) {
            this.moveFileToCorrectDirectory(file);
        }
    }

    private boolean checkDirectory(File directory) throws IOException {
        this.debug("Checking directory " + directory + " for oversize");
        if (this.numFilesDir(directory) > 256) {
            this.expandDirectory(directory);
            return true;
        }
        if (this.numDirectoriesDir(directory) > 32) {
            this.reformatDirectory(directory);
            return true;
        }
        return false;
    }

    private void reformatDirectory(File dir) throws IOException {
        this.debug("Expanding directory " + dir + " due to too many subdirectories");
        String[] newDirNames = this.getDirectories(dir.list(new DirectoryFilter()), 0);
        this.reformatDirectory(dir, newDirNames);
        this.debug("Done expanding directory " + dir);
    }

    private void reformatDirectory(File dir, String[] newDirNames) throws IOException {
        String[] dirNames = dir.list(new DirectoryFilter());
        File[] newDirs = new File[newDirNames.length];
        for (int i = 0; i < newDirNames.length; ++i) {
            newDirs[i] = new File(dir, newDirNames[i]);
            PersistentStorage.createDirectory(newDirs[i]);
            this.debug("creating directory " + newDirNames[i]);
            String[] subDirNames = this.getMatchingDirectories(newDirNames[i], dirNames);
            File[] newSubDirs = new File[subDirNames.length];
            for (int j = 0; j < subDirNames.length; ++j) {
                File oldDir = new File(dir, subDirNames[j]);
                newSubDirs[j] = new File(newDirs[i], subDirNames[j].substring(newDirNames[i].length()));
                this.debug("moving the old direcotry " + oldDir + " to " + newSubDirs[j]);
                PersistentStorage.renameFile(oldDir, newSubDirs[j]);
                this.directories.remove(oldDir);
                this.directories.put(newSubDirs[j], new File[0]);
            }
            this.directories.put(newDirs[i], newSubDirs);
        }
        this.directories.put(dir, newDirs);
    }

    private void expandDirectory(File dir) throws IOException {
        this.debug("Expanding directory " + dir + " due to too many files");
        String[] fileNames = dir.list(new FileFilter());
        String[] dirNames = this.getDirectories(fileNames, this.getPrefixLength(dir));
        File[] dirs = new File[dirNames.length];
        for (int i = 0; i < dirNames.length; ++i) {
            dirs[i] = new File(dir, dirNames[i]);
            this.directories.put(dirs[i], new File[0]);
            PersistentStorage.createDirectory(dirs[i]);
            this.debug("creating directory " + dirNames[i]);
            if (!this.index) continue;
            this.dirty.add(dirs[i]);
        }
        this.directories.put(dir, dirs);
        File[] files = dir.listFiles(new FileFilter());
        for (int i = 0; i < files.length; ++i) {
            this.moveFileToCorrectDirectory(files[i]);
        }
        PersistentStorage.deleteFile(new File(dir, METADATA_FILENAME));
        this.debug("Done expanding directory " + dir);
    }

    private void moveFileToCorrectDirectory(File file) throws IOException {
        this.moveFileToCorrectDirectory(file.getParentFile(), file.getName());
    }

    private void moveFileToCorrectDirectory(File parent, String name) throws IOException {
        File real = this.getDirectoryForName(name);
        if (!real.equals(parent)) {
            File file = new File(parent, name);
            File other = new File(real, file.getName());
            this.resolveConflict(file, other, other);
            this.checkDirectory(real);
        }
    }

    private File makeTemporaryFile(Id id) throws IOException {
        File directory = this.getDirectoryForId(id);
        File file = new File(directory, id.toStringFull() + "." + this.rng.nextInt() % 100);
        while (file.exists()) {
            file = new File(directory, id.toStringFull() + "." + this.rng.nextInt() % 100);
        }
        return file;
    }

    private File[] append(File[] files, File file) {
        File[] result = new File[files.length + 1];
        for (int i = 0; i < files.length; ++i) {
            result[i] = files[i];
        }
        result[files.length] = file;
        return result;
    }

    private int numDirectoriesDir(File dir) {
        return dir.listFiles(new DirectoryFilter()).length;
    }

    private int numFilesDir(File dir) {
        return dir.listFiles(new FileFilter()).length;
    }

    private boolean containsDir(File dir) {
        return dir.listFiles(new DirectoryFilter()).length != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeDirty() {
        File[] files = this.dirty.toArray(new File[0]);
        for (int i = 0; i < files.length; ++i) {
            Serializable next;
            HashMap<Id, Object> map = new HashMap<Id, Object>();
            IdRange range = this.getRangeForDirectory(files[i]);
            Iterator keys = null;
            keys = range.getCCWId().compareTo(range.getCWId()) <= 0 ? this.metadata.keySubMap(range.getCCWId(), range.getCWId()).keySet().iterator() : this.metadata.keyTailMap(range.getCCWId()).keySet().iterator();
            while (keys.hasNext()) {
                next = (Id)keys.next();
                map.put((Id)next, this.metadata.get(next));
            }
            try {
                PersistentStorage.writeMetadataFile(files[i], map);
                next = this.metadata;
                synchronized (next) {
                    this.dirty.remove(files[i]);
                    continue;
                }
            }
            catch (FileNotFoundException f) {
                try {
                    ReverseTreeMap reverseTreeMap = this.metadata;
                    synchronized (reverseTreeMap) {
                        this.dirty.remove(files[i]);
                    }
                    System.err.println("ERROR: Could not find directory while writing out metadata in '" + files[i].getCanonicalPath() + "' - removing from dirty list and continuing!");
                }
                catch (IOException g) {
                    System.err.println("PANIC: Got IOException " + g + " trying to detail FNF exception " + f + " while writing out file " + files[i]);
                }
                continue;
            }
            catch (IOException e) {
                try {
                    System.err.println("ERROR: Got error " + e + " while writing out metadata in '" + files[i].getCanonicalPath() + "' - aborting!");
                    e.printStackTrace();
                    continue;
                }
                catch (IOException f) {
                    System.err.println("PANIC: Got IOException " + f + " trying to detail exception " + e + " while writing out file " + files[i]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private long readMetadataFile(File file) throws IOException {
        File metadata = new File(file, METADATA_FILENAME);
        if (!metadata.exists()) {
            return -1L;
        }
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(metadata);
            ObjectInputStream objin = new ObjectInputStream(new BufferedInputStream(fin));
            IdRange range = this.getRangeForDirectory(file);
            try {
                HashMap map = (HashMap)objin.readObject();
                Iterator keys = map.keySet().iterator();
                while (keys.hasNext()) {
                    Id id = (Id)keys.next();
                    if (range.containsId(id) && new File(file, id.toStringFull()).exists()) {
                        this.metadata.put(id, map.get(id));
                        continue;
                    }
                    this.dirty.add(file);
                }
                long l = metadata.lastModified();
                return l;
            }
            catch (ClassNotFoundException e) {
                System.out.println("ERROR: Got exception " + e + " while reading metadata file " + metadata + " - rebuilding file");
                PersistentStorage.deleteFile(metadata);
                long l = 0L;
                fin.close();
                return l;
            }
            catch (IOException e) {
                System.out.println("ERROR: Got exception " + e + " while reading metadata file " + metadata + " - rebuilding file");
                PersistentStorage.deleteFile(metadata);
                long l = 0L;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                fin.close();
                return l;
            }
        }
        finally {
            fin.close();
        }
    }

    private Id readKey(File file) {
        String s = file.getName();
        if (s.indexOf(".") >= 0) {
            return this.factory.buildIdFromToString(s.toCharArray(), 0, s.indexOf("."));
        }
        return this.factory.buildIdFromToString(s.toCharArray(), 0, s.length());
    }

    private void increaseUsedSpace(long i) {
        this.usedSize += i;
    }

    private void decreaseUsedSpace(long i) {
        this.usedSize -= i;
    }

    private void debug(String s) {
    }

    private static long getFileLength(File file) {
        return file != null && file.exists() ? file.length() : 0L;
    }

    private static boolean isTemporaryFile(String name) {
        return name.indexOf(".") >= 0;
    }

    private static void createDirectory(File directory) throws IOException {
        if (directory != null && !directory.exists() && !directory.mkdir()) {
            throw new IOException("Creation of directory " + directory + " failed!");
        }
    }

    private static void renameFile(File oldFile, File newFile) throws IOException {
        if (oldFile != null && oldFile.exists() && !oldFile.equals(newFile)) {
            PersistentStorage.deleteFile(newFile);
            if (!oldFile.renameTo(newFile)) {
                throw new IOException("Rename of " + oldFile + " to " + newFile + " failed!");
            }
        }
    }

    private static void deleteFile(File file) throws IOException {
        if (file != null && file.exists() && !file.delete()) {
            throw new IOException("Delete of " + file + " failed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeMetadataFile(File file, HashMap map) throws IOException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(new File(file, METADATA_FILENAME));
            ObjectOutputStream objout = new ObjectOutputStream(new BufferedOutputStream(fout));
            objout.writeObject(map);
            objout.close();
        }
        finally {
            if (fout != null) {
                fout.close();
            }
        }
    }

    private static Serializable readObject(File file, int offset) throws IOException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            XMLObjectInputStream objin = new XMLObjectInputStream(new BufferedInputStream(new GZIPInputStream(fin)));
            for (int i = 0; i < offset; ++i) {
                objin.readObject();
            }
            Serializable serializable = (Serializable)objin.readObject();
            return serializable;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            fin.close();
        }
    }

    private static Serializable readData(File file) throws IOException {
        return PersistentStorage.readObject(file, 1);
    }

    /*
     * Exception decompiling
     */
    private static Serializable readMetadata(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static long readVersion(File file) throws IOException {
        Long temp = (Long)PersistentStorage.readObject(file, 2);
        return temp == null ? 0L : temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long writeObject(Serializable obj, Serializable metadata, Id key, long version, File file) throws IOException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            XMLObjectOutputStream objout = new XMLObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(fout)));
            objout.writeObject(key);
            objout.writeObject(obj);
            objout.writeObject(new Long(version));
            ((ObjectOutputStream)objout).close();
        }
        finally {
            if (fout != null) {
                fout.close();
            }
        }
        long len1 = file.length();
        try {
            fout = new FileOutputStream(file, true);
            XMLObjectOutputStream objout = new XMLObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(fout)));
            objout.writeObject(metadata);
            ((ObjectOutputStream)objout).close();
        }
        finally {
            fout.close();
        }
        long len2 = file.length();
        try {
            fout = new FileOutputStream(file, true);
            DataOutputStream dos = new DataOutputStream(fout);
            dos.writeLong(8038844221L);
            dos.writeLong(2L);
            dos.writeLong(0L);
            dos.writeLong(len2 - len1);
            dos.close();
        }
        finally {
            fout.close();
        }
        return file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeMetadata(File file, Serializable metadata) throws IOException {
        RandomAccessFile ras = null;
        FileOutputStream fout = null;
        if (file.length() > 32L) {
            try {
                ras = new RandomAccessFile(file, "rw");
                ras.seek(file.length() - 32L);
                if (ras.readLong() == 8038844221L && ras.readLong() == 2L && ras.readLong() == 0L) {
                    long length = ras.readLong();
                    ras.setLength(file.length() - 32L - length);
                }
            }
            finally {
                ras.close();
            }
        }
        long len1 = file.length();
        try {
            fout = new FileOutputStream(file, true);
            XMLObjectOutputStream objout = new XMLObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(fout)));
            objout.writeObject(metadata);
            ((ObjectOutputStream)objout).close();
        }
        finally {
            fout.close();
        }
        long len2 = file.length();
        try {
            fout = new FileOutputStream(file, true);
            DataOutputStream dos = new DataOutputStream(fout);
            dos.writeLong(8038844221L);
            dos.writeLong(2L);
            dos.writeLong(0L);
            dos.writeLong(len2 - len1);
            dos.close();
        }
        finally {
            fout.close();
        }
    }

    static {
        WORK_THREAD.start();
    }

    private static class WorkQueueOverflowException
    extends PersistenceException {
        private WorkQueueOverflowException() {
        }
    }

    private static class OutofDiskSpaceException
    extends PersistenceException {
        private OutofDiskSpaceException() {
        }
    }

    private static class PersistenceException
    extends Exception {
        private PersistenceException() {
        }
    }

    public static class WorkQueue {
        List q = new LinkedList();
        int capacity = -1;

        public WorkQueue() {
        }

        public WorkQueue(int capacity) {
            this.capacity = capacity;
        }

        public synchronized int getLength() {
            return this.q.size();
        }

        public synchronized void enqueue(WorkRequest request) {
            if (this.capacity < 0 || this.q.size() < this.capacity) {
                this.q.add(request);
                this.notifyAll();
            } else {
                request.returnError(new WorkQueueOverflowException());
            }
        }

        public synchronized WorkRequest dequeue() {
            while (this.q.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return (WorkRequest)this.q.remove(0);
        }
    }

    private static class PersistenceThread
    extends Thread {
        WorkQueue workQ;

        public PersistenceThread(WorkQueue workQ) {
            super("Persistence Worker Thread");
            this.workQ = workQ;
        }

        public void run() {
            while (true) {
                this.workQ.dequeue().run();
            }
        }
    }

    private abstract class WorkRequest {
        private Continuation c;

        public WorkRequest(Continuation c) {
            this.c = c;
        }

        public WorkRequest() {
        }

        public void returnResult(Object o) {
            this.c.receiveResult(o);
        }

        public void returnError(Exception e) {
            this.c.receiveException(e);
        }

        public void run() {
            try {
                Object result = this.doWork();
                SelectorManager.getSelectorManager().invoke(new Runnable(this, result){
                    private final /* synthetic */ Object val$result;
                    private final /* synthetic */ WorkRequest this$1;
                    {
                        this.this$1 = this$1;
                        this.val$result = val$result;
                    }

                    public void run() {
                        this.this$1.returnResult(this.val$result);
                    }

                    public String toString() {
                        return "invc result of " + WorkRequest.access$3000(this.this$1);
                    }
                });
            }
            catch (Exception e) {
                SelectorManager.getSelectorManager().invoke(new Runnable(this, e){
                    private final /* synthetic */ Exception val$e;
                    private final /* synthetic */ WorkRequest this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        this.this$1.returnError(this.val$e);
                    }

                    public String toString() {
                        return "invc error of " + WorkRequest.access$3000(this.this$1);
                    }
                });
            }
        }

        public abstract Object doWork() throws Exception;

        static /* synthetic */ Continuation access$3000(WorkRequest x0) {
            return x0.c;
        }
    }

    private class CharacterHashSet {
        protected boolean[] bitMap = new boolean[256];

        private CharacterHashSet() {
        }

        public char[] get() {
            int[] nums = this.getOffsets();
            char[] result = new char[nums.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (char)nums[i];
            }
            return result;
        }

        private int[] getOffsets() {
            int[] result = new int[this.count()];
            boolean index = false;
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.getOffset(i);
            }
            return result;
        }

        private int getOffset(int index) {
            int location = 0;
            while (index > 0) {
                if (this.bitMap[location]) {
                    --index;
                }
                ++location;
            }
            while (!this.bitMap[location]) {
                ++location;
            }
            return location;
        }

        public void put(char a) {
            this.bitMap[a] = true;
        }

        public boolean contains(char a) {
            return this.bitMap[a];
        }

        public void remove(char a) {
            this.bitMap[a] = false;
        }

        private int count() {
            int total = 0;
            for (int i = 0; i < this.bitMap.length; ++i) {
                if (!this.bitMap[i]) continue;
                ++total;
            }
            return total;
        }
    }

    private class FileFilter
    implements FilenameFilter {
        private FileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.length() >= PersistentStorage.this.factory.getIdToStringLength();
        }
    }

    private class DirectoryFilter
    implements FilenameFilter {
        private DirectoryFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.length() < PersistentStorage.this.factory.getIdToStringLength() && new File(dir, name).isDirectory();
        }
    }
}

