/*
 * Decompiled with CFR 0.152.
 */
package rice.persistence.testing;

import java.io.Serializable;
import java.util.Random;
import rice.Continuation;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdSet;
import rice.pastry.commonapi.PastryIdFactory;
import rice.persistence.Cache;
import rice.persistence.LRUCache;
import rice.persistence.MemoryStorage;
import rice.persistence.testing.Test;

public class LRUCacheTest
extends Test {
    private Cache cache = new LRUCache(new MemoryStorage(FACTORY), 100);
    private Id[] data = new Id[500];
    protected static final int CACHE_SIZE = 100;
    private static IdFactory FACTORY = new PastryIdFactory();

    public LRUCacheTest() {
        int[] x = new int[5];
        for (int i = 0; i < 500; ++i) {
            x[3] = i;
            this.data[i] = FACTORY.buildId(x);
        }
    }

    public void setUp(final Continuation c) {
        final Continuation put4 = new Continuation(){

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(false))) {
                    LRUCacheTest.this.stepDone("SUCCESS");
                } else {
                    LRUCacheTest.this.stepDone("FAILURE");
                }
                LRUCacheTest.this.sectionEnd();
                c.receiveResult(new Boolean(true));
            }

            public void receiveException(Exception e) {
                LRUCacheTest.this.stepException(e);
            }
        };
        final Continuation put3 = new Continuation(){

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(true))) {
                    LRUCacheTest.this.stepDone("SUCCESS");
                } else {
                    LRUCacheTest.this.stepDone("FAILURE");
                }
                LRUCacheTest.this.stepStart("Inserting Fourth Object (227 bytes)");
                LRUCacheTest.this.cache.cache(LRUCacheTest.this.data[4], null, (Serializable)new byte[200], put4);
            }

            public void receiveException(Exception e) {
                LRUCacheTest.this.stepException(e);
            }
        };
        final Continuation put2 = new Continuation(){

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(true))) {
                    LRUCacheTest.this.stepDone("SUCCESS");
                } else {
                    LRUCacheTest.this.stepDone("FAILURE");
                }
                LRUCacheTest.this.stepStart("Inserting Third Object (65 bytes)");
                LRUCacheTest.this.cache.cache(LRUCacheTest.this.data[3], null, (Serializable)new byte[38], put3);
            }

            public void receiveException(Exception e) {
                LRUCacheTest.this.stepException(e);
            }
        };
        Continuation put1 = new Continuation(){

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(true))) {
                    LRUCacheTest.this.stepDone("SUCCESS");
                } else {
                    LRUCacheTest.this.stepDone("FAILURE");
                }
                LRUCacheTest.this.stepStart("Inserting Second Object (40 bytes)");
                LRUCacheTest.this.cache.cache(LRUCacheTest.this.data[2], null, (Serializable)new byte[13], put2);
            }

            public void receiveException(Exception e) {
                LRUCacheTest.this.stepException(e);
            }
        };
        this.sectionStart("Inserting Objects");
        this.stepStart("Inserting First Object (30 bytes)");
        this.cache.cache(this.data[1], null, (Serializable)new byte[3], put1);
    }

    private void testExists(final Continuation c) {
        this.setUp(new Continuation(){

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(true))) {
                    LRUCacheTest.this.sectionStart("Checking for Objects");
                    LRUCacheTest.this.stepStart("Checking for First Object");
                    if (LRUCacheTest.this.cache.exists(LRUCacheTest.this.data[1])) {
                        LRUCacheTest.this.stepDone("SUCCESS");
                    } else {
                        LRUCacheTest.this.stepDone("FAILURE");
                    }
                    LRUCacheTest.this.stepStart("Checking for Second Object");
                    if (LRUCacheTest.this.cache.exists(LRUCacheTest.this.data[2])) {
                        LRUCacheTest.this.stepDone("SUCCESS");
                    } else {
                        LRUCacheTest.this.stepDone("FAILURE");
                    }
                    LRUCacheTest.this.stepStart("Checking for Third Object");
                    if (LRUCacheTest.this.cache.exists(LRUCacheTest.this.data[3])) {
                        LRUCacheTest.this.stepDone("SUCCESS");
                    } else {
                        LRUCacheTest.this.stepDone("FAILURE");
                    }
                    LRUCacheTest.this.stepStart("Checking for Fourth Object");
                    if (LRUCacheTest.this.cache.exists(LRUCacheTest.this.data[4])) {
                        LRUCacheTest.this.stepDone("SUCCESS");
                    } else {
                        LRUCacheTest.this.stepDone("FAILURE");
                    }
                    LRUCacheTest.this.stepStart("Checking for Fifth Object");
                    if (LRUCacheTest.this.cache.exists(LRUCacheTest.this.data[5])) {
                        LRUCacheTest.this.stepDone("SUCCESS");
                    } else {
                        LRUCacheTest.this.stepDone("FAILURE");
                    }
                } else {
                    throw new RuntimeException("SetUp did not complete correctly!");
                }
                LRUCacheTest.this.sectionEnd();
                c.receiveResult(new Boolean(true));
            }

            public void receiveException(Exception e) {
                LRUCacheTest.this.stepException(e);
            }
        });
    }

    private void testScan(final Continuation c) {
        final Continuation handleBadScan = new Continuation(){

            public void receiveResult(Object o) {
                LRUCacheTest.this.stepDone("FAILURE", "Query returned; should have thrown exception");
            }

            public void receiveException(Exception e) {
                LRUCacheTest.this.stepDone("SUCCESS");
                LRUCacheTest.this.sectionEnd();
                c.receiveResult(new Boolean(true));
            }
        };
        final Continuation query = new Continuation(){

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(true))) {
                    LRUCacheTest.this.stepDone("SUCCESS");
                } else {
                    LRUCacheTest.this.stepDone("FAILURE");
                }
                LRUCacheTest.this.stepStart("Requesting Scan from 3 to 6");
                IdSet result = LRUCacheTest.this.cache.scan(FACTORY.buildIdRange(LRUCacheTest.this.data[3], LRUCacheTest.this.data[6]));
                if (result.numElements() != 1) {
                    LRUCacheTest.this.stepDone("FAILURE", "Result had " + result.numElements() + " elements, expected 1.");
                    return;
                }
                if (!result.isMemberId(LRUCacheTest.this.data[3])) {
                    LRUCacheTest.this.stepDone("FAILURE", "Result had incorrect element " + LRUCacheTest.this.data[3] + ", expected 3.");
                    return;
                }
                LRUCacheTest.this.stepDone("SUCCESS");
                LRUCacheTest.this.stepStart("Requesting Scan from 8 to 10");
                result = LRUCacheTest.this.cache.scan(FACTORY.buildIdRange(LRUCacheTest.this.data[8], LRUCacheTest.this.data[10]));
                if (result.numElements() != 0) {
                    LRUCacheTest.this.stepDone("FAILURE", "Result had " + result.numElements() + " elements, expected 0.");
                    return;
                }
                LRUCacheTest.this.stepDone("SUCCESS");
                LRUCacheTest.this.stepStart("Requesting Scan from 'Monkey' to 9");
                handleBadScan.receiveException(new Exception());
            }

            public void receiveException(Exception e) {
                LRUCacheTest.this.stepException(e);
            }
        };
        Continuation insertString = new Continuation(){

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(true))) {
                    LRUCacheTest.this.sectionStart("Testing Scan");
                    LRUCacheTest.this.stepStart("Inserting String as Key");
                    LRUCacheTest.this.cache.cache(LRUCacheTest.this.data[11], null, (Serializable)new byte[0], query);
                } else {
                    LRUCacheTest.this.stepException(new RuntimeException("Exists did not complete correctly."));
                }
            }

            public void receiveException(Exception e) {
                LRUCacheTest.this.stepException(e);
            }
        };
        this.testExists(insertString);
    }

    private void testRandomInserts(final Continuation c) {
        int START_NUM = 10;
        int END_NUM = 98;
        int SKIP = 2;
        int NUM_ELEMENTS = 17;
        int LAST_NUM_REMAINING = 66;
        final Continuation checkRandom = new Continuation(){

            public void receiveResult(Object o) {
                LRUCacheTest.this.stepStart("Checking object deletion");
                int NUM_DELETED = (Integer)o;
                int length = LRUCacheTest.this.cache.scan(FACTORY.buildIdRange(LRUCacheTest.this.data[23], LRUCacheTest.this.data[113])).numElements();
                int desired = 17 - NUM_DELETED;
                if (length != desired) {
                    LRUCacheTest.this.stepDone("FAILURE", "Expected " + desired + " objects after deletes, found " + length + ".");
                    return;
                }
                LRUCacheTest.this.stepDone("SUCCESS");
                LRUCacheTest.this.sectionEnd();
                c.receiveResult(new Boolean(true));
            }

            public void receiveException(Exception e) {
                LRUCacheTest.this.stepException(e);
            }
        };
        final Continuation removeRandom = new Continuation(){
            private Random random = new Random();
            private int count = 66;
            private int num_deleted = 0;

            public void receiveResult(Object o) {
                if (this.count == 66) {
                    LRUCacheTest.this.stepStart("Removing random subset of objects");
                }
                if (o.equals(new Boolean(false))) {
                    LRUCacheTest.this.stepDone("FAILURE", "Deletion of " + this.count + " failed.");
                    return;
                }
                if (this.count == 98) {
                    LRUCacheTest.this.stepDone("SUCCESS");
                    checkRandom.receiveResult(new Integer(this.num_deleted));
                    return;
                }
                if (this.random.nextBoolean()) {
                    ++this.num_deleted;
                    LRUCacheTest.this.cache.uncache(LRUCacheTest.this.data[13 + (this.count += 2)], this);
                } else {
                    this.count += 2;
                    this.receiveResult(new Boolean(true));
                }
            }

            public void receiveException(Exception e) {
                LRUCacheTest.this.stepException(e);
            }
        };
        final Continuation checkExists = new Continuation(){

            public void receiveResult(Object o) {
                LRUCacheTest.this.stepStart("Checking exists for all 50 objects");
                for (int count = 8; count < 98; count += 2) {
                    Boolean b = new Boolean(LRUCacheTest.this.cache.exists(LRUCacheTest.this.data[13 + count]));
                    if (!b.equals(new Boolean(count < 66))) continue;
                    if (b.booleanValue()) {
                        LRUCacheTest.this.stepDone("FAILURE", "Element " + count + " did exist - should not have.");
                        return;
                    }
                    LRUCacheTest.this.stepDone("FAILURE", "Element " + count + " did not exist - should have.");
                    return;
                }
                LRUCacheTest.this.stepDone("SUCCESS");
                removeRandom.receiveResult(new Boolean(true));
            }

            public void receiveException(Exception e) {
                LRUCacheTest.this.stepException(e);
            }
        };
        final Continuation insert = new Continuation(){
            private int count = 10;

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(false))) {
                    LRUCacheTest.this.stepDone("FAILURE", "Insertion of " + this.count + " failed.");
                    return;
                }
                if (this.count == 10) {
                    LRUCacheTest.this.stepDone("SUCCESS");
                    LRUCacheTest.this.stepStart("Inserting 40 objects from 100 to 1000000 bytes");
                }
                if (this.count > 98) {
                    LRUCacheTest.this.stepDone("SUCCESS");
                    checkExists.receiveResult(new Boolean(true));
                    return;
                }
                int num = this.count;
                this.count += 2;
                LRUCacheTest.this.cache.cache(LRUCacheTest.this.data[13 + num], null, (Serializable)new byte[num * num * num], this);
            }

            public void receiveException(Exception e) {
                LRUCacheTest.this.stepException(e);
            }
        };
        Continuation setSize = new Continuation(){

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(false))) {
                    LRUCacheTest.this.stepDone("FAILURE", "Testing of scan failed");
                    return;
                }
                LRUCacheTest.this.sectionStart("Stress Testing");
                LRUCacheTest.this.stepStart("Increasing cache size to 10000000 bytes");
                LRUCacheTest.this.cache.setMaximumSize(10000000, insert);
            }

            public void receiveException(Exception e) {
                LRUCacheTest.this.stepException(e);
            }
        };
        this.testScan(setSize);
    }

    private void testErrors() {
        final Continuation validateNullValue = new Continuation(){

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(true))) {
                    LRUCacheTest.this.stepDone("FAILURE", "Null value should return false");
                    return;
                }
                LRUCacheTest.this.stepDone("SUCCESS");
                LRUCacheTest.this.sectionEnd();
            }

            public void receiveException(Exception e) {
                LRUCacheTest.this.stepException(e);
            }
        };
        final Continuation insertNullValue = new Continuation(){

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(true))) {
                    LRUCacheTest.this.stepDone("FAILURE", "Null key should return false");
                    return;
                }
                LRUCacheTest.this.stepDone("SUCCESS");
                LRUCacheTest.this.stepStart("Inserting null value");
                LRUCacheTest.this.cache.cache(LRUCacheTest.this.data[12], null, null, validateNullValue);
            }

            public void receiveException(Exception e) {
                LRUCacheTest.this.stepException(e);
            }
        };
        Continuation insertNullKey = new Continuation(){

            public void receiveResult(Object o) {
                if (o.equals(new Boolean(false))) {
                    LRUCacheTest.this.stepDone("FAILURE", "Random insert tests failed.");
                    return;
                }
                LRUCacheTest.this.sectionStart("Testing Error Cases");
                LRUCacheTest.this.stepStart("Inserting null key");
                LRUCacheTest.this.cache.cache(null, null, (Serializable)((Object)"null key"), insertNullValue);
            }

            public void receiveException(Exception e) {
                LRUCacheTest.this.stepException(e);
            }
        };
        this.testRandomInserts(insertNullKey);
    }

    public void start() {
        this.testErrors();
    }

    public static void main(String[] args) {
        LRUCacheTest test = new LRUCacheTest();
        test.start();
    }
}

