/*
 * Decompiled with CFR 0.152.
 */
package rice.selector;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import rice.pastry.Log;
import rice.selector.ProfileSelector;
import rice.selector.SelectionKeyHandler;
import rice.selector.Timer;
import rice.selector.TimerTask;

public class SelectorManager
extends Thread
implements Timer {
    protected Selector selector;
    protected LinkedList invocations;
    protected HashSet modifyKeys;
    protected HashSet cancelledKeys;
    protected TreeSet timerQueue = new TreeSet();
    protected long wakeupTime = 0L;
    public static int TIMEOUT = 500;
    private static SelectorManager manager;
    static /* synthetic */ Class class$rice$selector$SelectorManager;

    protected SelectorManager(boolean profile) {
        super("Main Selector Thread");
        this.invocations = new LinkedList();
        this.modifyKeys = new HashSet();
        this.cancelledKeys = new HashSet();
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            System.out.println("SEVERE ERROR (SelectorManager): Error creating selector " + e);
        }
        this.start();
    }

    public SelectionKey getKey(SelectableChannel channel) {
        return channel.keyFor(this.selector);
    }

    public int getNumInvocations() {
        return this.invocations.size();
    }

    protected synchronized Runnable getInvocation() {
        if (this.invocations.size() > 0) {
            return (Runnable)this.invocations.removeFirst();
        }
        return null;
    }

    protected synchronized SelectionKey getModifyKey() {
        if (this.modifyKeys.size() > 0) {
            Object result = this.modifyKeys.iterator().next();
            this.modifyKeys.remove(result);
            return (SelectionKey)result;
        }
        return null;
    }

    public Timer getTimer() {
        return this;
    }

    public void cancel(SelectionKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.cancelledKeys.add(key);
    }

    public SelectionKey register(SelectableChannel channel, SelectionKeyHandler handler, int ops) throws IOException {
        if (channel == null || handler == null) {
            throw new NullPointerException();
        }
        SelectionKey key = channel.register(this.selector, ops, handler);
        this.cancelledKeys.remove(key);
        return key;
    }

    public synchronized void invoke(Runnable d) {
        if (d == null) {
            throw new NullPointerException();
        }
        this.invocations.add(d);
        this.selector.wakeup();
    }

    public synchronized void modifyKey(SelectionKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.modifyKeys.add(key);
        this.selector.wakeup();
    }

    protected void onLoop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            this.debug("SelectorManager starting...");
            while (true) {
                Thread.yield();
                this.executeDueTasks();
                this.onLoop();
                this.doInvocations();
                this.doSelections();
                Selector selector = this.selector;
                synchronized (selector) {
                    int selectTime = TIMEOUT;
                    if (this.timerQueue.size() > 0) {
                        TimerTask first = (TimerTask)this.timerQueue.first();
                        selectTime = (int)(first.nextExecutionTime - System.currentTimeMillis());
                    }
                    this.select(selectTime);
                    if (this.cancelledKeys.size() > 0) {
                        Iterator i = this.cancelledKeys.iterator();
                        while (i.hasNext()) {
                            ((SelectionKey)i.next()).cancel();
                        }
                        this.cancelledKeys.clear();
                        this.selector.selectNow();
                    }
                }
            }
        }
        catch (Throwable t) {
            System.out.println("ERROR (SelectorManager.run): " + t);
            t.printStackTrace(System.out);
            System.exit(-1);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSelections() throws IOException {
        SelectionKey[] keys = this.selectedKeys();
        for (int i = 0; i < keys.length; ++i) {
            this.selector.selectedKeys().remove(keys[i]);
            SelectionKey selectionKey = keys[i];
            synchronized (selectionKey) {
                SelectionKeyHandler skh = (SelectionKeyHandler)keys[i].attachment();
                if (skh != null) {
                    if (keys[i].isValid() && keys[i].isAcceptable()) {
                        skh.accept(keys[i]);
                    }
                    if (keys[i].isValid() && keys[i].isConnectable()) {
                        skh.connect(keys[i]);
                    }
                    if (keys[i].isValid() && keys[i].isReadable()) {
                        skh.read(keys[i]);
                    }
                    if (keys[i].isValid() && keys[i].isWritable()) {
                        skh.write(keys[i]);
                    }
                } else {
                    keys[i].channel().close();
                    keys[i].cancel();
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void doInvocations() {
        void var1_2;
        Runnable run;
        Iterator i;
        SelectorManager selectorManager = this;
        synchronized (selectorManager) {
            i = new ArrayList(this.invocations).iterator();
            this.invocations.clear();
        }
        while (i.hasNext()) {
            run = (Runnable)i.next();
            try {
                run.run();
            }
            catch (Exception e) {
                System.err.println("Invoking runnable caused exception " + e + " - continuing");
                e.printStackTrace();
            }
        }
        run = this;
        synchronized (run) {
            i = new ArrayList(this.modifyKeys).iterator();
            this.modifyKeys.clear();
        }
        while (var1_2.hasNext()) {
            SelectionKey key = (SelectionKey)var1_2.next();
            if (!key.isValid() || key.attachment() == null) continue;
            ((SelectionKeyHandler)key.attachment()).modifyKey(key);
        }
    }

    int select(int time) throws IOException {
        if (time > TIMEOUT) {
            time = TIMEOUT;
        }
        try {
            if (time <= 0 || this.invocations.size() > 0 || this.modifyKeys.size() > 0) {
                return this.selector.selectNow();
            }
            this.wakeupTime = System.currentTimeMillis() + (long)time;
            return this.selector.select(time);
        }
        catch (IOException e) {
            if (e.getMessage().indexOf("Interrupted system call") >= 0) {
                System.out.println("Got interrupted system call, continuing anyway...");
                return 1;
            }
            throw e;
        }
    }

    private SelectionKey[] keys() throws IOException {
        return this.selector.keys().toArray(new SelectionKey[0]);
    }

    protected SelectionKey[] selectedKeys() throws IOException {
        return this.selector.selectedKeys().toArray(new SelectionKey[0]);
    }

    private void debug(String s) {
        if (Log.ifp(8)) {
            System.out.println("(SelectorManager): " + s);
        }
    }

    public void schedule(TimerTask task, long delay) {
        task.nextExecutionTime = System.currentTimeMillis() + delay;
        this.addTask(task);
    }

    public void schedule(TimerTask task, Date time) {
        task.nextExecutionTime = time.getTime();
        this.addTask(task);
    }

    public void schedule(TimerTask task, long delay, long period) {
        task.nextExecutionTime = System.currentTimeMillis() + delay;
        task.period = (int)period;
        this.addTask(task);
    }

    public void schedule(TimerTask task, Date firstTime, long period) {
        task.nextExecutionTime = firstTime.getTime();
        task.period = (int)period;
        this.addTask(task);
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        task.nextExecutionTime = System.currentTimeMillis() + delay;
        task.period = (int)period;
        this.addTask(task);
    }

    public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        task.nextExecutionTime = firstTime.getTime();
        task.period = (int)period;
        this.addTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(TimerTask task) {
        Selector selector = this.selector;
        synchronized (selector) {
            if (!this.timerQueue.add(task)) {
                System.out.println("ERROR: Got false while enqueueing task " + task + "!");
                Thread.dumpStack();
            }
        }
        if (this.wakeupTime >= task.scheduledExecutionTime()) {
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeDueTasks() {
        TimerTask next;
        long now = System.currentTimeMillis();
        ArrayList<TimerTask> executeNow = new ArrayList<TimerTask>();
        Selector selector = this.selector;
        synchronized (selector) {
            boolean done = false;
            while (!done) {
                if (this.timerQueue.size() > 0) {
                    next = (TimerTask)this.timerQueue.first();
                    if (next.nextExecutionTime <= now) {
                        executeNow.add(next);
                        this.timerQueue.remove(next);
                        continue;
                    }
                    done = true;
                    continue;
                }
                done = true;
            }
        }
        ArrayList<TimerTask> addBack = new ArrayList<TimerTask>();
        Iterator i = executeNow.iterator();
        while (i.hasNext()) {
            next = (TimerTask)i.next();
            try {
                if (!next.execute()) continue;
                addBack.add(next);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Selector selector2 = this.selector;
        synchronized (selector2) {
            i = addBack.iterator();
            while (i.hasNext()) {
                TimerTask tt = (TimerTask)i.next();
                this.timerQueue.add(tt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SelectorManager getSelectorManager() {
        if (manager != null) {
            return manager;
        }
        Class clazz = class$rice$selector$SelectorManager == null ? (class$rice$selector$SelectorManager = SelectorManager.class$("rice.selector.SelectorManager")) : class$rice$selector$SelectorManager;
        synchronized (clazz) {
            if (manager != null) {
                return manager;
            }
            String s = System.getProperty("PROFILE_SELECTOR_MANAGER");
            if (s != null && s != "") {
                System.out.println("Using Profile Selector");
                manager = new ProfileSelector();
            } else {
                manager = new SelectorManager(false);
            }
            return manager;
        }
    }

    public static boolean isSelectorThread() {
        return Thread.currentThread() == manager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

