/*
 * Decompiled with CFR 0.152.
 */
package codec;

import codec.CorruptedCodeException;

public final class Hex {
    private static final char[] HEX_ = new String("0123456789abcdef").toCharArray();

    private Hex() {
    }

    public static String encode(byte[] in) {
        if (in.length == 0) {
            return new String();
        }
        StringBuffer out = new StringBuffer(in.length * 2);
        int n = 0;
        while (n < in.length) {
            byte m = in[n];
            int k = m >>> 4 & 0xF;
            out.append(HEX_[k]);
            k = m & 0xF;
            out.append(HEX_[k]);
            ++n;
        }
        return out.toString();
    }

    public static byte[] decode(String in) throws CorruptedCodeException {
        if (in.length() == 0) {
            return new byte[0];
        }
        int n = in.length();
        if (n % 2 == 1) {
            throw new CorruptedCodeException("uneven input length");
        }
        byte[] buf = new byte[n /= 2];
        int j = 0;
        n = 0;
        while (n < buf.length) {
            int a = in.charAt(j++);
            int b = in.charAt(j++);
            if (48 <= a && a <= 57) {
                a -= 48;
            } else if (97 <= a && a <= 102) {
                a = a - 97 + 10;
            } else if (65 <= a && a <= 70) {
                a = a - 65 + 10;
            } else {
                throw new CorruptedCodeException("Illegal char: '" + a + "'");
            }
            if (48 <= b && b <= 57) {
                b -= 48;
            } else if (97 <= b && b <= 102) {
                b = b - 97 + 10;
            } else if (65 <= b && b <= 70) {
                b = b - 65 + 10;
            } else {
                throw new CorruptedCodeException("Illegal char: '" + b + "'");
            }
            buf[n] = (byte)(a << 4 | b);
            ++n;
        }
        return buf;
    }
}

