/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1AbstractType;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1String;
import codec.asn1.ConstraintException;
import codec.asn1.Decoder;
import codec.asn1.Encoder;
import java.io.IOException;

public abstract class ASN1AbstractString
extends ASN1AbstractType
implements ASN1String {
    private static final String DEFAULT_VALUE = "";
    private String value_ = "";

    public ASN1AbstractString() {
    }

    public ASN1AbstractString(String s) {
        this.setString0(s);
    }

    public Object getValue() {
        return this.value_;
    }

    public String getString() {
        return this.value_;
    }

    public void setString(String s) throws ConstraintException {
        this.setString0(s);
        this.checkConstraints();
    }

    protected void setString0(String s) {
        if (s == null) {
            throw new NullPointerException("Need a string!");
        }
        this.value_ = s;
    }

    public void encode(Encoder enc) throws ASN1Exception, IOException {
        enc.writeString(this);
    }

    public void decode(Decoder enc) throws ASN1Exception, IOException {
        enc.readString(this);
        this.checkConstraints();
    }

    public String convert(byte[] b) throws ASN1Exception {
        if (b == null) {
            throw new NullPointerException("Cannot convert null array!");
        }
        char[] c = new char[b.length];
        int i = 0;
        while (i < b.length) {
            c[i] = (char)(b[i] & 0xFF);
            ++i;
        }
        return String.valueOf(c);
    }

    public byte[] convert(String s) throws ASN1Exception {
        if (s == null) {
            throw new NullPointerException("Cannot convert null string!");
        }
        char[] c = s.toCharArray();
        byte[] b = new byte[c.length];
        int i = 0;
        while (i < c.length) {
            b[i] = (byte)(c[i] & 0xFF);
            ++i;
        }
        return b;
    }

    public int convertedLength(String s) throws ASN1Exception {
        return s.length();
    }

    public String toString() {
        String s = this.getClass().getName();
        int n = s.lastIndexOf(46);
        if (n < 0) {
            n = -1;
        }
        if ((s = s.substring(n + 1)).startsWith("ASN1")) {
            s = s.substring(4);
        }
        return s + " \"" + this.value_ + "\"";
    }

    public boolean equals(Object s) {
        if (this.getClass().equals(s.getClass())) {
            return this.value_.equals(((ASN1AbstractString)s).getString());
        }
        return false;
    }

    public int hashCode() {
        return (this.getClass().hashCode() + this.value_.hashCode()) / 2;
    }
}

