/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Type;
import codec.asn1.Constraint;
import codec.asn1.ConstraintException;
import codec.asn1.DERDecoder;
import codec.asn1.DEREncoder;
import codec.asn1.Decoder;
import codec.asn1.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;

public abstract class ASN1AbstractType
implements ASN1Type,
Cloneable,
Externalizable {
    private boolean optional_ = false;
    private boolean explicit_ = true;
    private Constraint constraint_;

    public abstract Object getValue();

    public abstract int getTag();

    public abstract void encode(Encoder var1) throws ASN1Exception, IOException;

    public abstract void decode(Decoder var1) throws ASN1Exception, IOException;

    public void setOptional(boolean optional) {
        this.optional_ = optional;
    }

    public boolean isOptional() {
        return this.optional_;
    }

    public int getTagClass() {
        return 0;
    }

    public void setExplicit(boolean explicit) {
        this.explicit_ = explicit;
    }

    public boolean isExplicit() {
        return this.explicit_;
    }

    public boolean isType(int tag, int tagclass) {
        return this.getTag() == tag && this.getTagClass() == tagclass;
    }

    public void setConstraint(Constraint constraint) {
        this.constraint_ = constraint;
    }

    public Constraint getConstraint() {
        return this.constraint_;
    }

    public void checkConstraints() throws ConstraintException {
        if (this.constraint_ != null) {
            this.constraint_.constrain(this);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] res = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.encode(new DEREncoder(baos));
            res = baos.toByteArray();
            baos.close();
            out.write(res);
        }
        catch (ASN1Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void readExternal(ObjectInput in) throws IOException {
        try {
            this.decode(new DERDecoder((ObjectInputStream)in));
        }
        catch (ASN1Exception e) {
            throw new RuntimeException(e.toString());
        }
    }
}

