/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1AbstractString;

public class ASN1BMPString
extends ASN1AbstractString {
    public ASN1BMPString() {
    }

    public ASN1BMPString(String s) {
        super(s);
    }

    public int getTag() {
        return 30;
    }

    public String convert(byte[] b) {
        if (b == null) {
            throw new NullPointerException("Cannot convert null array!");
        }
        if (b.length % 2 != 0) {
            throw new RuntimeException("Truncated character encoding!");
        }
        char[] c = new char[b.length / 2];
        int i = 0;
        int j = 0;
        while (i < c.length) {
            c[i] = (char)(b[j] << 8 & 0xFF | b[j + 1] & 0xFF);
            ++i;
            j += 2;
        }
        return String.valueOf(c);
    }

    public byte[] convert(String s) {
        if (s == null) {
            throw new NullPointerException("Cannot convert null string!");
        }
        char[] c = s.toCharArray();
        byte[] b = new byte[c.length * 2];
        int i = 0;
        int j = 0;
        while (i < c.length) {
            b[j++] = (byte)(c[i] >>> 8 & 0xFF);
            b[j++] = (byte)(c[i] & 0xFF);
            ++i;
        }
        return b;
    }

    public int convertedLength(String s) {
        return s.length() * 2;
    }
}

