/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1AbstractType;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Type;
import codec.asn1.Constraint;
import codec.asn1.ConstraintException;
import codec.asn1.Decoder;
import codec.asn1.Encoder;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class ASN1Choice
extends ASN1AbstractType {
    private static final String NO_INNER = "No inner type defined!";
    private ASN1Type inner_;
    private ArrayList choices_;

    public ASN1Choice() {
        this.choices_ = new ArrayList(2);
    }

    public ASN1Choice(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity must be greater than zero!");
        }
        this.choices_ = new ArrayList(capacity);
    }

    public void addType(ASN1Type t) {
        if (t == null) {
            throw new NullPointerException("Choice is null!");
        }
        if (t instanceof ASN1Choice) {
            throw new IllegalArgumentException("No nested CHOICE types are allowed!");
        }
        t.setOptional(false);
        t.setExplicit(true);
        this.choices_.add(t);
    }

    public ASN1Type getType(int tag, int tagclass) {
        Iterator i = ((AbstractList)this.choices_).iterator();
        while (i.hasNext()) {
            ASN1Type t = (ASN1Type)i.next();
            if (t.getTag() != tag || t.getTagClass() != tagclass) continue;
            return t;
        }
        return null;
    }

    public boolean isType(int tag, int tagclass) {
        return this.getType(tag, tagclass) != null;
    }

    public void trimToSize() {
        this.choices_.trimToSize();
    }

    public void clear() {
        this.choices_.clear();
    }

    public ASN1Type getInnerType() {
        return this.inner_;
    }

    public void setInnerType(ASN1Type t) {
        if (t == null) {
            throw new NullPointerException("No type given!");
        }
        this.inner_ = t;
    }

    public int getTag() {
        if (this.inner_ == null) {
            throw new IllegalStateException(NO_INNER);
        }
        return this.inner_.getTag();
    }

    public int getTagClass() {
        if (this.inner_ == null) {
            throw new IllegalStateException(NO_INNER);
        }
        return this.inner_.getTagClass();
    }

    public Object getValue() {
        if (this.inner_ == null) {
            throw new IllegalStateException(NO_INNER);
        }
        return this.inner_.getValue();
    }

    public void setExplicit(boolean explicit) {
        if (!explicit) {
            throw new IllegalArgumentException("CHOICE types must be tagged EXPLICIT!");
        }
    }

    public boolean isExplicit() {
        return true;
    }

    public void setConstraint(Constraint constraint) {
        if (this.inner_ == null) {
            throw new IllegalStateException(NO_INNER);
        }
        this.inner_.setConstraint(constraint);
    }

    public void checkConstraints() throws ConstraintException {
        if (this.inner_ == null) {
            throw new IllegalStateException(NO_INNER);
        }
        this.inner_.checkConstraints();
    }

    public void encode(Encoder enc) throws ASN1Exception, IOException {
        if (this.inner_ == null) {
            throw new IllegalStateException(NO_INNER);
        }
        enc.writeType(this.inner_);
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        dec.readChoice(this);
    }

    public String toString() {
        if (this.inner_ == null) {
            return "CHOICE <NOT InitializED>";
        }
        return "(CHOICE) " + this.inner_.toString();
    }
}

