/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1AbstractType;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Type;
import codec.asn1.Constraint;
import codec.asn1.ConstraintException;
import codec.asn1.Decoder;
import codec.asn1.DefinedByResolver;
import codec.asn1.Encoder;
import codec.asn1.OIDRegistry;
import codec.asn1.Resolver;
import codec.asn1.ResolverException;
import java.io.IOException;

public class ASN1OpenType
extends ASN1AbstractType {
    private static final String NO_INNER = "No inner type defined!";
    private ASN1Type inner_;
    protected Resolver resolver_;

    public ASN1OpenType() {
    }

    public ASN1OpenType(Resolver resolver) {
        this.resolver_ = resolver;
    }

    public ASN1OpenType(OIDRegistry registry, ASN1ObjectIdentifier oid) {
        this.resolver_ = new DefinedByResolver(registry, oid);
    }

    public ASN1OpenType(ASN1ObjectIdentifier oid) {
        this.resolver_ = new DefinedByResolver(oid);
    }

    public ASN1Type getInnerType() throws ResolverException {
        if (this.inner_ != null) {
            return this.inner_;
        }
        if (this.resolver_ == null) {
            return null;
        }
        this.inner_ = this.resolver_.resolve(this);
        return this.inner_;
    }

    protected void setInnerType(ASN1Type t) {
        this.inner_ = t;
        this.inner_.setExplicit(this.isExplicit());
    }

    public int getTag() {
        if (this.inner_ == null) {
            throw new IllegalStateException(NO_INNER);
        }
        return this.inner_.getTag();
    }

    public int getTagClass() {
        if (this.inner_ == null) {
            throw new IllegalStateException(NO_INNER);
        }
        return this.inner_.getTagClass();
    }

    public Object getValue() {
        if (this.inner_ == null) {
            throw new IllegalStateException(NO_INNER);
        }
        return this.inner_.getValue();
    }

    public void setExplicit(boolean explicit) {
        super.setExplicit(explicit);
        if (this.inner_ != null) {
            this.inner_.setExplicit(explicit);
        }
    }

    public void setConstraint(Constraint constraint) {
        if (this.inner_ == null) {
            throw new IllegalStateException(NO_INNER);
        }
        this.inner_.setConstraint(constraint);
    }

    public void checkConstraints() throws ConstraintException {
        if (this.inner_ == null) {
            throw new IllegalStateException(NO_INNER);
        }
        this.inner_.checkConstraints();
    }

    public boolean isType(int tag, int tagclass) {
        if (this.inner_ != null) {
            return this.inner_.isType(tag, tagclass);
        }
        try {
            if (this.resolver_ != null) {
                this.inner_ = this.resolver_.resolve(this);
            }
        }
        catch (ResolverException e) {
            return false;
        }
        if (this.inner_ == null) {
            return true;
        }
        return this.inner_.isType(tag, tagclass);
    }

    public void encode(Encoder enc) throws ASN1Exception, IOException {
        if (this.inner_ == null) {
            throw new IllegalStateException(NO_INNER);
        }
        enc.writeType(this.inner_);
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        if (this.resolver_ != null && this.inner_ == null) {
            this.inner_ = this.resolver_.resolve(this);
        }
        if (this.inner_ == null) {
            this.inner_ = dec.readType();
        } else {
            this.inner_.decode(dec);
        }
        this.inner_.setExplicit(this.isExplicit());
    }

    public String toString() {
        if (this.inner_ == null) {
            return "Open Type <NOT InitializED>";
        }
        return "(Open Type) " + this.inner_.toString();
    }
}

