/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1AbstractType;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Type;
import codec.asn1.Decoder;
import codec.asn1.Encoder;
import java.io.IOException;

public class ASN1TaggedType
extends ASN1AbstractType {
    private int tag_;
    private int cls_ = 128;
    private ASN1Type inner_;

    public ASN1TaggedType(int tag, int cls, ASN1Type inner, boolean explicit) {
        this.setTag(tag);
        this.setTagClass(cls);
        this.setInnerType(inner);
        this.inner_.setExplicit(explicit);
    }

    public ASN1TaggedType(int tag, ASN1Type inner, boolean explicit) {
        this.setTag(tag);
        this.setTagClass(128);
        this.setInnerType(inner);
        this.inner_.setExplicit(explicit);
    }

    public ASN1TaggedType(int tag, ASN1Type inner, boolean explicit, boolean optional) {
        this.setTag(tag);
        this.setTagClass(128);
        this.setInnerType(inner);
        this.inner_.setExplicit(explicit);
        this.setOptional(optional);
    }

    public ASN1Type getInnerType() {
        return this.inner_;
    }

    public Object getValue() {
        return this.inner_.getValue();
    }

    public void setInnerType(ASN1Type t) {
        if (t == null) {
            throw new NullPointerException("Type is NULL!");
        }
        this.inner_ = t;
    }

    public void setTag(int tag) {
        this.tag_ = tag;
    }

    public int getTag() {
        return this.tag_;
    }

    public void setTagClass(int cls) {
        this.cls_ = cls;
    }

    public int getTagClass() {
        return this.cls_;
    }

    public boolean isExplicit() {
        return true;
    }

    public void setExplicit(boolean explicit) {
        if (!explicit) {
            throw new IllegalArgumentException("Tagget types are never IMPLICIT!");
        }
    }

    public void encode(Encoder enc) throws ASN1Exception, IOException {
        enc.writeTaggedType(this);
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        dec.readTaggedType(this);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        switch (this.cls_) {
            case 128: {
                buf.append("CONTEXT SPECIFIC ");
                break;
            }
            case 0: {
                buf.append("UNIVERSAL ");
                break;
            }
            case 64: {
                buf.append("APPLICATION ");
                break;
            }
            case 192: {
                buf.append("PRIVATE ");
            }
        }
        buf.append(this.tag_ + "] ");
        if (this.inner_.isExplicit()) {
            buf.append("EXPLICIT ");
        } else {
            buf.append("IMPLICIT ");
        }
        buf.append(this.inner_.toString());
        return buf.toString();
    }
}

