/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1VisibleString;
import codec.asn1.Decoder;
import codec.asn1.Encoder;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public abstract class ASN1Time
extends ASN1VisibleString {
    private static final TimeZone TZ = TimeZone.getTimeZone("GMT");
    protected static final String ZEROES = "0000";
    protected Date date_;

    public Date getDate() {
        return (Date)this.date_.clone();
    }

    public long getTime() {
        return this.date_.getTime();
    }

    public void setDate(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        this.date_ = calendar.getTime();
        this.setString0(this.toString(this.date_));
    }

    public void setDate(Date date) {
        if (date == null) {
            throw new NullPointerException("date");
        }
        this.date_ = (Date)date.clone();
        this.setString0(this.toString(this.date_));
    }

    public void setDate(long time) {
        this.date_ = new Date(time);
        this.setString0(this.toString(this.date_));
    }

    public void setDate(String date) {
        if (date == null) {
            throw new NullPointerException("date string");
        }
        this.date_ = this.toDate(date);
        this.setString0(this.toString(this.date_));
    }

    public void setString(String s) {
        this.date_ = this.toDate(s);
        this.setString0(s);
    }

    public void encode(Encoder enc) throws ASN1Exception, IOException {
        enc.writeTime(this);
    }

    public void decode(Decoder enc) throws ASN1Exception, IOException {
        enc.readTime(this);
    }

    protected abstract int[] getFields();

    protected abstract int[] getFieldLengths();

    protected abstract int[] getFieldCorrections();

    protected String toString(Date date) {
        if (date == null) {
            throw new NullPointerException("date");
        }
        GregorianCalendar cal = new GregorianCalendar(TZ);
        int[] fields = this.getFields();
        int[] correct = this.getFieldCorrections();
        int[] lengths = this.getFieldLengths();
        StringBuffer buf = new StringBuffer(20);
        cal.setTime(date);
        int n = 0;
        while (n < fields.length) {
            int v = cal.get(fields[n]) - correct[n];
            String s = String.valueOf(v);
            int len = s.length();
            int w = lengths[n];
            if (w == 0) {
                if (v > 0) {
                    buf.append(".");
                    s = ZEROES.substring(0, 3 - s.length()) + s;
                    if (s.charAt(s.length() - 1) != '0') {
                        buf.append(s);
                    } else {
                        int lastzero = s.length() - 1;
                        while (lastzero > 0 && s.charAt(lastzero - 1) == '0') {
                            --lastzero;
                        }
                        buf.append(s.substring(0, lastzero));
                    }
                }
            } else {
                if (w < 0) {
                    w = -w;
                }
                if (len < w) {
                    buf.append(ZEROES.substring(0, w - len));
                    buf.append(s);
                } else if (len > w) {
                    buf.append(s.substring(len - w));
                } else {
                    buf.append(s);
                }
            }
            ++n;
        }
        buf.append('Z');
        return buf.toString();
    }

    protected Date toDate(String code) {
        TimeZone tz;
        String s;
        char c;
        if (code == null) {
            throw new NullPointerException("code");
        }
        GregorianCalendar cal = new GregorianCalendar(TZ);
        cal.setTime(new Date(0L));
        int[] fields = this.getFields();
        int[] correct = this.getFieldCorrections();
        int[] lengths = this.getFieldLengths();
        int len = code.length();
        int pos = 0;
        int n = 0;
        while (n < fields.length) {
            block19: {
                int v;
                int w;
                block20: {
                    block18: {
                        w = lengths[n];
                        if (w != 0) break block18;
                        if (pos < len && ((c = code.charAt(pos)) == '.' || c == ',')) {
                            ++pos;
                            v = 0;
                            while (v < 3 && pos < len) {
                                if (!Character.isDigit(code.charAt(pos))) break;
                                ++pos;
                                ++v;
                            }
                            if (v == 0) {
                                throw new IllegalArgumentException("Milliseconds format error!");
                            }
                            s = code.substring(pos - v, pos);
                            if (v < 3) {
                                s = s + ZEROES.substring(0, 3 - v);
                            }
                            v = Integer.parseInt(s);
                            cal.set(fields[n], v += correct[n]);
                        }
                        break block19;
                    }
                    if (w >= 0) break block20;
                    w = -w;
                    if (pos >= len || !Character.isDigit(code.charAt(pos))) break block19;
                }
                s = code.substring(pos, pos + w);
                v = Integer.parseInt(s);
                v += correct[n];
                pos += w;
                if (fields[n] == 1 && lengths[n] == 2) {
                    v += v < 70 ? 2000 : 1900;
                }
                cal.set(fields[n], v);
            }
            ++n;
        }
        if (pos < len) {
            c = code.charAt(pos);
            if (c == '+' || c == '-') {
                s = code.substring(pos, pos + 5);
                tz = TimeZone.getTimeZone("GMT" + s);
                pos += 5;
            } else {
                if (code.charAt(pos) != 'Z') {
                    throw new IllegalArgumentException("Illegal char in place of 'Z' (" + pos + ")");
                }
                tz = TimeZone.getTimeZone("GMT");
                ++pos;
            }
        } else {
            tz = TimeZone.getDefault();
        }
        if (pos != len) {
            throw new IllegalArgumentException("Trailing characters after encoding! (" + pos + ")");
        }
        Calendar res = Calendar.getInstance(tz);
        res.setTime(new Date(0L));
        n = 0;
        while (n < fields.length) {
            res.set(fields[n], cal.get(fields[n]));
            ++n;
        }
        return res.getTime();
    }
}

