/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1Time;
import java.util.Calendar;
import java.util.Date;

public class ASN1UTCTime
extends ASN1Time {
    private static final int[] FIELDS = new int[]{1, 2, 5, 11, 12, 13};
    private static final int[] LENGTHS = new int[]{2, 2, 2, 2, 2, -2};
    private static final int[] CORRECT = new int[]{0, -1, 0, 0, 0, 0};

    public ASN1UTCTime() {
        this.setDate(new Date(0L));
    }

    public ASN1UTCTime(String date) {
        this.setDate(date);
    }

    public ASN1UTCTime(Calendar cal) {
        this.setDate(cal);
    }

    public ASN1UTCTime(Date date) {
        this.setDate(date);
    }

    public int getTag() {
        return 23;
    }

    protected int[] getFields() {
        return (int[])FIELDS.clone();
    }

    protected int[] getFieldLengths() {
        return (int[])LENGTHS.clone();
    }

    protected int[] getFieldCorrections() {
        return (int[])CORRECT.clone();
    }

    public void setDate(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        this.date_ = new Date(calendar.getTime().getTime() / 1000L * 1000L);
        this.setString0(this.toString(this.date_));
    }

    public void setDate(Date date) {
        if (date == null) {
            throw new NullPointerException("date");
        }
        this.date_ = new Date(date.getTime() / 1000L * 1000L);
        this.setString0(this.toString(this.date_));
    }

    public static void main(String[] argv) {
        try {
            ASN1UTCTime gt = new ASN1UTCTime();
            String s = gt.toString();
            System.out.println("Today: " + s);
            int n = 0;
            while (n < argv.length) {
                gt = new ASN1UTCTime(argv[n]);
                s = gt.toString();
                System.out.println("Date: " + gt.getDate());
                ++n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

