/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1BitString;
import codec.asn1.ASN1Boolean;
import codec.asn1.ASN1Collection;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Null;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1String;
import codec.asn1.ASN1TaggedType;
import codec.asn1.ASN1Time;
import codec.asn1.ASN1Type;
import codec.asn1.Encoder;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractEncoder
extends FilterOutputStream
implements Encoder {
    public AbstractEncoder(OutputStream out) {
        super(out);
    }

    public void writeType(ASN1Type t) throws ASN1Exception, IOException {
        t.encode(this);
    }

    protected void writeHeader(int tag, int cls, boolean prim, int len) throws IOException {
        int b = cls & 0xC0;
        if (!prim) {
            b |= 0x20;
        }
        if (tag > 30) {
            this.out.write(b |= 0x1F);
            this.writeBase128(tag);
        } else {
            this.out.write(b |= tag);
        }
        if (len == -1) {
            this.out.write(128);
        } else if (len > 127) {
            int i = (this.significantBits(len) + 7) / 8;
            this.out.write(i | 0x80);
            this.writeBase256(len);
        } else {
            this.out.write(len);
        }
    }

    protected int getHeaderLength(int tag, int len) {
        int n = 2;
        if (tag > 30) {
            n += (this.significantBits(tag) + 6) / 7;
        }
        if (len > 127) {
            n += (this.significantBits(len) + 7) / 8;
        }
        return n;
    }

    protected void writeBase128(int n) throws IOException {
        int i = (this.significantBits(n) + 6) / 7;
        int j = (i - 1) * 7;
        while (i > 1) {
            this.out.write(n >>> j & 0x7F | 0x80);
            j -= 7;
            --i;
        }
        this.out.write(n & 0x7F);
    }

    protected void writeBase256(int n) throws IOException {
        int i = (this.significantBits(n) + 7) / 8;
        int j = (i - 1) * 8;
        while (i > 0) {
            this.out.write(n >>> j & 0xFF);
            j -= 8;
            --i;
        }
    }

    protected int significantBits(int n) {
        if (n == 0) {
            return 1;
        }
        int i = 0;
        while (n > 255) {
            n >>>= 8;
            i += 8;
        }
        while (n > 0) {
            n >>>= 1;
            ++i;
        }
        return i;
    }

    public abstract void writeTypeIdentifier(ASN1Type var1) throws ASN1Exception, IOException;

    public abstract void writeTaggedType(ASN1TaggedType var1) throws ASN1Exception, IOException;

    public abstract void writeTime(ASN1Time var1) throws ASN1Exception, IOException;

    public abstract void writeCollection(ASN1Collection var1) throws ASN1Exception, IOException;

    public abstract void writeString(ASN1String var1) throws ASN1Exception, IOException;

    public abstract void writeReal(ASN1Type var1) throws ASN1Exception, IOException;

    public abstract void writeObjectIdentifier(ASN1ObjectIdentifier var1) throws ASN1Exception, IOException;

    public abstract void writeNull(ASN1Null var1) throws ASN1Exception, IOException;

    public abstract void writeOctetString(ASN1OctetString var1) throws ASN1Exception, IOException;

    public abstract void writeBitString(ASN1BitString var1) throws ASN1Exception, IOException;

    public abstract void writeInteger(ASN1Integer var1) throws ASN1Exception, IOException;

    public abstract void writeBoolean(ASN1Boolean var1) throws ASN1Exception, IOException;
}

