/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Type;
import codec.asn1.OIDRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractOIDRegistry
extends OIDRegistry {
    static /* synthetic */ Class class$codec$asn1$AbstractOIDRegistry;

    protected static void loadOIDMap(Map map, String path) {
        AbstractOIDRegistry.loadOIDMap2(map, "codec/asn1");
        AbstractOIDRegistry.loadOIDMap2(map, path);
    }

    protected abstract String getPrefix();

    /*
     * Loose catch block
     */
    private static void loadOIDMap2(Map map, String path) {
        if (map == null || path == null) {
            throw new NullPointerException("map or path");
        }
        int n = 0;
        InputStream in = ClassLoader.getSystemResourceAsStream(path + "/oid0.map");
        if (in == null && (in = (class$codec$asn1$AbstractOIDRegistry == null ? (class$codec$asn1$AbstractOIDRegistry = AbstractOIDRegistry.class$("codec.asn1.AbstractOIDRegistry")) : class$codec$asn1$AbstractOIDRegistry).getResourceAsStream(path + "/oid0.map")) == null && (in = (class$codec$asn1$AbstractOIDRegistry == null ? (class$codec$asn1$AbstractOIDRegistry = AbstractOIDRegistry.class$("codec.asn1.AbstractOIDRegistry")) : class$codec$asn1$AbstractOIDRegistry).getResourceAsStream("/" + path + "/oid0.map")) == null) {
            System.out.println("Warning: could not get resource at " + path);
        }
        while (in != null) {
            block14: {
                Properties props = new Properties();
                props.load(in);
                Iterator i = ((Hashtable)props).keySet().iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    if (key.indexOf(59) != -1) {
                        key = key.substring(0, key.indexOf(59));
                    }
                    if (key.endsWith(".")) continue;
                    String val = props.getProperty(key);
                    ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(key.trim());
                    map.put(oid, val);
                }
                Object var11_10 = null;
                try {
                    in.close();
                }
                catch (IOException e2) {
                    System.err.println(e2.getMessage());
                }
                break block14;
                {
                    catch (IOException e) {
                        System.err.println("Bad OID map: " + path + "/oid" + n + ".map");
                        var11_10 = null;
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            System.err.println(e2.getMessage());
                        }
                    }
                }
                catch (Throwable throwable) {
                    var11_10 = null;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        System.err.println(e2.getMessage());
                    }
                    throw throwable;
                }
            }
            in = ClassLoader.getSystemResourceAsStream(path + "/oid" + ++n + ".map");
        }
        if (map.size() == 0) {
            System.err.println("Warning: no OIDs loaded from " + path);
        }
    }

    public AbstractOIDRegistry() {
        this(null);
    }

    public AbstractOIDRegistry(OIDRegistry parent) {
        super(parent);
    }

    protected abstract Map getOIDMap();

    protected ASN1Type getLocalASN1Type(ASN1ObjectIdentifier oid) {
        Map map = this.getOIDMap();
        Object o = map.get(oid);
        if (o == null) {
            return null;
        }
        try {
            Class<?> c;
            if (o instanceof String) {
                c = Class.forName(this.getPrefix() + (String)o);
                map.put(new ASN1ObjectIdentifier(oid.getOID()), c);
                o = c;
            }
            c = (Class<?>)o;
            return (ASN1Type)c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

