/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1BitString;
import codec.asn1.ASN1Boolean;
import codec.asn1.ASN1Choice;
import codec.asn1.ASN1Collection;
import codec.asn1.ASN1CollectionOf;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Null;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Opaque;
import codec.asn1.ASN1String;
import codec.asn1.ASN1TaggedType;
import codec.asn1.ASN1Time;
import codec.asn1.ASN1Type;
import codec.asn1.Decoder;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Iterator;

public class DERDecoder
extends FilterInputStream
implements Decoder {
    protected int tag_;
    protected int tagclass_;
    protected int length_;
    protected boolean indefinite_;
    protected boolean primitive_;
    protected boolean skip_ = false;
    protected int pos_ = 0;
    protected int markpos_ = 0;
    protected int limit_;
    protected int[] oidbuf_ = new int[32];
    protected boolean debug_ = false;
    private static String[] typename_ = new String[]{null, "Boolean", "Integer", "BitString", "OctetString", "Null", "ObjectIdentifier", null, null, null, "Enumerated", null, "UTF8String", null, null, null, "Sequence", "Set", null, "PrintableString", "T61String", null, "IA5String", "UTCTime", "GeneralizedTime", null, "VisibleString", null, "UniversalString", null, "BMPString"};
    private static Class[] typeclass_ = DERDecoder.getClasses();
    static /* synthetic */ Class class$codec$asn1$DERDecoder;

    private static Class[] getClasses() {
        String s = (class$codec$asn1$DERDecoder == null ? (class$codec$asn1$DERDecoder = DERDecoder.class$("codec.asn1.DERDecoder")) : class$codec$asn1$DERDecoder).getName();
        int i = s.lastIndexOf(46);
        s = i < 0 ? "" : s.substring(0, i) + ".ASN1";
        int n = typename_.length;
        Class[] c = new Class[n];
        i = 0;
        while (i < n) {
            if (typename_[i] != null) {
                try {
                    c[i] = Class.forName(s + typename_[i]);
                }
                catch (ClassNotFoundException e) {
                    c[i] = null;
                }
            } else {
                c[i] = null;
            }
            ++i;
        }
        return c;
    }

    public static Class getClass(int tag) throws ASN1Exception {
        Class cls;
        if (tag < 0) {
            throw new IllegalArgumentException("Tag number is negative!");
        }
        if (tag < typeclass_.length && (cls = typeclass_[tag]) != null) {
            return cls;
        }
        throw new ASN1Exception("Unknown tag! (" + tag + ")");
    }

    public DERDecoder(InputStream in) {
        super(in);
    }

    public DERDecoder(InputStream in, int limit) {
        super(in);
        this.setInputLimit(limit);
    }

    public void setInputLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("No negative limits allowed!");
        }
        this.limit_ = limit;
    }

    public int getInputLimit() {
        return this.limit_;
    }

    public void setDebug(boolean debug) {
        this.debug_ = debug;
    }

    public boolean isDebug() {
        return this.debug_;
    }

    protected boolean readNext() throws ASN1Exception, IOException {
        int j = this.pos_;
        if (this.skip_) {
            if (this.debug_) {
                System.out.println("(" + j + ")\tSkipping.");
            }
            this.skip_ = false;
            return true;
        }
        int n = this.read();
        if (n < 0) {
            this.tag_ = -1;
            return false;
        }
        this.primitive_ = (n & 0x20) == 0;
        this.tagclass_ = n & 0xC0;
        this.tag_ = (n & 0x1F) == 31 ? this.readBase128() : n & 0x1F;
        n = this.read();
        if (n < 0) {
            throw new ASN1Exception("Unexpected EOF, length missing!");
        }
        this.indefinite_ = false;
        int m = n & 0x7F;
        if ((n & 0x80) == 128) {
            if (m == 0) {
                this.indefinite_ = true;
            } else {
                m = this.readBase256(m);
            }
        }
        this.length_ = m;
        if (this.length_ < 0) {
            throw new ASN1Exception("Negative length: " + this.length_);
        }
        if (this.limit_ > 0 && (m = this.pos_ + this.length_ - this.limit_) > 0) {
            throw new ASN1Exception("Maximum input limit violated by " + m + " octets!");
        }
        if (this.primitive_ && this.indefinite_) {
            throw new ASN1Exception("Encoding can't be PRIMITIVE and INDEFINITE LENGTH!");
        }
        if (this.debug_) {
            this.debugHeader(j);
        }
        return true;
    }

    private void debugHeader(int offset) {
        String t;
        StringBuffer sb = new StringBuffer();
        sb.append("(" + offset + ")\t");
        switch (this.tagclass_) {
            case 0: {
                t = "UNIVERSAL";
                break;
            }
            case 192: {
                t = "PRIVATE";
                break;
            }
            case 128: {
                t = "CONTEXT SPECIFIC";
                break;
            }
            case 64: {
                t = "APPLICATION";
                break;
            }
            default: {
                t = "*INTERNAL ERROR*";
            }
        }
        if (this.tagclass_ == 0 && this.tag_ < typename_.length) {
            String s = typename_[this.tag_];
            if (s == null) {
                sb.append("[UNIVERSAL " + this.tag_ + "] ");
            } else {
                sb.append(s + " ");
            }
        } else {
            sb.append("[" + t + " " + this.tag_ + "] ");
        }
        sb.append(this.primitive_ ? "PRIMITIVE " : "CONSTRUCTED ");
        sb.append("length: ");
        if (this.indefinite_) {
            sb.append("indefinite");
        } else {
            sb.append(this.length_);
        }
        System.out.println(sb.toString());
    }

    protected void match0(ASN1Type t, boolean primitive) throws ASN1Exception, IOException {
        if (!t.isExplicit()) {
            if (primitive != this.primitive_) {
                throw new ASN1Exception("PRIMTIVE vs. CONSTRUCTED mismatch!");
            }
            this.skipNext(false);
            return;
        }
        if (!this.readNext()) {
            throw new EOFException("End of stream reached!");
        }
        if (t.isType(this.tag_, this.tagclass_)) {
            if (primitive != this.primitive_) {
                throw new ASN1Exception("CONSTRUCTED vs. PRIMITIVE mismatch!");
            }
            return;
        }
        throw new ASN1Exception("Type mismatch!");
    }

    protected void match1(ASN1Type t) throws ASN1Exception, IOException {
        if (!t.isExplicit()) {
            this.skipNext(false);
            return;
        }
        if (!this.readNext()) {
            throw new EOFException("End of stream reached!");
        }
        if (t.isType(this.tag_, this.tagclass_)) {
            return;
        }
        throw new ASN1Exception("Type mismatch!");
    }

    protected void match2(int tag, int tagclass) throws IOException, ASN1Exception {
        if (!this.readNext()) {
            throw new EOFException("End of stream reached!");
        }
        if (tag != this.tag_ || tagclass != this.tagclass_) {
            throw new ASN1Exception("Type mismatch!");
        }
    }

    protected void skipNext(boolean skip) {
        this.skip_ = skip;
    }

    public ASN1Type readType() throws ASN1Exception, IOException {
        ASN1Type t;
        if (!this.readNext()) {
            throw new EOFException("End of encoding reached!");
        }
        if (this.tag_ == 0 && this.tagclass_ == 0) {
            if (this.length_ != 0) {
                throw new ASN1Exception("EOC with non-zero length!");
            }
            return null;
        }
        if (this.tagclass_ != 0) {
            if (this.indefinite_) {
                throw new ASN1Exception("The decoder encountered a non-UNIVERSAL type with INDEFINITE LENGTH encoding. There is not sufficient information to determine the actual length of this type. Please try again by providing the appropriate template structure to the decoder.");
            }
            this.primitive_ = true;
            ASN1OctetString o = new ASN1OctetString();
            ASN1TaggedType t2 = new ASN1TaggedType(this.tag_, this.tagclass_, o, false);
            this.readOctetString(o);
            return t2;
        }
        try {
            t = (ASN1Type)DERDecoder.getClass(this.tag_).newInstance();
        }
        catch (InstantiationException e) {
            throw new ASN1Exception("Internal error, can't instantiate type!");
        }
        catch (IllegalAccessException e) {
            throw new ASN1Exception("Internal error, can't access type!");
        }
        if (t instanceof ASN1Collection) {
            if (this.primitive_) {
                throw new ASN1Exception("Collections cannot be PRIMITIVE!");
            }
            this.readTypes((ASN1Collection)t);
        } else {
            this.skipNext(true);
            t.decode(this);
        }
        return t;
    }

    protected void readTypes(ASN1Collection c) throws ASN1Exception, IOException {
        int end = this.pos_ + this.length_;
        while (end > this.pos_) {
            ASN1Type o = this.readType();
            if (o == null) {
                throw new ASN1Exception("EOC cannot be component of a collection!");
            }
            c.add(o);
        }
        if (end < this.pos_) {
            throw new ASN1Exception("Length short by " + (this.pos_ - end) + " octets!");
        }
    }

    public void readType(ASN1Type t) throws ASN1Exception, IOException {
        t.decode(this);
    }

    public void readBoolean(ASN1Boolean t) throws ASN1Exception, IOException {
        this.match0(t, true);
        int b = this.read();
        if (b < 0) {
            throw new ASN1Exception("Unexpected EOF!");
        }
        if (b == 0) {
            t.setTrue(false);
        } else if (b == 255) {
            t.setTrue(true);
        } else {
            throw new ASN1Exception("Bad ASN.1 Boolean encoding!");
        }
    }

    public void readInteger(ASN1Integer t) throws ASN1Exception, IOException {
        this.match0(t, true);
        byte[] buf = new byte[this.length_];
        if (this.read(buf) < buf.length) {
            throw new ASN1Exception("Unexpected EOF!");
        }
        t.setBigInteger(new BigInteger(buf));
    }

    public void readBitString(ASN1BitString t) throws ASN1Exception, IOException {
        this.match0(t, true);
        if (this.length_ < 1) {
            throw new ASN1Exception("Length is zero, no initial octet!");
        }
        int pad = this.read();
        if (pad < 0) {
            throw new ASN1Exception("Unexpected EOF!");
        }
        byte[] buf = new byte[this.length_ - 1];
        if (buf.length > 0 && this.read(buf) < buf.length) {
            throw new ASN1Exception("Unexpected EOF!");
        }
        t.setBits(buf, pad);
    }

    public void readOctetString(ASN1OctetString t) throws ASN1Exception, IOException {
        this.match0(t, true);
        byte[] buf = new byte[this.length_];
        if (this.length_ > 0 && this.read(buf) < buf.length) {
            throw new ASN1Exception("Unexpected EOF!");
        }
        t.setByteArray(buf);
    }

    public void readNull(ASN1Null t) throws ASN1Exception, IOException {
        this.match0(t, true);
        if (this.length_ != 0 || this.indefinite_) {
            throw new ASN1Exception("ASN.1 Null has bad length!");
        }
    }

    public void readObjectIdentifier(ASN1ObjectIdentifier t) throws ASN1Exception, IOException {
        this.match0(t, true);
        if (this.length_ < 1) {
            throw new ASN1Exception("OID with not contents octets!");
        }
        int end = this.pos_ + this.length_;
        int n = this.read();
        if (n < 0 || n > 119) {
            throw new ASN1Exception("OID contents octet[0] must be [0,119]!");
        }
        this.oidbuf_[0] = n / 40;
        this.oidbuf_[1] = n % 40;
        int i = 2;
        try {
            while (this.pos_ < end) {
                this.oidbuf_[i++] = this.readBase128();
            }
            if (this.pos_ != end) {
                throw new ASN1Exception("Bad length!");
            }
            int[] oid = new int[i];
            System.arraycopy(this.oidbuf_, 0, oid, 0, i);
            t.setOID(oid);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ASN1Exception("Can't handle more than " + this.oidbuf_.length + " OID elements!");
        }
    }

    public void readReal(ASN1Type t) throws ASN1Exception {
        throw new ASN1Exception("Reals are not yet supported!");
    }

    public void readString(ASN1String t) throws ASN1Exception, IOException {
        this.match0(t, true);
        byte[] buf = new byte[this.length_];
        if (this.read(buf) < buf.length) {
            throw new ASN1Exception("Unexpected EOF!");
        }
        t.setString(t.convert(buf));
    }

    public void readCollection(ASN1Collection t) throws ASN1Exception, IOException {
        ASN1Type o;
        this.match0(t, false);
        int end = this.pos_ + this.length_;
        Iterator i = t.iterator();
        int n = 0;
        if (this.pos_ < end) {
            while (i.hasNext()) {
                if (!this.readNext()) break;
                this.skipNext(true);
                o = (ASN1Type)i.next();
                ++n;
                if (o.isType(this.tag_, this.tagclass_)) {
                    o.decode(this);
                    o.setOptional(false);
                    if (this.pos_ == end) break;
                    if (this.pos_ <= end) continue;
                    throw new ASN1Exception("Length short by " + (this.pos_ - end) + " octets!");
                }
                if (o.isOptional()) continue;
                throw new ASN1Exception("ASN.1 type mismatch!\nExpected: " + o.getClass().getName() + "\nIn      : " + t.getClass().getName() + "\nAt index: " + (n - 1) + "\nGot tag : " + this.tag_ + " and class: " + this.tagclass_);
            }
        }
        while (i.hasNext()) {
            o = (ASN1Type)i.next();
            ++n;
            if (o.isOptional()) continue;
            throw new ASN1Exception("ASN.1 type missing!\nExpected: " + o.getClass().getName() + "\nIn      : " + t.getClass().getName() + "\nAt index: " + (n - 1));
        }
        if (this.pos_ < end) {
            throw new ASN1Exception("Bad length, " + (end - this.pos_) + " contents octets left!");
        }
    }

    public void readCollectionOf(ASN1CollectionOf t) throws ASN1Exception, IOException {
        this.match0(t, false);
        t.clear();
        int end = this.pos_ + this.length_;
        while (this.pos_ < end) {
            ASN1Type o;
            try {
                o = t.newElement();
            }
            catch (IllegalStateException e) {
                throw new ASN1Exception("Cannot create new element! ");
            }
            o.decode(this);
        }
        if (this.pos_ != end) {
            throw new ASN1Exception("Bad length!");
        }
    }

    public void readTime(ASN1Time t) throws ASN1Exception, IOException {
        this.readString(t);
    }

    public void readTaggedType(ASN1TaggedType t) throws ASN1Exception, IOException {
        this.match1(t);
        ASN1Type o = t.getInnerType();
        if (o.isExplicit() && this.primitive_) {
            throw new ASN1Exception("PRIMITIVE vs. CONSTRUCTED mismatch!");
        }
        if (t instanceof ASN1Opaque) {
            if (this.indefinite_) {
                throw new ASN1Exception("Cannot decode indefinite length encodings with ASN1Opaque type!");
            }
            this.primitive_ = true;
        }
        o.decode(this);
    }

    public void readChoice(ASN1Choice t) throws ASN1Exception, IOException {
        if (!this.readNext()) {
            throw new IOException("Unexpected EOF!");
        }
        this.skipNext(true);
        ASN1Type o = t.getType(this.tag_, this.tagclass_);
        if (o == null) {
            throw new ASN1Exception("Type mismatch!");
        }
        o.decode(this);
        t.setInnerType(o);
    }

    /*
     * WARNING - void declaration
     */
    public int readBase128() throws ASN1Exception, IOException {
        int b;
        int n = 0;
        while ((b = this.read()) >= 0) {
            void var2_2;
            n = n << 7 | var2_2 & 0x7F;
            if ((var2_2 & 0x80) == 0) break;
        }
        if (b < 0) {
            throw new ASN1Exception("Unexpected EOF, base 128 octet missing!");
        }
        return n;
    }

    public int readBase256(int num) throws ASN1Exception, IOException {
        int n = 0;
        while (num > 0) {
            int b = this.read();
            if (b < 0) {
                throw new ASN1Exception("Unexpected EOF, base 256 octet missing!");
            }
            n = (n << 8) + b;
            --num;
        }
        return n;
    }

    public int read() throws IOException {
        int b = this.in.read();
        if (b >= 0) {
            ++this.pos_;
        }
        return b;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int ls = 0;
        while (ls < len) {
            int l = this.in.read(b, off + ls, len - ls);
            if (l < 0) break;
            ls += l;
        }
        this.pos_ += ls;
        return ls;
    }

    public int read(byte[] b) throws IOException {
        int ls = 0;
        while (ls < b.length) {
            int l = this.in.read(b, ls, b.length - ls);
            if (l < 0) break;
            ls += l;
        }
        this.pos_ += ls;
        return ls;
    }

    public long skip(long n) throws IOException {
        long l = this.in.skip(n);
        this.pos_ += (int)l;
        return l;
    }

    public void mark(int readAheadLimit) {
        this.in.mark(readAheadLimit);
        this.markpos_ = this.pos_;
    }

    public void reset() throws IOException {
        this.in.reset();
        this.pos_ = this.markpos_;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
        this.in = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

