/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1BitString;
import codec.asn1.ASN1Boolean;
import codec.asn1.ASN1Collection;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Null;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Opaque;
import codec.asn1.ASN1Set;
import codec.asn1.ASN1SetOf;
import codec.asn1.ASN1String;
import codec.asn1.ASN1TagComparator;
import codec.asn1.ASN1TaggedType;
import codec.asn1.ASN1Time;
import codec.asn1.ASN1Type;
import codec.asn1.AbstractEncoder;
import codec.asn1.DERCodeComparator;
import codec.asn1.RunLengthEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class DEREncoder
extends AbstractEncoder {
    private int[] stack_;
    private int sp_;
    private boolean strict = false;
    private int constructed_ = 197120;

    public DEREncoder(OutputStream out) {
        super(out);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean _strictness) {
        this.strict = _strictness;
    }

    protected void writeHeader(ASN1Type t, boolean primitive) throws ASN1Exception, IOException {
        if (!t.isExplicit()) {
            return;
        }
        if (this.stack_ == null || this.sp_ == 0) {
            RunLengthEncoder enc = new RunLengthEncoder();
            enc.writeType(t);
            this.stack_ = enc.getLengthFields();
            this.sp_ = this.stack_.length;
            if (this.sp_ < 1) {
                throw new ASN1Exception("Cannot determine length!");
            }
        }
        int length = this.stack_[--this.sp_];
        this.writeHeader(t.getTag(), t.getTagClass(), primitive, length);
    }

    public void writeBoolean(ASN1Boolean t) throws ASN1Exception, IOException {
        if (t.isOptional()) {
            return;
        }
        this.writeHeader(t, true);
        this.write(t.isTrue() ? 255 : 0);
    }

    public void writeInteger(ASN1Integer t) throws ASN1Exception, IOException {
        if (t.isOptional()) {
            return;
        }
        this.writeHeader(t, true);
        this.write(t.getBigInteger().toByteArray());
    }

    public void help(byte[] b) {
        int i = 0;
        while (i < b.length) {
            System.err.println("  " + (b[i] & 0xFF));
            ++i;
        }
    }

    public void writeBitString(ASN1BitString t) throws ASN1Exception, IOException {
        if (t.isOptional()) {
            return;
        }
        this.writeHeader(t, true);
        this.write(t.getPadCount());
        if (!t.isZero()) {
            this.write(t.getBytes());
        }
    }

    public void writeOctetString(ASN1OctetString t) throws ASN1Exception, IOException {
        if (t.isOptional()) {
            return;
        }
        this.writeHeader(t, true);
        this.write(t.getByteArray());
    }

    public void writeNull(ASN1Null t) throws ASN1Exception, IOException {
        if (t.isOptional()) {
            return;
        }
        this.writeHeader(t, true);
    }

    public void writeObjectIdentifier(ASN1ObjectIdentifier t) throws ASN1Exception, IOException {
        if (t.isOptional()) {
            return;
        }
        this.writeHeader(t, true);
        int[] e = t.getOID();
        if (e.length < 2) {
            throw new ASN1Exception("OID must have at least 2 elements!");
        }
        this.write(e[0] * 40 + e[1]);
        int i = 2;
        while (i < e.length) {
            this.writeBase128(e[i]);
            ++i;
        }
    }

    public void writeReal(ASN1Type t) {
        throw new UnsupportedOperationException("Real is not yet supported!");
    }

    public void writeString(ASN1String t) throws ASN1Exception, IOException {
        if (t.isOptional()) {
            return;
        }
        this.writeHeader(t, true);
        this.write(t.convert(t.getString()));
    }

    public void writeCollection(ASN1Collection t) throws ASN1Exception, IOException {
        if (t.isOptional()) {
            return;
        }
        this.writeHeader(t, false);
        ArrayList c = t.getCollection();
        if (this.isStrict() && t instanceof ASN1SetOf) {
            this.writeStrictSetOf((ASN1SetOf)t);
            return;
        }
        if (this.isStrict() && t instanceof ASN1Set) {
            ArrayList h = new ArrayList(c.size());
            h.addAll(c);
            Collections.sort(h, new ASN1TagComparator());
            c = h;
        }
        try {
            Iterator i = c.iterator();
            while (i.hasNext()) {
                this.writeType((ASN1Type)i.next());
            }
        }
        catch (ClassCastException e) {
            throw new ASN1Exception("Non-ASN.1 type in collection!");
        }
    }

    protected void writeStrictSetOf(ASN1SetOf t) throws ASN1Exception, IOException {
        Iterator i;
        Collection c = t.getCollection();
        ArrayList<byte[]> res = new ArrayList<byte[]>(c.size());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStream old = this.out;
        this.out = bos;
        try {
            i = c.iterator();
            while (i.hasNext()) {
                this.writeType((ASN1Type)i.next());
                if (bos.size() <= 0) continue;
                res.add(bos.toByteArray());
                bos.reset();
            }
            Object var9_7 = null;
            this.out = old;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.out = old;
            throw throwable;
        }
        Collections.sort(res, new DERCodeComparator());
        i = ((AbstractList)res).iterator();
        while (i.hasNext()) {
            byte[] buf = (byte[])i.next();
            this.write(buf, 0, buf.length);
        }
    }

    public void writeTime(ASN1Time t) throws ASN1Exception, IOException {
        this.writeString(t);
    }

    public void writeTaggedType(ASN1TaggedType t) throws ASN1Exception, IOException {
        boolean primitive;
        if (t.isOptional()) {
            return;
        }
        ASN1Type o = t.getInnerType();
        if (!o.isExplicit()) {
            int tag = t instanceof ASN1Opaque ? t.getTag() : o.getTag();
            primitive = (this.constructed_ & 1 << tag) == 0;
        } else {
            primitive = false;
        }
        this.writeHeader(t, primitive);
        this.writeType(t.getInnerType());
    }

    public void writeTypeIdentifier(ASN1Type t) {
        throw new UnsupportedOperationException("TypeIdentifier is not yet supported!");
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public void writeType(ASN1Type t) throws ASN1Exception, IOException {
        if (!t.isOptional()) {
            t.encode(this);
        }
    }

    protected void writeHeader(int tag, int cls, boolean prim, int len) throws IOException {
        int b = cls & 0xC0;
        if (!prim) {
            b |= 0x20;
        }
        if (tag > 30) {
            this.out.write(b |= 0x1F);
            this.writeBase128(tag);
        } else {
            this.out.write(b |= tag);
        }
        if (len == -1) {
            this.out.write(128);
        } else if (len > 127) {
            int i = (this.significantBits(len) + 7) / 8;
            this.out.write(i | 0x80);
            this.writeBase256(len);
        } else {
            this.out.write(len);
        }
    }

    protected int getHeaderLength(int tag, int len) {
        int n = 2;
        if (tag > 30) {
            n += (this.significantBits(tag) + 6) / 7;
        }
        if (len > 127) {
            n += (this.significantBits(len) + 7) / 8;
        }
        return n;
    }

    protected void writeBase128(int n) throws IOException {
        int i = (this.significantBits(n) + 6) / 7;
        int j = (i - 1) * 7;
        while (i > 1) {
            this.out.write(n >>> j & 0x7F | 0x80);
            j -= 7;
            --i;
        }
        this.out.write(n & 0x7F);
    }

    protected void writeBase256(int n) throws IOException {
        int i = (this.significantBits(n) + 7) / 8;
        int j = (i - 1) * 8;
        while (i > 0) {
            this.out.write(n >>> j & 0xFF);
            j -= 8;
            --i;
        }
    }

    protected int significantBits(int n) {
        if (n == 0) {
            return 1;
        }
        int i = 0;
        while (n > 255) {
            n >>>= 8;
            i += 8;
        }
        while (n > 0) {
            n >>>= 1;
            ++i;
        }
        return i;
    }
}

