/*
 * Decompiled with CFR 0.152.
 */
package codec.pkcs10;

import codec.CorruptedCodeException;
import codec.InconsistentStateException;
import codec.asn1.ASN1BitString;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Set;
import codec.asn1.ASN1SetOf;
import codec.asn1.ASN1TaggedType;
import codec.asn1.ConstraintException;
import codec.asn1.DERDecoder;
import codec.asn1.DEREncoder;
import codec.x501.Name;
import codec.x509.AlgorithmIdentifier;
import codec.x509.SubjectPublicKeyInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CertificationRequest
extends ASN1Sequence {
    private ASN1Sequence certificationRequestInfo_ = new ASN1Sequence();
    private ASN1Integer version_ = new ASN1Integer(0);
    private Name subject_ = null;
    private SubjectPublicKeyInfo subjectPublicKeyInfo_ = null;
    private ASN1Set attributes_ = null;
    private AlgorithmIdentifier signatureAlgorithmIdentifier_ = null;
    private ASN1BitString signature_ = null;
    static /* synthetic */ Class class$codec$x501$Attribute;

    public CertificationRequest() {
        super(3);
        this.certificationRequestInfo_.add(this.version_);
        this.subject_ = new Name();
        this.certificationRequestInfo_.add(this.subject_);
        this.subjectPublicKeyInfo_ = new SubjectPublicKeyInfo();
        this.certificationRequestInfo_.add(this.subjectPublicKeyInfo_);
        this.attributes_ = new ASN1SetOf(class$codec$x501$Attribute == null ? (class$codec$x501$Attribute = CertificationRequest.class$("codec.x501.Attribute")) : class$codec$x501$Attribute);
        this.certificationRequestInfo_.add(new ASN1TaggedType(0, this.attributes_, false, false));
        this.add(this.certificationRequestInfo_);
        this.signatureAlgorithmIdentifier_ = new AlgorithmIdentifier();
        this.add(this.signatureAlgorithmIdentifier_);
        this.signature_ = new ASN1BitString();
        this.add(this.signature_);
    }

    public CertificationRequest(byte[] enc) throws ASN1Exception {
        this();
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(enc);
            this.decode(new DERDecoder(bais));
            bais.close();
        }
        catch (IOException e) {
            throw new ASN1Exception(e.getMessage());
        }
    }

    public CertificationRequest(InputStream in) throws ASN1Exception, IOException {
        this();
        DERDecoder dec = new DERDecoder(in);
        this.decode(dec);
        dec.close();
    }

    public CertificationRequest(PublicKey pk, Name sub) throws InvalidKeyException {
        this();
        this.setPublicKey(pk);
        this.setSubjectDN(sub);
    }

    public CertificationRequest(PublicKey pk, Name sub, Collection attr) throws InvalidKeyException {
        this();
        this.setPublicKey(pk);
        this.setSubjectDN(sub);
        this.setAttributes(attr);
    }

    public List getAttributes() {
        return Collections.unmodifiableList(this.attributes_);
    }

    public byte[] getEncoded() throws ASN1Exception {
        byte[] res;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.encode(new DEREncoder(baos));
            res = baos.toByteArray();
            baos.close();
        }
        catch (IOException e) {
            throw new ASN1Exception(e.getMessage());
        }
        return res;
    }

    public PublicKey getPublicKey() throws NoSuchAlgorithmException {
        return this.subjectPublicKeyInfo_.getPublicKey();
    }

    public AlgorithmIdentifier getPublicKeyAlgorithm() {
        return this.subjectPublicKeyInfo_.getAlgorithmIdentifier();
    }

    public byte[] getSignature() {
        return this.signature_.getBytes();
    }

    public Name getSubjectDN() {
        return this.subject_;
    }

    public byte[] getTBS() throws CorruptedCodeException {
        byte[] res;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.certificationRequestInfo_.encode(new DEREncoder(baos));
            res = baos.toByteArray();
            baos.close();
        }
        catch (IOException e) {
            throw new CorruptedCodeException("internal error: " + e.getMessage());
        }
        catch (ASN1Exception e) {
            throw new CorruptedCodeException(e.getMessage());
        }
        return res;
    }

    public void setAttributes(Collection attributes) {
        if (attributes == null) {
            throw new NullPointerException("Attributes instance is null!");
        }
        this.attributes_.clear();
        this.attributes_.addAll(attributes);
    }

    private void setPublicKey(PublicKey pk) throws InvalidKeyException {
        this.subjectPublicKeyInfo_ = new SubjectPublicKeyInfo(pk);
        this.certificationRequestInfo_.set(2, this.subjectPublicKeyInfo_);
    }

    public void setSignature(byte[] sg, AlgorithmIdentifier algID) {
        try {
            this.signature_.setBits(sg, 0);
            this.signatureAlgorithmIdentifier_ = algID;
            this.set(1, this.signatureAlgorithmIdentifier_);
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
    }

    private void setSubjectDN(Name sub) {
        this.subject_ = sub;
        this.certificationRequestInfo_.set(1, sub);
    }

    public String toString() {
        String res = "";
        res = "PKCS#10 Certification Request:";
        res = res + "\nSubject: " + this.subject_.toString();
        res = res + "\nAlgorithm: " + this.subjectPublicKeyInfo_.getAlgorithmIdentifier();
        res = res + "\nKey: ";
        try {
            res = res + this.subjectPublicKeyInfo_.getPublicKey().toString();
        }
        catch (NoSuchAlgorithmException e) {
            res = res + "Key algorithm not supported!";
        }
        catch (InconsistentStateException e) {
            res = res + "Key data corrupted!";
        }
        res = res + "\nAttributes: " + this.attributes_.size() + "elements \n";
        return res;
    }

    public void verify() throws NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify("");
    }

    public void verify(String pro) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature theSig = null;
        String alg_name = this.signatureAlgorithmIdentifier_.getAlgorithmName();
        String alg_oid = this.signatureAlgorithmIdentifier_.getAlgorithmOID().toString();
        try {
            theSig = pro != null && !pro.equals("") ? Signature.getInstance(alg_name, pro) : Signature.getInstance(alg_name);
        }
        catch (NoSuchAlgorithmException nsae) {
            theSig = pro != null && !pro.equals("") ? Signature.getInstance(alg_oid, pro) : Signature.getInstance(alg_oid);
        }
        try {
            PublicKey thePubKey = this.getPublicKey();
            theSig.initVerify(thePubKey);
            theSig.update(this.getTBS());
            if (!theSig.verify(this.getSignature())) {
                throw new SignatureException("invalid Signature!");
            }
        }
        catch (CorruptedCodeException e) {
            throw new InvalidKeyException("Key material could not be obtained");
        }
    }

    public void sign(Signature sig, PublicKey signerPub) throws SignatureException, CertificateEncodingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        try {
            AlgorithmIdentifier keyAlgID = AlgorithmIdentifier.createAlgorithmIdentifier(signerPub);
            AlgorithmParameters params = keyAlgID.getParameters();
            AlgorithmIdentifier sigAlgID = new AlgorithmIdentifier(sig.getAlgorithm(), params);
            sig.update(this.getTBS());
            this.setSignature(sig.sign(), sigAlgID);
        }
        catch (CorruptedCodeException cce) {
            throw new CertificateEncodingException("Caught CorruptedCodeException: " + cce.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

