/*
 * Decompiled with CFR 0.152.
 */
package codec.pkcs12;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1SequenceOf;
import codec.asn1.BERDecoder;
import codec.asn1.DEREncoder;
import codec.pkcs12.SafeContents;
import codec.pkcs7.ContentInfo;
import codec.pkcs7.Data;
import codec.pkcs7.EncryptedData;
import codec.pkcs7.EnvelopedData;
import codec.x501.BadNameException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.NoSuchElementException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class AuthenticatedSafe
extends ASN1SequenceOf
implements Serializable {
    private static final int[] OID_ = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 6};
    public static final int NO_PROTECTION = 0;
    public static final int PASSWORD_PROTECTION = 1;
    public static final int PUBLIC_KEY_PROTECTION = 2;
    static /* synthetic */ Class class$codec$pkcs7$ContentInfo;

    public AuthenticatedSafe() {
        super(class$codec$pkcs7$ContentInfo == null ? (class$codec$pkcs7$ContentInfo = AuthenticatedSafe.class$("codec.pkcs7.ContentInfo")) : class$codec$pkcs7$ContentInfo);
    }

    public AuthenticatedSafe(SafeContents safe) throws IOException, ASN1Exception {
        super(class$codec$pkcs7$ContentInfo == null ? (class$codec$pkcs7$ContentInfo = AuthenticatedSafe.class$("codec.pkcs7.ContentInfo")) : class$codec$pkcs7$ContentInfo);
        this.addSafeContents(safe);
    }

    public AuthenticatedSafe(SafeContents safe, char[] passwd, String algorithm) throws IOException, ASN1Exception, GeneralSecurityException {
        super(class$codec$pkcs7$ContentInfo == null ? (class$codec$pkcs7$ContentInfo = AuthenticatedSafe.class$("codec.pkcs7.ContentInfo")) : class$codec$pkcs7$ContentInfo);
        this.addSafeContents(safe, passwd, algorithm);
    }

    public AuthenticatedSafe(SafeContents safe, SecretKey key, String algorithm, AlgorithmParameters params, X509Certificate[] cert) throws IOException, ASN1Exception, BadNameException, GeneralSecurityException {
        super(class$codec$pkcs7$ContentInfo == null ? (class$codec$pkcs7$ContentInfo = AuthenticatedSafe.class$("codec.pkcs7.ContentInfo")) : class$codec$pkcs7$ContentInfo);
        this.addSafeContents(safe, key, algorithm, params, cert);
    }

    public void addSafeContents(SafeContents safe) throws IOException, ASN1Exception {
        ContentInfo cinfo = this.makeData(safe);
        this.add(cinfo);
    }

    public void addSafeContents(SafeContents safe, char[] passwd, String algorithm) throws IOException, ASN1Exception, GeneralSecurityException {
        ContentInfo cinfo = this.makeEncryptedData(safe, passwd, algorithm);
        this.add(cinfo);
    }

    public void addSafeContents(SafeContents safe, SecretKey key, String algorithm, AlgorithmParameters params, X509Certificate[] cert) throws IOException, ASN1Exception, BadNameException, GeneralSecurityException {
        ContentInfo cinfo = this.makeEnvelopedData(safe, key, algorithm, params, cert);
        this.add(cinfo);
    }

    public ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier(OID_);
    }

    public int[] getProtectionMode() {
        int[] proMode = new int[this.size()];
        int i = 0;
        while (i < this.size()) {
            ContentInfo cinfo = (ContentInfo)this.get(i);
            if (cinfo.getContent() instanceof Data) {
                proMode[i] = 0;
            } else if (cinfo.getContent() instanceof EncryptedData) {
                proMode[i] = 1;
            } else if (cinfo.getContent() instanceof EnvelopedData) {
                proMode[i] = 2;
            } else {
                throw new IllegalStateException("Illegal protection mode: " + proMode[i]);
            }
            ++i;
        }
        return proMode;
    }

    public SafeContents getSafeContents(int i) throws IOException, ASN1Exception {
        ContentInfo cinfo = (ContentInfo)this.get(i);
        if (!(cinfo.getContent() instanceof Data)) {
            System.out.println("This bag is either password or public-key protected.");
            return null;
        }
        byte[] encodedData = ((Data)cinfo.getContent()).getByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(encodedData);
        SafeContents safe = new SafeContents();
        BERDecoder decoder = new BERDecoder(bais);
        safe.decode(decoder);
        bais.close();
        return safe;
    }

    public SafeContents getSafeContents(int i, char[] passwd) throws IOException, ASN1Exception, GeneralSecurityException {
        PBEKeySpec pbeSpec = null;
        byte[] data = null;
        EncryptedData encData = null;
        if (!(((ContentInfo)this.get(i)).getContent() instanceof EncryptedData)) {
            System.out.println("This bag is public-key protected or not protected at all.");
            return null;
        }
        encData = (EncryptedData)((ContentInfo)this.get(i)).getContent();
        String algName = encData.getAlgorithm();
        pbeSpec = new PBEKeySpec(passwd);
        SecretKeyFactory skf = null;
        skf = SecretKeyFactory.getInstance(algName);
        SecretKey pbeKey = skf.generateSecret(pbeSpec);
        encData.init(pbeKey);
        data = encData.getData();
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        SafeContents safe = new SafeContents();
        BERDecoder decoder = new BERDecoder(bais);
        safe.decode(decoder);
        bais.close();
        return safe;
    }

    public SafeContents getSafeContents(int i, PrivateKey key, X509Certificate cert) throws IOException, ASN1Exception, GeneralSecurityException, NoSuchElementException {
        ContentInfo cinfo = (ContentInfo)this.get(i);
        EnvelopedData envData = null;
        if (!(cinfo.getContent() instanceof EnvelopedData)) {
            System.out.println("This bag is password protected or not protected at all.");
            return null;
        }
        envData = (EnvelopedData)cinfo.getContent();
        envData.init(cert, key);
        byte[] data = envData.getData();
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        SafeContents safe = new SafeContents();
        BERDecoder decoder = new BERDecoder(bais);
        safe.decode(decoder);
        bais.close();
        return safe;
    }

    private ContentInfo makeData(SafeContents safe) throws IOException, ASN1Exception {
        Data data = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEREncoder encoder = new DEREncoder(baos);
        safe.encode(encoder);
        data = new Data(baos.toByteArray());
        baos.close();
        ContentInfo cInfo = new ContentInfo(data);
        return cInfo;
    }

    private ContentInfo makeEncryptedData(SafeContents safe, char[] pwd, String algorithm) throws IOException, ASN1Exception, GeneralSecurityException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEREncoder encoder = new DEREncoder(baos);
        safe.encode(encoder);
        byte[] help = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(help);
        baos.close();
        byte[] salt = new byte[64];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(salt);
        PBEParameterSpec spec = new PBEParameterSpec(salt, 1);
        AlgorithmParameters params = AlgorithmParameters.getInstance(algorithm);
        params.init(spec);
        PBEKeySpec pbeSpec = new PBEKeySpec(pwd);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(algorithm);
        SecretKey pbekey = skf.generateSecret(pbeSpec);
        EncryptedData ecd = new EncryptedData(algorithm, pbekey, params);
        ecd.setData(bais);
        bais.close();
        ContentInfo cinfo = new ContentInfo();
        cinfo.setContent(new ASN1ObjectIdentifier("1.2.840.113549.1.7.6"), ecd);
        return cinfo;
    }

    private ContentInfo makeEnvelopedData(SafeContents safe, SecretKey key, String algorithm, AlgorithmParameters params, X509Certificate[] cert) throws IOException, GeneralSecurityException, BadNameException, ASN1Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEREncoder encoder = new DEREncoder(baos);
        safe.encode(encoder);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        baos.close();
        EnvelopedData edata = new EnvelopedData(key, algorithm, params);
        edata.setData(bais);
        bais.close();
        int i = 0;
        while (i < cert.length) {
            edata.addRecipient(cert[i]);
            ++i;
        }
        ContentInfo cinfo = new ContentInfo(edata);
        return cinfo;
    }

    public String toString() {
        String res = "AuthenticatedSafe {\n";
        int i = 0;
        while (i < super.size()) {
            try {
                res = res + "SafeContents " + i + ": \n";
                if (((ContentInfo)this.get(i)).getContent() instanceof Data) {
                    res = res + this.getSafeContents(i) + "\n";
                } else if (((ContentInfo)this.get(i)).getContent() instanceof EncryptedData) {
                    res = res + "Password-Encrypted SafeBag \n";
                } else if (((ContentInfo)this.get(i)).getContent() instanceof EnvelopedData) {
                    res = res + "Public-Key-Encrypted SafeBag \n";
                }
            }
            catch (Exception e) {
                res = res + "<SafeContent not printable>\n";
            }
            ++i;
        }
        res = res + "}";
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

