/*
 * Decompiled with CFR 0.152.
 */
package codec.pkcs12;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1OpenType;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1TaggedType;
import codec.asn1.ASN1Type;
import codec.asn1.Decoder;
import codec.pkcs12.PKCS12OIDRegistry;
import codec.x509.X509Crl;
import java.io.IOException;
import java.io.Serializable;
import java.security.cert.CRLException;

public class CRLBag
extends ASN1Sequence
implements Serializable {
    private int[] oid_ = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 4};
    private ASN1ObjectIdentifier crlId_;
    private ASN1TaggedType crlValue_;
    protected PKCS12OIDRegistry reg_ = new PKCS12OIDRegistry();

    public CRLBag() {
        super(2);
        this.crlId_ = new ASN1ObjectIdentifier();
        this.add(this.crlId_);
        ASN1OpenType ot = new ASN1OpenType(this.reg_, this.crlId_);
        this.crlValue_ = new ASN1TaggedType(0, ot, true);
        this.add(this.crlValue_);
    }

    public CRLBag(X509Crl crl) throws CRLException {
        super(2);
        this.crlId_ = new ASN1ObjectIdentifier("1.2.840.113549.1.9.23");
        this.add(this.crlId_);
        ASN1OctetString x509 = new ASN1OctetString(crl.getEncoded());
        this.crlValue_ = new ASN1TaggedType(0, x509, true);
        this.add(this.crlValue_);
    }

    public void decode(Decoder decoder) throws ASN1Exception, IOException {
        super.decode(decoder);
        ASN1Type t = this.crlValue_.getInnerType();
        if (t instanceof ASN1OpenType) {
            ASN1OpenType o = (ASN1OpenType)t;
            this.crlValue_.setInnerType(o.getInnerType());
        }
    }

    public ASN1ObjectIdentifier getCrlId() {
        return this.crlId_;
    }

    public ASN1Type getCrlValue() {
        return this.crlValue_.getInnerType();
    }

    public ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier(this.oid_);
    }
}

