/*
 * Decompiled with CFR 0.152.
 */
package codec.pkcs12;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1OpenType;
import codec.asn1.ASN1RegisteredType;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1TaggedType;
import codec.asn1.ASN1Type;
import codec.asn1.Decoder;
import codec.pkcs12.PKCS12OIDRegistry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class CertBag
extends ASN1Sequence
implements ASN1RegisteredType,
Serializable {
    private static final int[] OID_ = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 3};
    private ASN1ObjectIdentifier certId_;
    private ASN1TaggedType certValue_;
    private ASN1OctetString x509Cert_;
    protected PKCS12OIDRegistry reg_ = new PKCS12OIDRegistry();

    public CertBag() {
        super(2);
        this.certId_ = new ASN1ObjectIdentifier();
        this.add(this.certId_);
        ASN1OpenType ot = new ASN1OpenType(this.reg_, this.certId_);
        this.certValue_ = new ASN1TaggedType(0, ot, true);
        this.add(this.certValue_);
    }

    public CertBag(X509Certificate cert) throws CertificateEncodingException {
        super(2);
        this.certId_ = new ASN1ObjectIdentifier("1.2.840.113549.1.9.22.1");
        this.add(this.certId_);
        this.x509Cert_ = new ASN1OctetString(cert.getEncoded());
        this.certValue_ = new ASN1TaggedType(0, this.x509Cert_, true);
        this.add(this.certValue_);
    }

    public void decode(Decoder decoder) throws ASN1Exception, IOException {
        super.decode(decoder);
        ASN1Type t = this.certValue_.getInnerType();
        if (t instanceof ASN1OpenType) {
            ASN1OpenType o = (ASN1OpenType)t;
            this.certValue_.setInnerType(o.getInnerType());
        }
    }

    public ASN1ObjectIdentifier getCertId() {
        return this.certId_;
    }

    public X509Certificate getCertificate() throws CertificateException {
        byte[] derCert = ((ASN1OctetString)this.certValue_.getInnerType()).getByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(derCert);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
        try {
            bais.close();
        }
        catch (IOException io) {
            System.out.println("Internal error. shouldn't happen:");
            io.printStackTrace();
        }
        return cert;
    }

    public ASN1Type getCertValue() {
        return this.certValue_.getInnerType();
    }

    public ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier(OID_);
    }
}

