/*
 * Decompiled with CFR 0.152.
 */
package codec.pkcs7;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Opaque;
import codec.asn1.ASN1Set;
import codec.asn1.ASN1SetOf;
import codec.asn1.Decoder;
import codec.asn1.Encoder;
import codec.util.CertificateIterator;
import codec.util.CertificateSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.ListIterator;

public class Certificates
extends ASN1SetOf
implements CertificateSource {
    protected CertificateFactory factory_;
    protected ASN1Set cache_;
    static /* synthetic */ Class class$codec$asn1$ASN1Opaque;

    public Certificates() {
        super(class$codec$asn1$ASN1Opaque == null ? (class$codec$asn1$ASN1Opaque = Certificates.class$("codec.asn1.ASN1Opaque")) : class$codec$asn1$ASN1Opaque);
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        super.decode(dec);
        if (this.factory_ == null) {
            try {
                this.factory_ = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException e1) {
                try {
                    this.factory_ = CertificateFactory.getInstance("X509");
                }
                catch (CertificateException e2) {
                    throw new ASN1Exception(e2.getMessage());
                }
            }
        }
        this.cache_ = null;
        try {
            int i = this.size() - 1;
            while (i >= 0) {
                ASN1Opaque o = (ASN1Opaque)this.get(i);
                X509Certificate cert = (X509Certificate)this.factory_.generateCertificate(new ByteArrayInputStream(o.getEncoded()));
                this.set(i, cert);
                --i;
            }
        }
        catch (CertificateException e) {
            throw new ASN1Exception(e.getMessage());
        }
    }

    public void encode(Encoder enc) throws ASN1Exception, IOException {
        if (this.isOptional()) {
            super.encode(enc);
            return;
        }
        if (this.cache_ == null) {
            this.cache_ = new ASN1Set(this.size());
        }
        this.cache_.setOptional(this.isOptional());
        this.cache_.setExplicit(this.isExplicit());
        if (this.cache_.size() < this.size()) {
            ListIterator i = ((AbstractList)this).listIterator(this.cache_.size());
            while (i.hasNext()) {
                try {
                    X509Certificate cert = (X509Certificate)i.next();
                    this.cache_.add(new ASN1Opaque(cert.getEncoded()));
                }
                catch (CertificateEncodingException e) {
                    throw new ASN1Exception(e.getMessage());
                }
            }
        }
        this.cache_.encode(enc);
    }

    public void setCertificateFactory(CertificateFactory factory) {
        this.factory_ = factory;
    }

    public boolean addCertificate(X509Certificate cert) {
        BigInteger serial;
        Principal issuer = cert.getIssuerDN();
        if (this.getCertificate(issuer, serial = cert.getSerialNumber()) == null) {
            this.add(cert);
            return true;
        }
        return false;
    }

    public X509Certificate getCertificate(Principal issuer, BigInteger serial) {
        if (issuer == null || serial == null) {
            throw new NullPointerException("Issuer or serial number!");
        }
        Iterator i = ((AbstractList)this).iterator();
        while (i.hasNext()) {
            X509Certificate cert = (X509Certificate)i.next();
            if (!issuer.equals(cert.getIssuerDN()) || !serial.equals(cert.getSerialNumber())) continue;
            return cert;
        }
        return null;
    }

    public Iterator certificates(Principal subject) {
        return new CertificateIterator(subject, 0, ((AbstractList)this).iterator());
    }

    public Iterator certificates(Principal subject, int keyUsage) {
        return new CertificateIterator(subject, keyUsage, ((AbstractList)this).iterator());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

