/*
 * Decompiled with CFR 0.152.
 */
package codec.pkcs7;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1TaggedType;
import codec.asn1.Decoder;
import codec.pkcs7.RecipientInfo;
import codec.x501.BadNameException;
import codec.x509.AlgorithmIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class EncryptedContentInfo
extends ASN1Sequence {
    public static final int BUFFER_SIZE = 4096;
    private static final int[] DATA_OID = new int[]{1, 2, 840, 113549, 1, 7, 1};
    protected ASN1ObjectIdentifier contentType_;
    protected AlgorithmIdentifier cAlg_;
    protected ASN1TaggedType econtent_;
    protected String bea_;
    private SecretKey bek_;
    private AlgorithmParameters params_;

    public EncryptedContentInfo() {
        super(3);
        this.contentType_ = new ASN1ObjectIdentifier();
        this.cAlg_ = new AlgorithmIdentifier();
        this.econtent_ = new ASN1TaggedType(0, new ASN1OctetString(), false, true);
        this.add(this.contentType_);
        this.add(this.cAlg_);
        this.add(this.econtent_);
    }

    public EncryptedContentInfo(String bea, SecretKey bek, AlgorithmParameters params) throws InvalidAlgorithmParameterException {
        if (bea == null || bek == null) {
            throw new NullPointerException("BEK or BEA is null!");
        }
        this.contentType_ = new ASN1ObjectIdentifier(DATA_OID);
        this.cAlg_ = new AlgorithmIdentifier(bea, params);
        this.econtent_ = new ASN1TaggedType(0, new ASN1OctetString(), false, true);
        this.add(this.contentType_);
        this.add(this.cAlg_);
        this.add(this.econtent_);
        this.bea_ = bea;
        this.bek_ = bek;
        this.params_ = params;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentType_;
    }

    public byte[] getEncryptedContent() {
        if (this.econtent_.isOptional()) {
            return null;
        }
        ASN1OctetString v = (ASN1OctetString)this.econtent_.getInnerType();
        return v.getByteArray();
    }

    public String getAlgorithm() {
        if (this.bea_ == null) {
            throw new IllegalStateException("Not initialized or algorithm unresolvable!");
        }
        return this.bea_;
    }

    public AlgorithmParameters getParameters() {
        if (this.params_ == null) {
            throw new IllegalStateException("Not initialized or parameters unresolvable!");
        }
        return this.params_;
    }

    public SecretKey getSecretKey() {
        if (this.bek_ == null) {
            throw new IllegalStateException("Not initialized!");
        }
        return this.bek_;
    }

    public void init(PrivateKey kdk, RecipientInfo info) throws GeneralSecurityException {
        this.init();
        this.bek_ = info.getSecretKey(kdk, this.bea_);
    }

    public void init(SecretKey key) throws GeneralSecurityException {
        if (key == null) {
            throw new NullPointerException("Need a SecretKey!");
        }
        this.init();
        this.bek_ = key;
    }

    protected void init() throws GeneralSecurityException {
        if (this.params_ == null) {
            this.params_ = this.cAlg_.getParameters();
        }
        if (this.bea_ == null) {
            this.bea_ = this.cAlg_.getAlgorithmName();
        }
        if (this.bea_ == null) {
            throw new NoSuchAlgorithmException("Cannot resolve OID " + this.cAlg_.getAlgorithmOID());
        }
    }

    public boolean isReady() {
        return this.bek_ != null;
    }

    public RecipientInfo newRecipient(X509Certificate cert) throws GeneralSecurityException, BadNameException {
        if (this.bek_ == null) {
            throw new IllegalStateException("Not initialized!");
        }
        return new RecipientInfo(cert, this.bek_);
    }

    public RecipientInfo newRecipient(X509Certificate cert, int encType) throws GeneralSecurityException, BadNameException {
        if (this.bek_ == null) {
            throw new IllegalStateException("Not initialized!");
        }
        return new RecipientInfo(cert, this.bek_, encType);
    }

    public void setData(InputStream in) throws IOException, GeneralSecurityException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.crypt(in, (OutputStream)out, 1);
        byte[] b = out.toByteArray();
        out.close();
        this.contentType_ = new ASN1ObjectIdentifier(DATA_OID);
        this.econtent_ = new ASN1TaggedType(0, new ASN1OctetString(b), false, false);
        this.clear();
        this.add(this.contentType_);
        this.add(this.cAlg_);
        this.add(this.econtent_);
        this.trimToSize();
    }

    public byte[] getData() throws GeneralSecurityException, NoSuchElementException {
        if (!Arrays.equals(this.contentType_.getOID(), DATA_OID)) {
            throw new NoSuchElementException("Content type is not Data!");
        }
        byte[] b = this.getEncryptedContent();
        if (b == null || b.length == 0) {
            return null;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.crypt(b, (OutputStream)out, 2);
            b = out.toByteArray();
            out.close();
            return b;
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private Cipher createCipher(int opmode) throws GeneralSecurityException {
        if (this.bek_ == null) {
            throw new IllegalStateException("No secret key");
        }
        if (this.bea_ == null) {
            throw new IllegalStateException("No cipher algorithm!");
        }
        Cipher cipher = Cipher.getInstance(this.bea_);
        if (this.params_ == null) {
            cipher.init(opmode, this.bek_);
        } else {
            cipher.init(opmode, (Key)this.bek_, this.params_);
        }
        return cipher;
    }

    /*
     * WARNING - void declaration
     */
    public void crypt(InputStream in, OutputStream out, int opmode) throws IOException, GeneralSecurityException {
        int n;
        Cipher cipher = this.createCipher(opmode);
        byte[] b = new byte[4096];
        while ((n = in.read(b)) > 0) {
            void var6_6;
            out.write(cipher.update(b, 0, (int)var6_6));
        }
        out.write(cipher.doFinal());
        out.flush();
        in.close();
    }

    public void crypt(byte[] in, OutputStream out, int opmode) throws IOException, GeneralSecurityException {
        Cipher cipher = this.createCipher(opmode);
        out.write(cipher.doFinal(in));
        out.flush();
    }

    public byte[] crypt(byte[] in, int offset, int length, int opmode) throws GeneralSecurityException {
        Cipher cipher = this.createCipher(opmode);
        return cipher.doFinal(in, offset, length);
    }

    public void decode(Decoder dec) throws IOException, ASN1Exception {
        super.decode(dec);
        try {
            this.init();
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
    }

    public void setEncryptedContent(ASN1ObjectIdentifier oid, InputStream in) throws IOException, GeneralSecurityException {
        if (oid == null || in == null) {
            throw new NullPointerException("oid or input stream");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.crypt(in, (OutputStream)out, 1);
        byte[] b = out.toByteArray();
        out.close();
        this.contentType_ = oid;
        this.econtent_ = new ASN1TaggedType(0, new ASN1OctetString(b), false, false);
        this.clear();
        this.add(this.contentType_);
        this.add(this.cAlg_);
        this.add(this.econtent_);
        this.trimToSize();
    }

    public void setContentType(ASN1ObjectIdentifier oid) {
        if (oid == null) {
            throw new NullPointerException("oid");
        }
        this.contentType_ = oid;
        this.set(0, this.contentType_);
    }
}

