/*
 * Decompiled with CFR 0.152.
 */
package codec.pkcs7;

import codec.asn1.ASN1Integer;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1RegisteredType;
import codec.asn1.ASN1Sequence;
import codec.pkcs7.EncryptedContentInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.util.NoSuchElementException;
import javax.crypto.SecretKey;

public class EncryptedData
extends ASN1Sequence
implements ASN1RegisteredType {
    private static final int[] OID_ = new int[]{1, 2, 840, 113549, 1, 7, 6};
    protected static ASN1Integer version_;
    protected EncryptedContentInfo info_;

    public EncryptedData() {
        super(2);
        version_ = new ASN1Integer(0);
        this.info_ = new EncryptedContentInfo();
        this.add(version_);
        this.add(this.info_);
    }

    public EncryptedData(String bea, SecretKey bek, AlgorithmParameters params) throws InvalidAlgorithmParameterException {
        super(2);
        if (bea == null || bek == null) {
            throw new NullPointerException("BEA or BEK is null!");
        }
        version_ = new ASN1Integer(0);
        this.info_ = new EncryptedContentInfo(bea, bek, params);
        this.add(version_);
        this.add(this.info_);
    }

    public void init(SecretKey key) throws GeneralSecurityException {
        this.info_.init(key);
    }

    public ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier(OID_);
    }

    public byte[] getEncryptedContent() {
        return this.info_.getEncryptedContent();
    }

    public String getAlgorithm() {
        return this.info_.getAlgorithm();
    }

    public SecretKey getSecretKey() {
        return this.info_.getSecretKey();
    }

    public EncryptedContentInfo getContentInfo() {
        return this.info_;
    }

    public boolean isReady() {
        return this.info_.isReady();
    }

    public void setData(InputStream in) throws IOException, GeneralSecurityException {
        this.info_.setData(in);
    }

    public byte[] getData() throws GeneralSecurityException, NoSuchElementException {
        return this.info_.getData();
    }

    public void decryptBulkData(InputStream in, OutputStream out) throws IOException, GeneralSecurityException {
        this.info_.crypt(in, out, 2);
    }

    public void encryptBulkData(InputStream in, OutputStream out) throws IOException, GeneralSecurityException {
        this.info_.crypt(in, out, 1);
    }
}

