/*
 * Decompiled with CFR 0.152.
 */
package codec.pkcs7;

import codec.asn1.ASN1Integer;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1RegisteredType;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Set;
import codec.asn1.ASN1SetOf;
import codec.asn1.ASN1TaggedType;
import codec.asn1.ASN1Type;
import codec.pkcs7.Certificates;
import codec.pkcs7.ContentInfo;
import codec.pkcs7.Data;
import codec.pkcs7.Signable;
import codec.pkcs7.SignerInfo;
import codec.util.CertificateSource;
import codec.x509.AlgorithmIdentifier;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class SignedData
extends ASN1Sequence
implements ASN1RegisteredType,
CertificateSource,
Signable {
    private static final int[] THIS_OID = new int[]{1, 2, 840, 113549, 1, 7, 2};
    private static final int[] DATA_OID = new int[]{1, 2, 840, 113549, 1, 7, 1};
    protected ASN1Set digestID_;
    protected Certificates certs_;
    protected ASN1SetOf infos_;
    protected ASN1Set crls_;
    protected ContentInfo content_;
    protected ASN1Set cache_;
    protected CertificateFactory factory_;
    static /* synthetic */ Class class$codec$x509$AlgorithmIdentifier;
    static /* synthetic */ Class class$codec$asn1$ASN1Opaque;
    static /* synthetic */ Class class$codec$pkcs7$SignerInfo;

    public SignedData() {
        super(6);
        this.add(new ASN1Integer(1));
        this.digestID_ = new ASN1SetOf(class$codec$x509$AlgorithmIdentifier == null ? (class$codec$x509$AlgorithmIdentifier = SignedData.class$("codec.x509.AlgorithmIdentifier")) : class$codec$x509$AlgorithmIdentifier);
        this.add(this.digestID_);
        this.content_ = new ContentInfo();
        this.add(this.content_);
        this.certs_ = new Certificates();
        this.add(new ASN1TaggedType(0, this.certs_, false, true));
        this.crls_ = new ASN1SetOf(class$codec$asn1$ASN1Opaque == null ? (class$codec$asn1$ASN1Opaque = SignedData.class$("codec.asn1.ASN1Opaque")) : class$codec$asn1$ASN1Opaque);
        this.add(new ASN1TaggedType(1, this.crls_, false, true));
        this.infos_ = new ASN1SetOf(class$codec$pkcs7$SignerInfo == null ? (class$codec$pkcs7$SignerInfo = SignedData.class$("codec.pkcs7.SignerInfo")) : class$codec$pkcs7$SignerInfo);
        this.add(this.infos_);
    }

    public SignedData(int _version) {
        super(6);
        this.add(new ASN1Integer(_version));
        this.digestID_ = new ASN1SetOf(class$codec$x509$AlgorithmIdentifier == null ? (class$codec$x509$AlgorithmIdentifier = SignedData.class$("codec.x509.AlgorithmIdentifier")) : class$codec$x509$AlgorithmIdentifier);
        this.add(this.digestID_);
        this.content_ = new ContentInfo();
        this.add(this.content_);
        this.certs_ = new Certificates();
        this.add(new ASN1TaggedType(0, this.certs_, false, true));
        this.crls_ = new ASN1SetOf(class$codec$asn1$ASN1Opaque == null ? (class$codec$asn1$ASN1Opaque = SignedData.class$("codec.asn1.ASN1Opaque")) : class$codec$asn1$ASN1Opaque);
        this.add(new ASN1TaggedType(1, this.crls_, false, true));
        this.infos_ = new ASN1SetOf(class$codec$pkcs7$SignerInfo == null ? (class$codec$pkcs7$SignerInfo = SignedData.class$("codec.pkcs7.SignerInfo")) : class$codec$pkcs7$SignerInfo);
        this.add(this.infos_);
    }

    public ASN1Type getContent() {
        return this.content_.getContent();
    }

    public void setDataContentType() {
        this.setContentType(new ASN1ObjectIdentifier(DATA_OID));
    }

    public void setContentType(ASN1ObjectIdentifier oid) {
        if (oid == null) {
            throw new NullPointerException("OID");
        }
        this.content_.setContent(oid);
    }

    public void setContent(ASN1RegisteredType t) {
        if (t == null) {
            throw new NullPointerException("Need content!");
        }
        this.content_.setContent(t);
    }

    public void setContent(ASN1ObjectIdentifier oid, ASN1Type t) {
        if (oid == null || t == null) {
            throw new NullPointerException("Need an OID and content!");
        }
        this.content_.setContent(oid, t);
    }

    public ASN1ObjectIdentifier getContentType() {
        return (ASN1ObjectIdentifier)this.content_.getContentType().clone();
    }

    public void setData(byte[] b) {
        this.content_.setContent(new Data(b));
    }

    public Data getData() throws NoSuchElementException {
        ASN1Type o = this.content_.getContent();
        if (o == null) {
            return null;
        }
        if (o instanceof Data) {
            return (Data)o;
        }
        throw new NoSuchElementException("Content type is not Data!");
    }

    public boolean hasData() {
        ASN1Type o = this.content_.getContent();
        if (o == null) {
            return false;
        }
        if (!(o instanceof Data)) {
            return false;
        }
        byte[] b = ((Data)o).getByteArray();
        return b != null && b.length != 0;
    }

    public ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier(THIS_OID);
    }

    public void setCertificateFactory(CertificateFactory factory) {
        this.certs_.setCertificateFactory(factory);
    }

    public List getCertificates() {
        return Collections.unmodifiableList(this.certs_);
    }

    public void addCertificate(X509Certificate cert) {
        if (this.certs_.addCertificate(cert)) {
            ((ASN1Type)this.get(3)).setOptional(false);
        }
    }

    public X509Certificate getCertificate(Principal issuer, BigInteger serial) {
        return this.certs_.getCertificate(issuer, serial);
    }

    public Iterator certificates(Principal subject) {
        return this.certs_.certificates(subject);
    }

    public Iterator certificates(Principal subject, int keyUsage) {
        return this.certs_.certificates(subject, keyUsage);
    }

    public List getSignerInfos() {
        return Collections.unmodifiableList(this.infos_);
    }

    public SignerInfo getSignerInfo(X509Certificate cert) {
        Iterator i = this.getSignerInfos().iterator();
        while (i.hasNext()) {
            SignerInfo info = (SignerInfo)i.next();
            if (!info.getIssuerDN().equals(cert.getIssuerDN()) || !info.getSerialNumber().equals(cert.getSerialNumber())) continue;
            return info;
        }
        return null;
    }

    public String toString() {
        return "-- PKCS#7 SignedData --\n" + super.toString();
    }

    public void addSignerInfo(SignerInfo info) {
        if (info == null) {
            throw new NullPointerException("Need a SignerInfo!");
        }
        this.infos_.add(info);
        AlgorithmIdentifier idn = info.getDigestAlgorithmIdentifier();
        Iterator i = ((AbstractList)this.digestID_).iterator();
        while (i.hasNext()) {
            AlgorithmIdentifier idv = (AlgorithmIdentifier)i.next();
            if (!idn.equals(idv)) continue;
            return;
        }
        this.digestID_.add(idn);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

