/*
 * Decompiled with CFR 0.152.
 */
package codec.pkcs7;

import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Type;
import codec.asn1.DEREncoder;
import codec.pkcs7.Data;
import codec.pkcs7.NoSuchSignerException;
import codec.pkcs7.Signable;
import codec.pkcs7.SignedAndEnvelopedData;
import codec.pkcs7.SignerInfo;
import codec.pkcs9.Attributes;
import codec.pkcs9.InvalidAttributeException;
import codec.pkcs9.NoSuchAttributeException;
import codec.util.JCA;
import codec.x501.Attribute;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;

public class Verifier {
    private ASN1ObjectIdentifier DATA = new ASN1ObjectIdentifier(new int[]{1, 2, 840, 113549, 1, 7, 1});
    private ASN1ObjectIdentifier MESSAGE_DIGEST = new ASN1ObjectIdentifier(new int[]{1, 2, 840, 113549, 1, 9, 4});
    private ASN1ObjectIdentifier CONTENT_TYPE = new ASN1ObjectIdentifier(new int[]{1, 2, 840, 113549, 1, 9, 3});
    public static final int BUFFER_SIZE = 1024;
    protected Signable target_;
    private Signature sig_;
    protected MessageDigest digest_;
    protected X509Certificate cert_;
    protected SignerInfo info_;
    protected byte[] md_;
    protected boolean twostep_ = false;
    private boolean strict = false;

    public Verifier(Signable sigdat, SignerInfo info, X509Certificate cert) throws GeneralSecurityException {
        if (info == null && cert == null) {
            throw new IllegalArgumentException("Need either a SignerInfo or a certificate!");
        }
        if (sigdat == null) {
            throw new NullPointerException("Need a SignedData!");
        }
        this.target_ = sigdat;
        if (info == null) {
            info = this.target_.getSignerInfo(cert);
            if (info == null) {
                throw new NoSuchSignerException("No signer info found for: " + cert.getIssuerDN().getName() + ", " + cert.getSerialNumber());
            }
        } else if (cert == null) {
            cert = this.target_.getCertificate(info.getIssuerDN(), info.getSerialNumber());
            if (cert == null) {
                throw new CertificateException("No certificate available for: " + info.getIssuerDN().getName() + ", " + info.getSerialNumber());
            }
        } else if (!info.equivIssuerAndSerialNumber(cert)) {
            throw new IllegalArgumentException("SignerInfo and certificate don't match!");
        }
        this.info_ = info;
        this.cert_ = cert;
        String sigalg = this.info_.getAlgorithm();
        Attributes attributes = this.info_.authenticatedAttributes();
        ASN1ObjectIdentifier oid = this.target_.getContentType();
        if (attributes.size() > 0 || !oid.equals(this.DATA)) {
            this.twostep_ = true;
            Attribute attribute = this.info_.authenticatedAttributes().getAttribute(this.CONTENT_TYPE);
            if (attribute == null) {
                throw new NoSuchAttributeException("ContentType attribute missing!");
            }
            if (attribute.valueCount() == 0) {
                throw new InvalidAttributeException("ContentType attribute has no OID!");
            }
            if (!oid.equals(attribute.valueAt(0))) {
                throw new InvalidAttributeException("ContentType attribute mismatch!");
            }
            attribute = this.info_.authenticatedAttributes().getAttribute(this.MESSAGE_DIGEST);
            if (attribute == null) {
                throw new NoSuchAttributeException("MessageDigest attribute missing!");
            }
            if (attribute.valueCount() == 0) {
                throw new InvalidAttributeException("MessageDigest attribute has no data!");
            }
            ASN1OctetString octets = (ASN1OctetString)attribute.valueAt(0);
            this.md_ = octets.getByteArray();
            String mdalg = JCA.getName(JCA.getDigestOID(sigalg));
            if (mdalg == null) {
                throw new NoSuchAlgorithmException("Cannot determine digest algorithm for " + sigalg);
            }
            this.digest_ = MessageDigest.getInstance(mdalg);
        }
        this.sig_ = Signature.getInstance(sigalg);
        AlgorithmParameterSpec spec = this.info_.getParameterSpec();
        if (spec != null) {
            this.sig_.setParameter(spec);
        }
        this.sig_.initVerify(this.cert_.getPublicKey());
    }

    public void setStrict(boolean strictness) {
        this.strict = strictness;
    }

    /*
     * WARNING - void declaration
     */
    public void update(InputStream in) throws SignatureException, IOException {
        byte[] buf = new byte[1024];
        try {
            int n;
            while ((n = in.read(buf)) > 0) {
                void var3_3;
                this.update(buf, 0, (int)var3_3);
            }
        }
        catch (IOException e) {
            this.reset();
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update() throws GeneralSecurityException {
        ASN1Type t = this.target_.getContent();
        if (t == null) {
            return;
        }
        if (t instanceof Data) {
            this.update(((Data)t).getByteArray());
            return;
        }
        boolean tagging = t.isExplicit();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DEREncoder enc = new DEREncoder(bos);
        if (this.strict) {
            enc.setStrict(true);
        }
        try {
            try {
                t.setExplicit(false);
                enc.writeType(t);
                this.update(bos.toByteArray());
            }
            catch (Exception e) {
                throw new SignatureException("Exception while re-encoding!");
            }
            Object var7_5 = null;
            t.setExplicit(tagging);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            t.setExplicit(tagging);
            try {
                enc.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        enc.close();
        return;
    }

    public void update(byte[] b) throws SignatureException {
        this.update(b, 0, b.length);
    }

    public void update(byte[] b, int offset, int len) throws SignatureException {
        try {
            if (this.twostep_) {
                this.digest_.update(b, offset, len);
            } else {
                this.sig_.update(b, offset, len);
            }
        }
        catch (SignatureException e) {
            this.reset();
            throw e;
        }
    }

    private void reset() {
        this.sig_ = null;
        this.cert_ = null;
        this.info_ = null;
        this.digest_ = null;
        this.target_ = null;
    }

    public X509Certificate verify() throws GeneralSecurityException {
        byte[] b;
        if (this.twostep_) {
            b = this.digest_.digest();
            if (!Arrays.equals(b, this.md_)) {
                return null;
            }
            this.info_.update(this.sig_);
        }
        if (this.target_ instanceof SignedAndEnvelopedData) {
            SignedAndEnvelopedData saed = (SignedAndEnvelopedData)this.target_;
            byte[] edig = this.info_.getEncryptedDigest();
            b = saed.decryptBulkData(edig);
        } else {
            b = this.info_.getEncryptedDigest();
        }
        if (this.sig_.verify(b)) {
            return this.cert_;
        }
        return null;
    }
}

