/*
 * Decompiled with CFR 0.152.
 */
package codec.pkcs8;

import codec.CorruptedCodeException;
import codec.InconsistentStateException;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Set;
import codec.asn1.ASN1SetOf;
import codec.asn1.ASN1TaggedType;
import codec.asn1.ASN1Type;
import codec.asn1.DERDecoder;
import codec.asn1.DEREncoder;
import codec.x509.AlgorithmIdentifier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PrivateKeyInfo
extends ASN1Sequence {
    public static final int VERSION = 0;
    public static final int VERSION_1_2 = 0;
    protected ASN1Integer version_;
    protected AlgorithmIdentifier algorithm_;
    private transient ASN1OctetString encodedKey_;
    protected ASN1Set attributes_;
    static /* synthetic */ Class class$codec$x501$Attribute;

    public PrivateKeyInfo() {
        this.version_ = new ASN1Integer(0);
        this.add(this.version_);
        this.algorithm_ = new AlgorithmIdentifier();
        this.add(this.algorithm_);
        this.encodedKey_ = new ASN1OctetString();
        this.add(this.encodedKey_);
        this.attributes_ = new ASN1SetOf(class$codec$x501$Attribute == null ? (class$codec$x501$Attribute = PrivateKeyInfo.class$("codec.x501.Attribute")) : class$codec$x501$Attribute);
        this.add(new ASN1TaggedType(0, this.attributes_, false, true));
    }

    public PrivateKeyInfo(AlgorithmIdentifier aid, byte[] key) {
        this.version_ = new ASN1Integer(0);
        this.add(this.version_);
        this.algorithm_ = aid;
        this.add(this.algorithm_);
        this.encodedKey_ = new ASN1OctetString(key);
        this.add(this.encodedKey_);
        this.attributes_ = new ASN1Set();
        this.add(new ASN1TaggedType(0, this.attributes_, false, true));
    }

    public PrivateKeyInfo(AlgorithmIdentifier aid, ASN1Type key) {
        byte[] code;
        this.version_ = new ASN1Integer(0);
        this.add(this.version_);
        this.algorithm_ = aid;
        this.add(this.algorithm_);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DEREncoder enc = new DEREncoder(bos);
            key.encode(enc);
            code = bos.toByteArray();
            enc.close();
        }
        catch (IOException e) {
            throw new InconsistentStateException("Caught IOException!");
        }
        catch (ASN1Exception e) {
            throw new InconsistentStateException("Caught ASN1Exception!");
        }
        this.encodedKey_ = new ASN1OctetString(code);
        this.add(this.encodedKey_);
        this.attributes_ = new ASN1Set();
        this.add(new ASN1TaggedType(0, this.attributes_, false, true));
    }

    public PrivateKeyInfo(PrivateKey key) throws InvalidKeyException {
        super(2);
        this.setPrivateKey(key);
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithm_;
    }

    public PrivateKey getPrivateKey() throws NoSuchAlgorithmException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DEREncoder enc = new DEREncoder(bos);
            this.encode(enc);
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(bos.toByteArray());
            enc.close();
            String alg = this.algorithm_.getAlgorithmOID().toString();
            KeyFactory kf = KeyFactory.getInstance(alg);
            return kf.generatePrivate(spec);
        }
        catch (ASN1Exception e) {
            throw new InconsistentStateException("Internal, encoding error!");
        }
        catch (IOException e) {
            throw new InconsistentStateException("Internal, I/O exception caught!");
        }
        catch (InvalidKeySpecException e) {
            throw new InconsistentStateException("Encoded key spec rejected by key factory!");
        }
    }

    public void setPrivateKey(PrivateKey key) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("Key is null!");
        }
        this.clear();
        this.version_ = new ASN1Integer(0);
        this.add(this.version_);
        this.algorithm_ = new AlgorithmIdentifier();
        this.add(this.algorithm_);
        this.encodedKey_ = new ASN1OctetString();
        this.add(this.encodedKey_);
        this.attributes_ = new ASN1SetOf(class$codec$x501$Attribute == null ? (class$codec$x501$Attribute = PrivateKeyInfo.class$("codec.x501.Attribute")) : class$codec$x501$Attribute);
        this.add(new ASN1TaggedType(0, this.attributes_, false, true));
        try {
            DERDecoder dec = new DERDecoder(new ByteArrayInputStream(key.getEncoded()));
            this.decode(dec);
            dec.close();
        }
        catch (IOException e) {
            throw new InvalidKeyException("Caught IOException!");
        }
        catch (ASN1Exception e) {
            throw new InvalidKeyException("Bad encoding!");
        }
    }

    public int getVersion() {
        return this.version_.getBigInteger().intValue();
    }

    public void setVersion(int version) {
        this.version_ = new ASN1Integer(version);
        this.set(0, this.version_);
    }

    public void setAlgorithm(AlgorithmIdentifier aid) {
        if (aid == null) {
            throw new NullPointerException("Algorithm identifier is null!");
        }
        this.set(1, aid);
        this.algorithm_ = aid;
    }

    protected void setRawKey(ASN1Type key) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DEREncoder enc = new DEREncoder(bos);
            key.encode(enc);
            this.encodedKey_ = new ASN1OctetString(bos.toByteArray());
            enc.close();
            this.set(2, this.encodedKey_);
        }
        catch (ASN1Exception e) {
            throw new InconsistentStateException("Internal, encoding error!");
        }
        catch (IOException e) {
            throw new InconsistentStateException("Internal, I/O exception caught!");
        }
    }

    public List getAttributes() {
        if (this.attributes_.isOptional()) {
            return null;
        }
        return Collections.unmodifiableList(this.attributes_);
    }

    public void setAttributes(Collection attributes) {
        if (attributes == null) {
            throw new NullPointerException("Attributes instance is null!");
        }
        this.attributes_.clear();
        this.attributes_.addAll(attributes);
        this.attributes_.setOptional(false);
    }

    public byte[] getRawKey() {
        return (byte[])this.encodedKey_.getByteArray().clone();
    }

    public ASN1Type getDecodedRawKey() throws CorruptedCodeException {
        try {
            DERDecoder dec = new DERDecoder(new ByteArrayInputStream(this.encodedKey_.getByteArray()));
            ASN1Type raw = dec.readType();
            dec.close();
            return raw;
        }
        catch (ASN1Exception e) {
            throw new CorruptedCodeException("Cannot decode raw key!");
        }
        catch (IOException e) {
            throw new InconsistentStateException("Internal, I/O exception caught!");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

