/*
 * Decompiled with CFR 0.152.
 */
package codec.util;

import java.security.Provider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Engines {
    protected static String[] cipher_ = new String[]{"DES", "DESede", "Blowfish", "RC2", "RC5", "PBEWithMD5AndDES", "RSA"};
    protected static String[] keyGenerator_ = new String[]{"DES", "DESede", "Blowfish", "RC2", "RC5"};
    protected static String[] keyPairGenerator_ = new String[]{"RSA", "DSA", "DiffieHellman"};
    protected static String[] keyAgreement_ = new String[]{"DiffieHellman"};
    protected static String[] secretKeyFactory_ = new String[]{"DES", "DESede", "Blowfish", "RC2", "RC5", "PBE"};
    protected static String[] keyFactory_ = new String[]{"DiffieHellman", "RSA", "DSA"};
    protected static String[] algorithmParameters_ = new String[]{"DES", "DESede", "Blowfish", "RC2", "RC5", "PBE", "DiffieHellman", "RSA", "DSA"};
    protected static String[] algorithmParameterGenerator_ = new String[]{"DES", "DESede", "Blowfish", "RC2", "RC5", "PBE", "DiffieHellman", "RSA", "DSA"};
    protected static String[] mac_ = new String[]{"HmacMD5", "HmacSHA1"};
    protected static String[] keyStore_ = new String[]{"JCEKS", "JKS", "PKCS12"};
    protected static String[] messageDigest_ = new String[]{"SHA", "MD2", "MD5"};
    protected static String[] signature_ = new String[]{"SHA1withDSA", "MD2withRSA", "MD5withRSA", "SHA1withRSA"};
    protected static String[] secureRandom_ = new String[]{"SHA1PRNG"};
    protected static String[] certificateFactory_ = new String[]{"X509"};
    protected static String[] mode_ = new String[]{"ECB", "CBC", "CFB", "OFB", "PCBC"};
    protected static String[] padding_ = new String[]{"NoPadding", "PKCS5Padding", "SSL3Padding"};
    protected static String[] engines_ = new String[]{"AlgorithmParameterGenerator", "AlgorithmParameters", "MessageDigest", "KeyFactory", "KeyPairGenerator", "Signature", "SecureRandom", "CertificateFactory", "Cipher", "KeyGenerator", "SecretKeyFactory", "Mac", "KeyStore", "KeyAgreement"};
    protected static Map map_;

    private Engines() {
    }

    protected static Map initEngines() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("messagedigest", messageDigest_);
        map.put("keyfactory", keyFactory_);
        map.put("keypairgenerator", keyPairGenerator_);
        map.put("algorithmparametergenerator", algorithmParameterGenerator_);
        map.put("algorithmparameters", algorithmParameters_);
        map.put("signature", signature_);
        map.put("securerandom", secureRandom_);
        map.put("certificatefactory", certificateFactory_);
        map.put("cipher", cipher_);
        map.put("keygenerator", keyGenerator_);
        map.put("secretkeyfactory", secretKeyFactory_);
        map.put("keyagreement", keyAgreement_);
        map.put("mac", mac_);
        map.put("keystore", keyStore_);
        return map;
    }

    public static List getStdNames(String engine) {
        if (map_ == null) {
            map_ = Engines.initEngines();
        }
        if (engine == null) {
            throw new NullPointerException("Engine is NULL!");
        }
        String[] names = (String[])map_.get(engine.toLowerCase());
        if (names == null) {
            throw new IllegalStateException("Illegal engine name (" + engine + ")");
        }
        ArrayList<String> list = new ArrayList<String>(names.length);
        int i = 0;
        while (i < names.length) {
            list.add(names[i]);
            ++i;
        }
        return list;
    }

    public static List getEngineNames() {
        ArrayList<String> list = new ArrayList<String>(engines_.length);
        int i = 0;
        while (i < engines_.length) {
            list.add(engines_[i]);
            ++i;
        }
        return list;
    }

    public static List getEngineNames(Provider p, String engine) {
        if (p == null || engine == null || engine.length() == 0) {
            throw new NullPointerException("Need a provider and engine name!");
        }
        ArrayList<String> list = new ArrayList<String>();
        engine = engine.toLowerCase() + ".";
        Iterator<Object> i = p.keySet().iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            String u = s.toLowerCase();
            if (!u.startsWith(engine) || (u = s.substring(engine.length())).length() <= 0) continue;
            list.add(u);
        }
        list.trimToSize();
        return list;
    }
}

