/*
 * Decompiled with CFR 0.152.
 */
package codec.util;

import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class JCA {
    private static Map dc2s_ = new HashMap();
    private static Map s2dc_ = new HashMap();
    protected static Map aliases_ = JCA.initAliasLookup();

    private JCA() {
    }

    private static Map initAliasLookup() {
        HashMap<String, String> map = new HashMap<String, String>();
        Provider[] provider = Security.getProviders();
        int i = provider.length - 1;
        while (i >= 0) {
            Enumeration<?> e = provider[i].propertyNames();
            while (e.hasMoreElements()) {
                int j;
                String k = (String)e.nextElement();
                String v = ((Properties)provider[i]).getProperty(k);
                if (!k.startsWith("Alg.Alias.") || (j = (k = k.substring(10).toLowerCase()).indexOf(46)) < 1) continue;
                String s = k.substring(0, j);
                if ((k = k.substring(j + 1)).length() < 1) continue;
                if (Character.isDigit(k.charAt(0))) {
                    String p = (String)map.get("oid." + k);
                    if (p != null && p.length() >= v.length()) continue;
                    map.put("oid." + k, v);
                    map.put(s + "." + k, v);
                    continue;
                }
                if (k.startsWith("oid.")) {
                    k = k.substring(4);
                    v = v.toLowerCase();
                    map.put("oid." + v, k);
                    continue;
                }
                map.put(s + "." + k, v);
            }
            --i;
        }
        return map;
    }

    public static String getName(String oid) {
        if (oid == null) {
            throw new NullPointerException("OID is null!");
        }
        if (oid.startsWith("OID.") || oid.startsWith("oid.")) {
            oid = oid.substring(4);
        }
        return (String)aliases_.get("oid." + oid);
    }

    public static String resolveAlias(String engine, String alias) {
        if (alias == null || engine == null) {
            throw new NullPointerException("Engine or alias is null!");
        }
        if (alias.length() < 1) {
            throw new IllegalArgumentException("Zero-length alias!");
        }
        return (String)aliases_.get(engine.toLowerCase() + "." + alias.toLowerCase());
    }

    public static String getOID(String algorithm) {
        if (algorithm == null) {
            throw new NullPointerException("Algorithm is null!");
        }
        if (algorithm.length() < 1) {
            throw new IllegalArgumentException("Algorithm name is empty!");
        }
        if (Character.isDigit(algorithm.charAt(0))) {
            return algorithm;
        }
        return (String)aliases_.get("oid." + algorithm.toLowerCase());
    }

    public static String getOID(String algorithm, String engine) {
        String oid = JCA.getOID(algorithm);
        if (oid != null) {
            return oid;
        }
        if ((algorithm = JCA.resolveAlias(engine, algorithm)) == null) {
            return null;
        }
        return JCA.getOID(algorithm);
    }

    public static String getSignatureName(String doid, String coid) {
        String sn;
        String dn = JCA.getName(doid);
        String cn = JCA.getName(coid);
        if (dn == null || cn == null) {
            return null;
        }
        String dc = dn + "/" + cn;
        Map map = dc2s_;
        synchronized (map) {
            sn = (String)dc2s_.get(dc);
            if (sn != null) {
                String string = sn;
                return string;
            }
        }
        sn = JCA.resolveAlias("signature", dc);
        if (sn != null) {
            Map map2 = dc2s_;
            synchronized (map2) {
                cn = dc.toLowerCase();
                if (!dc2s_.containsKey(cn)) {
                    dc2s_.put(cn, sn);
                }
            }
            Map map3 = s2dc_;
            synchronized (map3) {
                cn = sn.toLowerCase();
                if (!s2dc_.containsKey(cn)) {
                    s2dc_.put(cn, dc);
                }
            }
        }
        return sn;
    }

    public static String getSlashedForm(String sigAlg) {
        String v;
        if (sigAlg.indexOf("/") > 0) {
            return sigAlg;
        }
        sigAlg = sigAlg.toLowerCase();
        Map map = s2dc_;
        synchronized (map) {
            v = (String)s2dc_.get(sigAlg);
            if (v != null) {
                String string = v;
                return string;
            }
        }
        Iterator i = aliases_.keySet().iterator();
        while (i.hasNext()) {
            int m;
            String k = (String)i.next();
            if (!k.startsWith("signature.") || !(v = (String)aliases_.get(k)).equalsIgnoreCase(sigAlg) || (m = (k = k.substring(10)).indexOf("/")) < 0) continue;
            Map map2 = s2dc_;
            synchronized (map2) {
                if (!s2dc_.containsKey(sigAlg)) {
                    s2dc_.put(sigAlg, k);
                }
            }
            return k;
        }
        return null;
    }

    public static String getDigestOID(String sigAlg) {
        String v = JCA.getSlashedForm(sigAlg);
        if (v == null) {
            return null;
        }
        int n = v.indexOf("/");
        if (n < 0) {
            return null;
        }
        String h = v.substring(0, n);
        String r = JCA.getOID(h);
        if (r != null) {
            return r;
        }
        if ((h = JCA.resolveAlias("MessageDigest", h)) == null) {
            return null;
        }
        r = JCA.getOID(h);
        if (r != null) {
            v = h + "/" + v.substring(n + 1);
            Map map = s2dc_;
            synchronized (map) {
                s2dc_.put(sigAlg, v);
            }
        }
        return r;
    }

    public static String getCipherOID(String sigAlg) {
        String v = JCA.getSlashedForm(sigAlg);
        if (v == null) {
            return null;
        }
        int n = v.indexOf("/");
        if (n < 0) {
            return null;
        }
        String s = v.substring(n + 1);
        String r = JCA.getOID(s);
        if (r != null) {
            return r;
        }
        if ((s = JCA.resolveAlias("Signature", s)) == null) {
            return null;
        }
        r = JCA.getOID(s);
        if (r != null) {
            v = v.substring(0, n) + "/" + s;
            Map map = s2dc_;
            synchronized (map) {
                s2dc_.put(sigAlg, v);
            }
        }
        return r;
    }
}

