/*
 * Decompiled with CFR 0.152.
 */
package codec.x501;

import codec.Hex;
import codec.UTF8InputStreamReader;
import codec.x501.AVA;
import codec.x501.BadNameException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class RFC2253Parser {
    public static final String TOKENIZERS = " ,+=\"#;\\<>\r\n";
    public static final String SPECIALS = "\"\\,=+<>#;";
    public static final String SEPARATORS = ";,+";
    public static final String HEXCHAR = "0123456789ABCDEFabcdef";
    public static final String ESCAPE = "\\";
    public static final String QUOTE = "\"";
    public static final String PLUS = "+";
    public static final String SPC = " ";
    public static final String LINEBREAK = "\r";
    public static final String RETURN = "\n";
    public static final String WHITESPACE = " \r\n";

    /*
     * Unable to fully structure code
     */
    public List parse(String rfc2253name) throws BadNameException {
        trunc = -1;
        returnState = -1;
        state = 0;
        tokParsed = true;
        utfParsed = true;
        key = new String();
        value = new StringBuffer();
        tok = "";
        baos = new ByteArrayOutputStream();
        ava_ = new LinkedList<AVA>();
        if (rfc2253name.equals("")) {
            return ava_;
        }
        st = new StringTokenizer(rfc2253name, " ,+=\"#;\\<>\r\n", true);
        block26: while (st.hasMoreTokens() || !tokParsed) {
            if (tokParsed) {
                tok = st.nextToken();
            }
            switch (state) {
                case 0: {
                    if (" \r\n".indexOf(tok) >= 0) continue block26;
                    if ("\"\\,=+<>#;".indexOf(tok.charAt(0)) < 0) {
                        if ((tok = tok.trim()).length() >= 4 && tok.substring(0, 4).equalsIgnoreCase("OID.")) {
                            tok = tok.substring(4);
                        }
                        if (Character.isDigit(tok.charAt(0))) {
                            chs = tok.toCharArray();
                            i = 1;
                            while (i < chs.length) {
                                if (!Character.isDigit(chs[i]) && chs[i] != '.') {
                                    throw new BadNameException("(" + state + ") The key '" + tok + "' seems to be an OID, but it " + "contains the illegal character '" + chs[i] + "'!");
                                }
                                ++i;
                            }
                        } else {
                            chs = tok.toCharArray();
                            i = 1;
                            while (i < chs.length) {
                                if (!Character.isDigit(chs[i]) && !Character.isLetter(chs[i]) && chs[i] != '-') {
                                    throw new BadNameException("(" + state + ") The key '" + tok + "' contains the the illegal " + "character '" + chs[i] + "'!");
                                }
                                ++i;
                            }
                        }
                        key = tok;
                        state = 1;
                        break;
                    }
                    throw new BadNameException("(" + state + ") Key starts with SPECIAL '" + tok + "'!");
                }
                case 1: {
                    if (" \r\n".indexOf(tok) >= 0) continue block26;
                    if (tok.equals("=")) {
                        state = 2;
                        break;
                    }
                    throw new BadNameException("(" + state + ") '=' expected after '" + key + "'!");
                }
                case 2: {
                    if (" \r\n".indexOf(tok) >= 0) continue block26;
                    if (tok.equals("#")) {
                        state = 7;
                        break;
                    }
                    state = 3;
                }
                case 3: {
                    if (!tok.equals("\\") && !utfParsed) {
                        throw new BadNameException("(" + state + ") Invalid UTF-8 code '" + Hex.encode(baos.toByteArray()) + "'!");
                    }
                    if (!tokParsed) {
                        tokParsed = true;
                    }
                    if (" \r\n".indexOf(tok) >= 0) {
                        if (value.length() == 0) continue block26;
                        if (trunc == -1) {
                            trunc = value.length();
                        }
                        value.append(tok);
                        break;
                    }
                    if (";,+".indexOf(tok.charAt(0)) >= 0) {
                        if (trunc != -1) {
                            value.setLength(trunc);
                        }
                        val = value.toString();
                        state = 0;
                        plus = tok.equals("+");
                        value.setLength(0);
                        ava_.add(new AVA(key, val, plus));
                        break;
                    }
                    if (trunc != -1) {
                        trunc = -1;
                    }
                    if (tok.equals("\\")) {
                        returnState = state;
                        state = 4;
                        break;
                    }
                    if (tok.equals("\"")) {
                        if (value.length() > 0) {
                            throw new BadNameException("(" + state + ") Only whitespace characters " + "are allowed before the first unescaped " + "quotation mark (\")!");
                        }
                        state = 5;
                        break;
                    }
                    if ("\"\\,=+<>#;".indexOf(tok.charAt(0)) < 0) {
                        if (tok.length() <= 0) continue block26;
                        value.append(tok);
                        break;
                    }
                    throw new BadNameException("(" + state + ") Unquoted special character '" + tok + "' after '" + key + "'!");
                }
                case 4: {
                    if ("\"\\,=+<>#;".indexOf(tok.charAt(0)) >= 0) {
                        value.append(tok);
                        state = returnState;
                        break;
                    }
                    if (tok.length() <= 1) ** GOTO lbl144
                    t = tok.substring(0, 2);
                    try {
                        b = Hex.decode(t)[0];
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("(" + state + ") Invalid hex character '" + t + "'!");
                    }
                    if (b < 0 || b > 37) ** GOTO lbl119
                    try {
                        if (baos.size() != 0) ** GOTO lbl115
                        ascii = new byte[]{b};
                        str = new String(ascii);
                        value.append(str);
                        ** GOTO lbl137
lbl115:
                        // 1 sources

                        baos.write(b);
                        throw new BadNameException("(" + state + ") Invalid UTF-8 code '" + Hex.encode(baos.toByteArray()) + "'!");
                    }
                    catch (IllegalArgumentException iae) {
                        throw new BadNameException("(" + state + ") Invalid hex character '" + t + "'!");
                    }
lbl119:
                    // 1 sources

                    try {
                        baos.write(b);
                        utf = baos.toByteArray();
                        bais = new ByteArrayInputStream(utf);
                        utfReader = new UTF8InputStreamReader(bais, 2048);
                        str = utfReader.readLine();
                        value.append(str);
                        baos.reset();
                        utfParsed = true;
                    }
                    catch (Exception e) {
                        if (tok.length() == 2) {
                            tokParsed = true;
                            utfParsed = false;
                            state = returnState;
                            break;
                        }
                        throw new BadNameException("(" + state + ") Invalid UTF-8 code '" + Hex.encode(baos.toByteArray()) + "'!");
                    }
lbl137:
                    // 2 sources

                    if (tok.length() > 2) {
                        tokParsed = false;
                        tok = tok.substring(2);
                    } else {
                        tokParsed = true;
                    }
                    state = returnState;
                    break;
lbl144:
                    // 1 sources

                    throw new BadNameException("(" + state + ") Can't ESCAPE non-special character '" + tok.charAt(0) + "'!");
                }
                case 5: {
                    if (!tok.equals("\\") && !utfParsed) {
                        throw new BadNameException("(" + state + ") Invalid UTF-8 code '" + Hex.encode(baos.toByteArray()) + "'!");
                    }
                    if (!tokParsed) {
                        tokParsed = true;
                    }
                    if (tok.equals("\"")) {
                        state = 6;
                        break;
                    }
                    if (tok.equals("\\")) {
                        returnState = state;
                        state = 4;
                        break;
                    }
                    value.append(tok);
                    break;
                }
                case 6: {
                    if (";,+".indexOf(tok.charAt(0)) >= 0) {
                        if (trunc != -1) {
                            value.setLength(trunc);
                        }
                        val = value.toString();
                        state = 0;
                        plus = tok.equals("+");
                        value.setLength(0);
                        ava_.add(new AVA(key, val, plus));
                        break;
                    }
                    if (" \r\n".indexOf(tok) >= 0) continue block26;
                    throw new BadNameException("(" + state + ") Only whitespace characters are " + "allowed after the second unescaped quotation " + "mark (\")!");
                }
                case 7: {
                    if (";,+".indexOf(tok.charAt(0)) >= 0) {
                        try {
                            val = value.toString();
                            state = 0;
                            plus = tok.equals("+");
                            buf = Hex.decode(val);
                            value.setLength(0);
                        }
                        catch (Exception e) {
                            throw new BadNameException("(" + state + ") Bad hexadecimal code '" + value.toString() + "'!");
                        }
                        if (buf.length == 0) {
                            throw new BadNameException("(" + state + ") Empty hexadecimal code '" + value.toString() + "'!");
                        }
                        ava_.add(new AVA(key, buf, plus));
                        break;
                    }
                    if (" \r\n".indexOf(tok) >= 0) {
                        if (trunc != -1) continue block26;
                        trunc = value.length();
                        break;
                    }
                    if (trunc != -1) {
                        throw new BadNameException("(" + state + ") Non-trailing whitespace characters " + "after hexadecimal code '" + value.toString() + "'!");
                    }
                    if ("0123456789ABCDEFabcdef".indexOf(tok.charAt(0)) >= 0) {
                        value.append(tok);
                        break;
                    }
                    throw new BadNameException("(" + state + ") Bad hexadecimal encoding '" + value.toString() + "'!");
                }
                default: {
                    throw new IllegalStateException("(" + state + ") Illegal state!");
                }
            }
        }
        if (!utfParsed) {
            throw new BadNameException("(" + state + ") Invalid UTF-8 code '" + Hex.encode(baos.toByteArray()) + "'!");
        }
        if (trunc != -1) {
            value.setLength(trunc);
        }
        if (state != 2 && state != 3 && state != 6 && state != 7) {
            throw new BadNameException("(" + state + ") Not in a final state!");
        }
        switch (state) {
            case 7: {
                try {
                    val = value.toString();
                    buf = Hex.decode(val);
                }
                catch (Exception e) {
                    throw new BadNameException("(" + state + ") Bad hexadecimal code '" + value.toString() + "'!");
                }
                if (buf.length == 0) {
                    throw new BadNameException("(" + state + ") Empty hexadecimal code '" + value.toString() + "'!");
                }
                ava_.add(new AVA(key, buf, false));
                break;
            }
            case 6: {
                val = value.toString();
                ava_.add(new AVA(key, val, false));
                break;
            }
            case 3: {
                val = value.toString();
                ava_.add(new AVA(key, val, false));
                break;
            }
            case 2: {
                ava_.add(new AVA(key, new String(), false));
            }
        }
        return ava_;
    }

    public static void main(String[] argv) throws Exception {
        RFC2253Parser parser = new RFC2253Parser();
        int n = 0;
        while (n < argv.length) {
            System.out.println("Input: '" + argv[n] + "'");
            Iterator it = parser.parse(argv[n]).iterator();
            while (it.hasNext()) {
                System.out.println(it.next());
            }
            ++n;
        }
    }
}

