/*
 * Decompiled with CFR 0.152.
 */
package codec.x509;

import codec.CorruptedCodeException;
import codec.InconsistentStateException;
import codec.asn1.ASN1BitString;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import codec.asn1.DERDecoder;
import codec.asn1.DEREncoder;
import codec.x509.AlgorithmIdentifier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class SubjectPublicKeyInfo
extends ASN1Sequence {
    private AlgorithmIdentifier algorithm_;
    private ASN1BitString encodedKey_;

    public SubjectPublicKeyInfo() {
        super(2);
        this.algorithm_ = new AlgorithmIdentifier();
        this.add(this.algorithm_);
        this.encodedKey_ = new ASN1BitString();
        this.add(this.encodedKey_);
    }

    public SubjectPublicKeyInfo(AlgorithmIdentifier aid, byte[] key) {
        super(2);
        if (aid == null || key == null) {
            throw new NullPointerException("Some arg is null!");
        }
        this.algorithm_ = aid;
        this.add(this.algorithm_);
        this.encodedKey_ = new ASN1BitString(key, 0);
        this.add(this.encodedKey_);
    }

    public SubjectPublicKeyInfo(AlgorithmIdentifier aid, ASN1Type key) {
        super(2);
        this.algorithm_ = aid;
        this.add(this.algorithm_);
        this.add(null);
        this.setRawKey(key);
    }

    public SubjectPublicKeyInfo(PublicKey key) throws InvalidKeyException {
        super(2);
        this.setPublicKey(key);
    }

    public PublicKey getPublicKey() throws NoSuchAlgorithmException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DEREncoder enc = new DEREncoder(bos);
            this.encode(enc);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(bos.toByteArray());
            enc.close();
            String alg = this.algorithm_.getAlgorithmOID().toString();
            KeyFactory kf = KeyFactory.getInstance(alg);
            return kf.generatePublic(spec);
        }
        catch (ASN1Exception e) {
            throw new InconsistentStateException("Internal, encoding error!");
        }
        catch (IOException e) {
            throw new InconsistentStateException("Internal, I/O exception caught!");
        }
        catch (InvalidKeySpecException e) {
            throw new InconsistentStateException("Encoded key spec rejected by key factory!");
        }
    }

    public void setPublicKey(PublicKey key) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("Key is null!");
        }
        this.clear();
        this.algorithm_ = new AlgorithmIdentifier();
        this.add(this.algorithm_);
        this.encodedKey_ = new ASN1BitString();
        this.add(this.encodedKey_);
        try {
            DERDecoder dec = new DERDecoder(new ByteArrayInputStream(key.getEncoded()));
            this.decode(dec);
            dec.close();
        }
        catch (IOException e) {
            throw new InvalidKeyException("Caught IOException!");
        }
        catch (ASN1Exception e) {
            throw new InvalidKeyException("Bad encoding!");
        }
    }

    protected void setRawKey(ASN1Type key) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DEREncoder enc = new DEREncoder(bos);
            key.encode(enc);
            this.encodedKey_ = new ASN1BitString(bos.toByteArray(), 0);
            enc.close();
            this.set(1, this.encodedKey_);
        }
        catch (ASN1Exception e) {
            throw new InconsistentStateException("Internal, encoding error!");
        }
        catch (IOException e) {
            throw new InconsistentStateException("Internal, I/O exception caught!");
        }
    }

    public byte[] getRawKey() {
        return this.encodedKey_.getBytes();
    }

    public ASN1Type getDecodedRawKey() throws CorruptedCodeException {
        try {
            DERDecoder dec = new DERDecoder(new ByteArrayInputStream(this.encodedKey_.getBytes()));
            ASN1Type raw = dec.readType();
            dec.close();
            return raw;
        }
        catch (ASN1Exception e) {
            throw new CorruptedCodeException("Cannot decode raw key!");
        }
        catch (IOException e) {
            throw new InconsistentStateException("Internal, I/O exception caught!");
        }
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithm_;
    }

    public void setAlgorithmIdentifier(AlgorithmIdentifier aid) {
        if (aid == null) {
            throw new NullPointerException("Need an algorithm identifier!");
        }
        this.set(0, aid);
        this.algorithm_ = aid;
    }

    public ASN1Type getKeyStruct() throws CorruptedCodeException {
        return this.getKeyStruct(true);
    }

    public ASN1Type getKeyStruct(boolean derDecode) throws CorruptedCodeException {
        if (derDecode) {
            return this.getDecodedRawKey();
        }
        return this.encodedKey_;
    }

    public void setKeyStruct(ASN1Type key) {
        this.setRawKey(key);
    }
}

