/*
 * Decompiled with CFR 0.152.
 */
package codec.x509;

import codec.CorruptedCodeException;
import codec.asn1.ASN1BitString;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import codec.asn1.Constraint;
import codec.asn1.ConstraintException;
import codec.asn1.DERDecoder;
import codec.asn1.DEREncoder;
import codec.asn1.Decoder;
import codec.asn1.Encoder;
import codec.util.JCA;
import codec.x509.AlgorithmIdentifier;
import codec.x509.X509Extension;
import codec.x509.X509TBSCertificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;

public class X509Certificate
extends java.security.cert.X509Certificate
implements ASN1Type,
Externalizable {
    private ASN1Sequence Certificate_ = new ASN1Sequence(3);
    private X509TBSCertificate tbsCertificate_ = new X509TBSCertificate();
    private AlgorithmIdentifier signatureAlgorithm_ = null;
    private ASN1BitString signatureValue_ = null;

    public X509Certificate() {
        this.Certificate_.add(this.tbsCertificate_);
        this.signatureAlgorithm_ = new AlgorithmIdentifier();
        this.Certificate_.add(this.signatureAlgorithm_);
        this.signatureValue_ = new ASN1BitString();
        this.Certificate_.add(this.signatureValue_);
    }

    public X509Certificate(byte[] cert) throws CertificateEncodingException {
        this();
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(cert);
            this.decode(new DERDecoder(bais));
            bais.close();
        }
        catch (Exception e) {
            throw new CertificateEncodingException(e.getMessage());
        }
    }

    public X509Certificate(InputStream in) throws CertificateEncodingException {
        this();
        try {
            this.decode(new DERDecoder(in));
        }
        catch (Exception e) {
            throw new CertificateEncodingException(e.getMessage());
        }
    }

    public X509Certificate(X509TBSCertificate tbs) {
        this();
        this.setTBSCertificate(tbs);
    }

    public void setConstraint(Constraint c) {
        this.Certificate_.setConstraint(c);
    }

    public Constraint getConstraint() {
        return this.Certificate_.getConstraint();
    }

    public void addExtension(X509Extension ext) {
        this.tbsCertificate_.addExtension(ext);
    }

    public void checkConstraints() throws ConstraintException {
        this.Certificate_.checkConstraints();
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        this.checkValidity(now.getTime());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        now.setTime(date);
        if (now.before(this.tbsCertificate_.getNotBefore())) {
            throw new CertificateNotYetValidException("Certificate is not valid yet!");
        }
        if (now.after(this.tbsCertificate_.getNotAfter())) {
            throw new CertificateExpiredException("Certificate is expired");
        }
    }

    public void checkValidity(Calendar now) throws CertificateExpiredException, CertificateNotYetValidException {
        if (now.before(this.tbsCertificate_.getNotBefore())) {
            throw new CertificateNotYetValidException("Certificate is not valid yet");
        }
        if (now.after(this.tbsCertificate_.getNotAfter())) {
            throw new CertificateExpiredException("Certificate is expired");
        }
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        this.Certificate_.decode(dec);
    }

    public void encode(Encoder enc) throws ASN1Exception, IOException {
        this.Certificate_.encode(enc);
    }

    public int getBasicConstraints() {
        return this.tbsCertificate_.getBasicConstraints();
    }

    public Set getCriticalExtensionOIDs() {
        return this.tbsCertificate_.getCriticalExtensionOIDs();
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        byte[] res = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.encode(new DEREncoder(baos));
            res = baos.toByteArray();
            baos.close();
        }
        catch (IOException e) {
            System.out.println("internal error:");
            e.printStackTrace();
        }
        catch (ASN1Exception e) {
            throw new CertificateEncodingException(e.getMessage());
        }
        return res;
    }

    public Collection getExtensions() {
        return this.tbsCertificate_.getExtensions();
    }

    public byte[] getExtensionValue(String ex) {
        return this.tbsCertificate_.getExtensionValue(ex);
    }

    public Principal getIssuerDN() {
        return this.tbsCertificate_.getIssuerDN();
    }

    public boolean[] getIssuerUniqueID() {
        return this.tbsCertificate_.getIssuerUniqueID();
    }

    public boolean[] getKeyUsage() {
        return this.tbsCertificate_.getKeyUsage();
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.tbsCertificate_.getNonCriticalExtensionOIDs();
    }

    public Date getNotAfter() {
        return this.tbsCertificate_.getNotAfter();
    }

    public Date getNotBefore() {
        return this.tbsCertificate_.getNotBefore();
    }

    public PublicKey getPublicKey() {
        try {
            return this.tbsCertificate_.getPublicKey();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException("Public Key algorithm not supported by any installed provider!");
        }
    }

    public BigInteger getSerialNumber() {
        return this.tbsCertificate_.getSerialNumber();
    }

    public String getSigAlgName() {
        String res = JCA.getName(this.getSigAlgOID());
        return res;
    }

    public String getSigAlgOID() {
        return this.signatureAlgorithm_.getAlgorithmOID().toString();
    }

    public byte[] getSigAlgParams() {
        byte[] res = null;
        try {
            res = this.signatureAlgorithm_.getParameters().getEncoded();
        }
        catch (Exception intern) {
            System.out.println("internal Error:");
            intern.printStackTrace();
        }
        return res;
    }

    public byte[] getSignature() {
        return this.signatureValue_.getBytes();
    }

    public Principal getSubjectDN() {
        return this.tbsCertificate_.getSubjectDN();
    }

    public boolean[] getSubjectUniqueID() {
        return this.tbsCertificate_.getSubjectUniqueID();
    }

    public int getTag() {
        return this.Certificate_.getTag();
    }

    public int getTagClass() {
        return this.Certificate_.getTagClass();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return this.tbsCertificate_.getEncoded();
    }

    public X509TBSCertificate getX509TBSCertificate() {
        return this.tbsCertificate_;
    }

    public byte[] getTBSCertificate(AlgorithmIdentifier sigalg) throws CertificateEncodingException {
        this.tbsCertificate_.setSignatureAlgorithm(sigalg);
        this.setSignatureAlgorithm(sigalg);
        return this.tbsCertificate_.getEncoded();
    }

    public Object getValue() {
        return this.Certificate_.getValue();
    }

    public int getVersion() {
        return this.tbsCertificate_.getVersion();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    public boolean isExplicit() {
        return this.Certificate_.isExplicit();
    }

    public boolean isOptional() {
        return this.Certificate_.isOptional();
    }

    public boolean isType(int eins, int zwei) {
        return this.Certificate_.isType(eins, zwei);
    }

    public void setExplicit(boolean ex) {
        this.Certificate_.setExplicit(ex);
    }

    public void setTBSCertificate(X509TBSCertificate tbs) {
        this.tbsCertificate_ = tbs;
        this.Certificate_.set(0, this.tbsCertificate_);
    }

    public void setOptional(boolean opt) {
        this.Certificate_.setOptional(opt);
    }

    public void setSignature(byte[] nsig) {
        try {
            this.signatureValue_.setBits(nsig, 0);
        }
        catch (ConstraintException e) {
            System.out.println("internal error:");
            e.printStackTrace();
        }
    }

    public void setSignatureAlgorithm(AlgorithmIdentifier aid) {
        this.signatureAlgorithm_ = (AlgorithmIdentifier)aid.clone();
        this.Certificate_.set(1, aid);
        this.tbsCertificate_.setSignatureAlgorithm((AlgorithmIdentifier)aid.clone());
    }

    public String toString() {
        String res = "X.509 Certificate {";
        res = res + this.tbsCertificate_.toString();
        res = res + "\nsignature:\n" + this.signatureValue_.toString();
        return res;
    }

    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(key, "");
    }

    public void verify(PublicKey key, String pro) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature theSig = null;
        String alg_name = this.getSigAlgName();
        String alg_oid = this.getSigAlgOID();
        try {
            theSig = pro != null && !pro.equals("") ? Signature.getInstance(alg_name, pro) : Signature.getInstance(alg_name);
        }
        catch (NoSuchAlgorithmException nsae) {
            theSig = pro != null && !pro.equals("") ? Signature.getInstance(alg_oid, pro) : Signature.getInstance(alg_oid);
        }
        theSig.initVerify(key);
        theSig.update(this.getTBSCertificate());
        if (!theSig.verify(this.getSignature())) {
            throw new SignatureException("invalid Signature!");
        }
    }

    public void sign(Signature sig, PublicKey signerPub) throws SignatureException, CertificateEncodingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        try {
            AlgorithmIdentifier keyAlgID = AlgorithmIdentifier.createAlgorithmIdentifier(signerPub);
            AlgorithmParameters params = keyAlgID.getParameters();
            AlgorithmIdentifier sigAlgID = new AlgorithmIdentifier(sig.getAlgorithm(), params);
            this.tbsCertificate_.setSignatureAlgorithm(sigAlgID);
            this.setSignatureAlgorithm(sigAlgID);
            sig.update(this.tbsCertificate_.getEncoded());
            this.setSignature(sig.sign());
        }
        catch (CorruptedCodeException cce) {
            throw new CertificateEncodingException("Cought CorruptedCodeException: " + cce.getMessage());
        }
    }

    public void sign(Signature sig, java.security.cert.X509Certificate cert) throws SignatureException, CertificateEncodingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this.sign(sig, cert.getPublicKey());
    }

    public void writeExternal(ObjectOutput s) throws IOException {
        byte[] res = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.encode(new DEREncoder(baos));
            res = baos.toByteArray();
            baos.close();
            s.write(res);
        }
        catch (ASN1Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void readExternal(ObjectInput s) throws IOException {
        try {
            this.decode(new DERDecoder((ObjectInputStream)s));
        }
        catch (ASN1Exception e) {
            throw new RuntimeException(e.toString());
        }
    }
}

