/*
 * Decompiled with CFR 0.152.
 */
package codec.x509.extensions;

import codec.asn1.ASN1IA5String;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Sequence;
import codec.x509.GeneralName;

public class AccessDescription
extends ASN1Sequence {
    private GeneralName accessLocation;
    private ASN1ObjectIdentifier accessMethod;

    public AccessDescription() {
        this.accessLocation = new GeneralName();
        this.accessLocation.setUniformResourceIdentifier(new ASN1IA5String("http://ocsptest:8080/ocsp"));
        this.accessMethod = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.48.1");
        this.add(this.accessMethod);
        this.add(this.accessLocation);
    }

    public AccessDescription(ASN1ObjectIdentifier oid, GeneralName name) {
        if (oid == null || name == null) {
            throw new NullPointerException("oid or name");
        }
        this.accessLocation = name;
        this.accessMethod = oid;
        this.add(this.accessMethod);
        this.add(this.accessLocation);
    }

    public String toString() {
        return "AccessDescription : accessMethod : " + this.accessMethod.toString() + "\n  accessLocation : " + this.accessLocation.toString();
    }
}

