/*
 * Decompiled with CFR 0.152.
 */
package codec.x509.extensions;

import codec.asn1.ASN1GeneralizedTime;
import codec.asn1.ASN1ObjectIdentifier;
import codec.x509.X509Extension;
import java.util.Date;

public class DateOfCreationExtension
extends X509Extension {
    public static final String EXTENSION_OID = "1.3.36.8.3.1";
    private ASN1GeneralizedTime creationDate = null;
    private boolean criticality = false;

    public DateOfCreationExtension(Date cDate, boolean crit) throws Exception {
        if (cDate == null) {
            throw new Exception("Date was null, set Date to a proper value!");
        }
        this.setOID(new ASN1ObjectIdentifier(EXTENSION_OID));
        this.creationDate = new ASN1GeneralizedTime(cDate);
        this.criticality = crit;
        this.setCritical(this.criticality);
        this.setValue(this.creationDate);
    }

    public boolean isCritical() {
        return this.criticality;
    }

    public Date getCreationDate() {
        return (Date)this.creationDate.getDate().clone();
    }

    public String toString() {
        String result = "";
        result = result + "OID : " + EXTENSION_OID + "\n";
        result = result + "Criticality : " + this.criticality + "\n";
        result = result + "Date of Creation : " + this.creationDate + "\n";
        return result;
    }
}

