/*
 * Decompiled with CFR 0.152.
 */
package codec.x509.extensions;

import codec.asn1.ASN1BitString;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1SequenceOf;
import codec.asn1.ASN1TaggedType;
import codec.x509.GeneralName;
import codec.x509.X509Exception;
import java.util.AbstractList;
import java.util.Iterator;

public class DistributionPoint
extends ASN1Sequence {
    public static final int TAG_DISTRIBUTION_POINT = 0;
    public static final int TAG_REASONS = 1;
    public static final int TAG_CRL_ISSUER = 2;
    public static final int TAG_FULL_NAME = 0;
    private ASN1TaggedType distributionPointTag_;
    private ASN1TaggedType distributionPoint_;
    private ASN1Sequence fullName_ = new ASN1SequenceOf(class$codec$x509$GeneralName == null ? (class$codec$x509$GeneralName = DistributionPoint.class$("codec.x509.GeneralName")) : class$codec$x509$GeneralName);
    private ASN1TaggedType reasonsTag_;
    private ASN1BitString reasons_;
    private ASN1TaggedType cRLIssuerTag_;
    private ASN1Sequence cRLIssuer_;
    static /* synthetic */ Class class$codec$x509$GeneralName;

    public DistributionPoint() {
        this.distributionPoint_ = new ASN1TaggedType(0, this.fullName_, false, false);
        this.distributionPointTag_ = new ASN1TaggedType(0, this.distributionPoint_, true, true);
        this.add(this.distributionPointTag_);
        this.reasons_ = new ASN1BitString();
        this.reasonsTag_ = new ASN1TaggedType(1, this.reasons_, false, true);
        this.add(this.reasonsTag_);
        this.cRLIssuer_ = new ASN1SequenceOf(class$codec$x509$GeneralName == null ? (class$codec$x509$GeneralName = DistributionPoint.class$("codec.x509.GeneralName")) : class$codec$x509$GeneralName);
        this.cRLIssuerTag_ = new ASN1TaggedType(2, this.cRLIssuer_, false, true);
        this.add(this.cRLIssuerTag_);
    }

    public void setReasons(boolean[] flags) throws ASN1Exception {
        if (flags.length > 7) {
            throw new ASN1Exception("Wrong number of flags!");
        }
        this.reasons_.setBits(flags);
        this.reasonsTag_.setOptional(false);
    }

    public void addDistributionPointName(GeneralName aName) {
        this.fullName_.add(aName);
        this.distributionPointTag_.setOptional(false);
    }

    public void addCRLIssuer(GeneralName aName) {
        this.cRLIssuer_.add(aName);
        this.cRLIssuerTag_.setOptional(false);
    }

    public ASN1Sequence getDistributionPointNames() {
        if (this.distributionPointTag_.isOptional()) {
            return null;
        }
        return this.fullName_;
    }

    public String[] getDPURLs() {
        ASN1Sequence names = this.getDistributionPointNames();
        if (names == null) {
            return null;
        }
        String[] res = new String[names.size()];
        int n = 0;
        Iterator i = ((AbstractList)names).iterator();
        while (i.hasNext()) {
            try {
                GeneralName gn = (GeneralName)i.next();
                res[n] = gn.getGeneralName().getValue().toString();
            }
            catch (X509Exception ex) {
                res[n] = "<could not decode this URL!>";
            }
            ++n;
        }
        return res;
    }

    public String toString(String offset) {
        StringBuffer buf = new StringBuffer(offset + "DistributionPoint {\n");
        String[] dps = this.getDPURLs();
        if (dps == null) {
            buf.append(offset + "No URLs\n");
        } else {
            int i = 0;
            while (i < dps.length) {
                buf.append(offset + dps[i]);
                buf.append("\n");
                ++i;
            }
        }
        if (!this.cRLIssuerTag_.isOptional()) {
            buf.append("CRL Issuers:\n" + this.cRLIssuer_.toString());
        }
        buf.append(offset + "}\n");
        return buf.toString();
    }

    public String toString() {
        return this.toString("");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

