/*
 * Decompiled with CFR 0.152.
 */
package codec.x509.extensions;

import codec.asn1.ASN1BitString;
import codec.asn1.ASN1Boolean;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1SequenceOf;
import codec.asn1.ASN1TaggedType;
import codec.asn1.Decoder;
import codec.x509.GeneralName;
import codec.x509.X509Exception;
import codec.x509.X509Extension;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;

public class IssuingDistPoint
extends X509Extension {
    public static final int TAG_DISTRIBUTION_POINT = 0;
    public static final int TAG_CONTAINS_USER_CERTS = 1;
    public static final int TAG_CONTAINS_CA_CERTS = 2;
    public static final int TAG_SOME_REASONS = 3;
    public static final int TAG_INDIRECT_CRL = 4;
    public static final int TAG_FULL_NAME = 0;
    public static final String ID_CE_ISSUING_DISTRIBUTION_POINT = "2.5.29.28";
    private ASN1TaggedType distributionPointTag_;
    private ASN1TaggedType distributionPoint_;
    private ASN1Sequence fullName_;
    private ASN1TaggedType containsUserCertsTag_;
    private ASN1Boolean containsUserCerts_;
    private ASN1TaggedType containsCaCertsTag_;
    private ASN1Boolean containsCaCerts_;
    private ASN1TaggedType someReasonsTag_;
    private ASN1BitString someReasons_;
    private ASN1TaggedType indirectCrlTag_;
    private ASN1Boolean indirectCrl_;
    private ASN1Sequence idp = new ASN1Sequence(5);
    static /* synthetic */ Class class$codec$x509$GeneralName;

    public IssuingDistPoint() throws Exception {
        this.setOID(new ASN1ObjectIdentifier(ID_CE_ISSUING_DISTRIBUTION_POINT));
        this.setCritical(true);
        this.fullName_ = new ASN1SequenceOf(class$codec$x509$GeneralName == null ? (class$codec$x509$GeneralName = IssuingDistPoint.class$("codec.x509.GeneralName")) : class$codec$x509$GeneralName);
        this.distributionPoint_ = new ASN1TaggedType(0, this.fullName_, false, false);
        this.distributionPointTag_ = new ASN1TaggedType(0, this.distributionPoint_, true, true);
        this.idp.add(this.distributionPointTag_);
        this.containsUserCerts_ = new ASN1Boolean(false);
        this.containsUserCertsTag_ = new ASN1TaggedType(1, this.containsUserCerts_, false, true);
        this.idp.add(this.containsUserCertsTag_);
        this.containsCaCerts_ = new ASN1Boolean(false);
        this.containsCaCertsTag_ = new ASN1TaggedType(2, this.containsCaCerts_, false, true);
        this.idp.add(this.containsCaCertsTag_);
        this.someReasons_ = new ASN1BitString();
        this.someReasonsTag_ = new ASN1TaggedType(3, this.someReasons_, false, true);
        this.idp.add(this.someReasonsTag_);
        this.indirectCrl_ = new ASN1Boolean(false);
        this.indirectCrlTag_ = new ASN1TaggedType(4, this.indirectCrl_, false, true);
        this.idp.add(this.indirectCrlTag_);
        this.setValue(this.idp);
    }

    public void setContainsUserCerts(boolean userCerts) throws Exception {
        this.containsUserCerts_.setTrue(userCerts);
        this.containsUserCertsTag_.setOptional(false);
        this.setValue(this.idp);
    }

    public void setContainsCaCerts(boolean caCerts) throws Exception {
        this.containsCaCerts_.setTrue(caCerts);
        this.containsCaCertsTag_.setOptional(false);
        this.setValue(this.idp);
    }

    public void addDistributionPointName(GeneralName aName) throws Exception {
        this.fullName_.add(aName);
        this.distributionPointTag_.setOptional(false);
        this.setValue(this.idp);
    }

    public void setSomeReasons(boolean[] flags) throws Exception {
        if (flags.length > 7) {
            throw new ASN1Exception("Wrong number of flags!");
        }
        this.someReasons_.setBits(flags);
        this.someReasonsTag_.setOptional(false);
        this.setValue(this.idp);
    }

    public void addIndirectCrl(boolean indirect) throws Exception {
        this.indirectCrl_.setTrue(indirect);
        this.indirectCrlTag_.setOptional(false);
        this.setValue(this.idp);
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        super.decode(dec);
        super.decodeExtensionValue(this.idp);
    }

    public ASN1Sequence getDistributionPointNames() {
        if (this.distributionPointTag_.isOptional()) {
            return null;
        }
        return this.fullName_;
    }

    public boolean onlyContainsUserCerts() {
        return this.containsUserCerts_.isTrue();
    }

    public boolean onlyCaCerts() {
        return this.containsCaCerts_.isTrue();
    }

    public boolean indirectCrl() {
        return this.indirectCrl_.isTrue();
    }

    public ASN1BitString someReasons() {
        return this.someReasons_;
    }

    public String[] getDPURLs() {
        ASN1Sequence names = this.getDistributionPointNames();
        if (names == null) {
            return null;
        }
        String[] res = new String[names.size()];
        int n = 0;
        Iterator i = ((AbstractList)names).iterator();
        while (i.hasNext()) {
            try {
                GeneralName gn = (GeneralName)i.next();
                res[n] = gn.getGeneralName().getValue().toString();
            }
            catch (X509Exception ex) {
                res[n] = "<could not decode this URL!>";
            }
            ++n;
        }
        return res;
    }

    public String toString(String offset) {
        StringBuffer buf = new StringBuffer(offset + "IssuingDistributionPoint {\n");
        String[] dps = this.getDPURLs();
        if (dps == null) {
            buf.append(offset + "No URLs\n");
        } else {
            int i = 0;
            while (i < dps.length) {
                buf.append(offset + dps[i]);
                buf.append("\n");
                ++i;
            }
        }
        buf.append("CRL Issuers:\n" + this.containsCaCerts_);
        buf.append(offset + "}\n");
        return buf.toString();
    }

    public String toString() {
        return this.toString("");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

