/*
 * Decompiled with CFR 0.152.
 */
package codec.x509.extensions;

import codec.asn1.ASN1Null;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1String;
import codec.asn1.ASN1Type;
import codec.x509.X509Extension;
import java.security.cert.CertificateEncodingException;

public class ValidityModelExtension
extends X509Extension {
    public static final String EXTENSION_OID = "1.3.6.1.4.1.8301.3.5";
    private ASN1ObjectIdentifier oid_;
    private ASN1Type info_;
    protected ASN1Sequence validityModelSyntax;

    public ValidityModelExtension() throws Exception {
        this.setOID(new ASN1ObjectIdentifier(EXTENSION_OID));
        this.setCritical(false);
        this.oid_ = new ASN1ObjectIdentifier("1.3.6.1.4.1.8301.3.5.1");
        this.info_ = new ASN1Null();
        this.info_.setOptional(true);
        this.validityModelSyntax = new ASN1Sequence();
        this.validityModelSyntax.add(this.oid_);
        this.validityModelSyntax.add(this.info_);
        this.setValue(this.validityModelSyntax);
    }

    public void setModelOid(ASN1ObjectIdentifier oid) throws CertificateEncodingException {
        this.oid_ = oid;
        this.setValue(this.validityModelSyntax);
    }

    public void setModelInfo(ASN1String info) throws CertificateEncodingException {
        this.info_ = info;
        this.validityModelSyntax.add(this.info_);
        this.setValue(this.validityModelSyntax);
    }

    public String toString(String offset) {
        StringBuffer buf = new StringBuffer(offset + "AuthorityInfoAccess [" + this.getOID() + "] {");
        if (this.isCritical()) {
            buf.append(" (CRITICAL)\n");
        } else {
            buf.append(" (NOT CRITICAL)\n");
        }
        buf.append(offset + this.oid_.toString());
        buf.append(offset + "}\n");
        if (!this.info_.isOptional()) {
            buf.append(offset + "  Info: " + this.info_ + "\n");
        }
        return buf.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

