/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.api;

import de.flexiprovider.api.Cipher;
import de.flexiprovider.api.Mode;
import de.flexiprovider.api.PaddingScheme;
import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.BadPaddingException;
import de.flexiprovider.api.exceptions.IllegalBlockSizeException;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidParameterException;
import de.flexiprovider.api.exceptions.NoSuchModeException;
import de.flexiprovider.api.exceptions.NoSuchPaddingException;
import de.flexiprovider.api.exceptions.ShortBufferException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.mode.ModeParameterSpec;
import de.flexiprovider.common.util.JavaSecureRandomWrapper;
import java.lang.reflect.Method;
import javax.crypto.spec.IvParameterSpec;

public abstract class BlockCipher
extends Cipher {
    private Mode mode;
    private PaddingScheme paddingScheme;
    private AlgorithmParameterSpec paramSpec;
    private byte[] buffer = null;
    private int modeBlockSize;
    private boolean initialized = false;
    protected SecureRandom random;

    protected final void engineInit(int opmode, java.security.Key key, java.security.spec.AlgorithmParameterSpec paramSpec, java.security.SecureRandom javaRand) throws java.security.InvalidKeyException, java.security.InvalidAlgorithmParameterException {
        AlgorithmParameterSpec cipherParams;
        ModeParameterSpec modeParams;
        this.random = new JavaSecureRandomWrapper(javaRand);
        this.initModeAndPadding();
        this.opMode = opmode;
        this.buffer = new byte[0];
        if (paramSpec == null) {
            modeParams = null;
            cipherParams = null;
        } else if (paramSpec instanceof IvParameterSpec) {
            modeParams = new ModeParameterSpec((IvParameterSpec)paramSpec);
            cipherParams = null;
        } else if (paramSpec instanceof ModeParameterSpec) {
            modeParams = (ModeParameterSpec)paramSpec;
            cipherParams = null;
        } else {
            byte[] iv;
            if (!(paramSpec instanceof AlgorithmParameterSpec)) {
                throw new java.security.InvalidAlgorithmParameterException("unsupported type");
            }
            cipherParams = (AlgorithmParameterSpec)paramSpec;
            try {
                Method getIV = cipherParams.getClass().getMethod("getIV", null);
                iv = (byte[])getIV.invoke((Object)cipherParams, null);
            }
            catch (Exception ex) {
                iv = null;
            }
            modeParams = iv == null ? null : new ModeParameterSpec(iv);
        }
        if (!(key instanceof SecretKey)) {
            throw new java.security.InvalidKeyException("unsupported type");
        }
        if (opmode == 1) {
            this.mode.initEncrypt((SecretKey)key, modeParams, cipherParams);
        } else if (opmode == 2) {
            this.mode.initDecrypt((SecretKey)key, modeParams, cipherParams);
        }
        this.modeBlockSize = this.mode.blockSize;
        this.paddingScheme.setBlockSize(this.modeBlockSize);
        this.initialized = true;
    }

    public final void setMode(String modeName) throws NoSuchModeException {
        if (this.mode != null) {
            return;
        }
        this.mode = modeName == null || modeName == "" ? Registry.getMode() : Registry.getMode(modeName);
        this.mode.setBlockCipher(this);
    }

    public final void setPadding(String paddingName) throws NoSuchPaddingException {
        if (this.paddingScheme != null) {
            return;
        }
        this.paddingScheme = paddingName == null || paddingName.equals("") ? Registry.getPaddingScheme() : Registry.getPaddingScheme(paddingName);
    }

    public final byte[] getIV() {
        return this.initialized ? this.mode.iv : null;
    }

    protected abstract int getCipherBlockSize();

    public final int getBlockSize() {
        return this.initialized ? this.modeBlockSize : -1;
    }

    public final int getOutputSize(int inLen) {
        if (!this.initialized) {
            return -1;
        }
        int newInLen = inLen + (this.buffer == null ? 0 : this.buffer.length);
        return newInLen + this.paddingScheme.padLength(newInLen);
    }

    public final AlgorithmParameterSpec getParameters() {
        return this.initialized ? this.paramSpec : null;
    }

    public final void initEncrypt(Key key) throws InvalidKeyException, InvalidParameterException {
        this.initEncrypt(key, Registry.getSecureRandom());
    }

    public final void initEncrypt(Key key, SecureRandom random) throws InvalidKeyException, InvalidParameterException {
        try {
            this.initEncrypt(key, null, null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidParameterException("This cipher needs algorithm parameters for initialization (cannot be null).");
        }
    }

    public final void initEncrypt(Key key, AlgorithmParameterSpec cipherParams, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initEncrypt(key, null, cipherParams, random);
    }

    public final void initEncrypt(Key key, ModeParameterSpec modeParams, AlgorithmParameterSpec cipherParams, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initModeAndPadding();
        this.opMode = 1;
        this.buffer = new byte[0];
        this.paramSpec = cipherParams;
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("unsupported type");
        }
        this.mode.initEncrypt((SecretKey)key, modeParams, cipherParams);
        this.modeBlockSize = this.mode.blockSize;
        this.paddingScheme.setBlockSize(this.modeBlockSize);
        this.initialized = true;
    }

    public final void initDecrypt(Key key) throws InvalidKeyException, InvalidParameterException {
        try {
            this.initDecrypt(key, null, null);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidParameterException("This cipher needs algorithm parameters for initialization (cannot be null).");
        }
    }

    public final void initDecrypt(Key key, AlgorithmParameterSpec cipherParams) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initDecrypt(key, null, cipherParams);
    }

    public final void initDecrypt(Key key, ModeParameterSpec modeParams, AlgorithmParameterSpec cipherParams) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initModeAndPadding();
        this.opMode = 2;
        this.buffer = new byte[0];
        this.paramSpec = cipherParams;
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("unsupported type");
        }
        this.mode.initDecrypt((SecretKey)key, modeParams, cipherParams);
        this.modeBlockSize = this.mode.blockSize;
        this.paddingScheme.setBlockSize(this.modeBlockSize);
        this.initialized = true;
    }

    public final byte[] update(byte[] input, int inOff, int inLen) {
        byte[] newInput;
        int newInLen;
        int newInOff;
        if (!this.initialized || input == null || inLen <= 0) {
            return new byte[0];
        }
        int bufLen = this.buffer.length;
        if (bufLen == 0) {
            newInOff = inOff;
            newInLen = inLen;
            newInput = input;
        } else {
            newInLen = bufLen + inLen;
            newInOff = 0;
            newInput = new byte[newInLen];
            System.arraycopy(this.buffer, 0, newInput, 0, bufLen);
            System.arraycopy(input, inOff, newInput, bufLen, inLen);
        }
        int numBlocks = newInLen / this.modeBlockSize;
        int numBytes = numBlocks * this.modeBlockSize;
        int remaining = newInLen - numBytes;
        if (this.opMode == 2 && remaining == 0) {
            remaining = this.modeBlockSize;
            --numBlocks;
            numBytes -= this.modeBlockSize;
        }
        byte[] output = new byte[numBytes];
        int outOff = 0;
        int block = 0;
        while (block < numBlocks) {
            if (this.opMode == 1) {
                this.mode.nextChunkEncrypt(newInput, newInOff, output, outOff);
            } else if (this.opMode == 2) {
                this.mode.nextChunkDecrypt(newInput, newInOff, output, outOff);
            }
            newInOff += this.modeBlockSize;
            outOff += this.modeBlockSize;
            ++block;
        }
        this.buffer = new byte[remaining];
        System.arraycopy(newInput, newInOff, this.buffer, 0, remaining);
        return output;
    }

    public final int update(byte[] input, int inOff, int inLen, byte[] output, int outOff) throws ShortBufferException {
        int numBytes;
        if (!this.initialized || input == null || inLen <= 0) {
            return 0;
        }
        int newInLen = this.buffer.length + inLen;
        int remaining = newInLen % this.modeBlockSize;
        if (this.opMode == 2 && remaining == 0) {
            remaining = this.modeBlockSize;
        }
        if (output.length - outOff < (numBytes = newInLen - remaining)) {
            throw new ShortBufferException("output");
        }
        byte[] update = this.update(input, inOff, inLen);
        System.arraycopy(update, 0, output, outOff, update.length);
        return update.length;
    }

    public final byte[] doFinal(byte[] input, int inOff, int inLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] output = new byte[]{};
        if (input == null && this.buffer == null) {
            return output;
        }
        byte[] update = this.update(input, inOff, inLen);
        int updLen = update.length;
        int bufLen = this.buffer.length;
        if (this.opMode == 1) {
            int padLen = this.paddingScheme.padLength(bufLen);
            if (padLen == 0) {
                return update;
            }
            output = new byte[updLen + bufLen + padLen];
            System.arraycopy(update, 0, output, 0, updLen);
            System.arraycopy(this.buffer, 0, output, updLen, bufLen);
            this.paddingScheme.pad(output, updLen, bufLen);
            this.mode.nextChunkEncrypt(output, updLen, output, updLen);
        } else if (this.opMode == 2) {
            if (bufLen != this.modeBlockSize) {
                throw new IllegalBlockSizeException("ciphertext length is not a multiple of block size");
            }
            this.mode.nextChunkDecrypt(this.buffer, 0, this.buffer, 0);
            int padOffset = this.paddingScheme.unpad(this.buffer, 0, this.modeBlockSize);
            output = new byte[updLen + padOffset];
            System.arraycopy(update, 0, output, 0, updLen);
            System.arraycopy(this.buffer, 0, output, updLen, padOffset);
        }
        this.buffer = null;
        this.mode.reset();
        return output;
    }

    public final int doFinal(byte[] input, int inOff, int inLen, byte[] output, int outOff) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] doFinal = this.doFinal(input, inOff, inLen);
        int outLen = doFinal.length;
        if (outLen == 0) {
            return 0;
        }
        if (output.length - outOff < outLen) {
            throw new ShortBufferException("output");
        }
        System.arraycopy(doFinal, 0, output, outOff, outLen);
        return outLen;
    }

    protected abstract void initCipherEncrypt(SecretKey var1, AlgorithmParameterSpec var2) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract void initCipherDecrypt(SecretKey var1, AlgorithmParameterSpec var2) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract void singleBlockEncrypt(byte[] var1, int var2, byte[] var3, int var4);

    protected abstract void singleBlockDecrypt(byte[] var1, int var2, byte[] var3, int var4);

    private void initModeAndPadding() {
        if (this.mode == null) {
            this.mode = Registry.getMode();
            this.mode.setBlockCipher(this);
        }
        if (this.paddingScheme == null) {
            this.paddingScheme = Registry.getPaddingScheme();
        }
    }
}

