/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.api;

import de.flexiprovider.api.Cipher;
import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.BadPaddingException;
import de.flexiprovider.api.exceptions.IllegalBlockSizeException;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidParameterException;
import de.flexiprovider.api.exceptions.NoSuchAlgorithmException;
import de.flexiprovider.api.exceptions.NoSuchModeException;
import de.flexiprovider.api.exceptions.NoSuchPaddingException;
import de.flexiprovider.api.exceptions.ShortBufferException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.api.parameters.AlgorithmParameters;
import de.flexiprovider.common.util.JavaSecureRandomWrapper;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.CipherSpi;

public abstract class Cipher
extends CipherSpi {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    protected int opMode;

    protected final void engineInit(int opMode, java.security.Key key, java.security.SecureRandom random) throws java.security.InvalidKeyException {
        try {
            this.engineInit(opMode, key, (java.security.spec.AlgorithmParameterSpec)null, random);
        }
        catch (java.security.InvalidAlgorithmParameterException e) {
            throw new InvalidParameterException(e.getMessage());
        }
    }

    protected final void engineInit(int opMode, java.security.Key key, java.security.AlgorithmParameters algParams, java.security.SecureRandom random) throws java.security.InvalidKeyException, java.security.InvalidAlgorithmParameterException {
        if (algParams == null) {
            this.engineInit(opMode, key, random);
            return;
        }
        java.security.spec.AlgorithmParameterSpec paramSpec = null;
        try {
            paramSpec = (java.security.spec.AlgorithmParameterSpec)algParams.getParameterSpec(Registry.getAlgParamSpecClass(algParams.getAlgorithm()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidAlgorithmParameterException("Unknown algorithm parameters.");
        }
        catch (InvalidParameterSpecException e) {
            throw new RuntimeException("Internal error: invalid parameters type.");
        }
        this.engineInit(opMode, key, paramSpec, random);
    }

    protected void engineInit(int opMode, java.security.Key key, java.security.spec.AlgorithmParameterSpec params, java.security.SecureRandom javaRand) throws java.security.InvalidKeyException, java.security.InvalidAlgorithmParameterException {
        if (params != null && !(params instanceof AlgorithmParameterSpec)) {
            throw new java.security.InvalidAlgorithmParameterException();
        }
        if (key == null || !(key instanceof Key)) {
            throw new java.security.InvalidKeyException();
        }
        this.opMode = opMode;
        if (opMode == 1) {
            JavaSecureRandomWrapper flexiRand = new JavaSecureRandomWrapper(javaRand);
            this.initEncrypt((Key)key, (AlgorithmParameterSpec)params, flexiRand);
        } else if (opMode == 2) {
            this.initDecrypt((Key)key, (AlgorithmParameterSpec)params);
        }
    }

    protected final byte[] engineDoFinal(byte[] input, int inOff, int inLen) throws javax.crypto.IllegalBlockSizeException, javax.crypto.BadPaddingException {
        return this.doFinal(input, inOff, inLen);
    }

    protected final int engineDoFinal(byte[] input, int inOff, int inLen, byte[] output, int outOff) throws javax.crypto.ShortBufferException, javax.crypto.IllegalBlockSizeException, javax.crypto.BadPaddingException {
        return this.doFinal(input, inOff, inLen, output, outOff);
    }

    protected final int engineGetBlockSize() {
        return this.getBlockSize();
    }

    protected final int engineGetKeySize(java.security.Key key) throws java.security.InvalidKeyException {
        if (!(key instanceof Key)) {
            throw new java.security.InvalidKeyException("Unsupported key.");
        }
        return this.getKeySize((Key)key);
    }

    protected final byte[] engineGetIV() {
        return this.getIV();
    }

    protected final int engineGetOutputSize(int inLen) {
        return this.getOutputSize(inLen);
    }

    protected final java.security.AlgorithmParameters engineGetParameters() {
        AlgorithmParameters params;
        String algName = this.getName();
        try {
            params = Registry.getAlgParams(algName);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        final class JavaAlgorithmParameters
        extends java.security.AlgorithmParameters {
            private final /* synthetic */ Cipher this$0;

            JavaAlgorithmParameters(Cipher this$0, AlgorithmParameters params, String algName) {
                super(params, null, algName);
                this.this$0 = this$0;
            }
        }
        JavaAlgorithmParameters algParams = new JavaAlgorithmParameters(this, params, algName);
        AlgorithmParameterSpec algParamSpec = this.getParameters();
        if (algParamSpec == null) {
            return null;
        }
        try {
            algParams.init(algParamSpec);
        }
        catch (InvalidParameterSpecException ipse) {
            throw new RuntimeException("InvalidParameterSpecException: " + ipse.getMessage());
        }
        return algParams;
    }

    protected final void engineSetMode(String modeName) throws java.security.NoSuchAlgorithmException {
        this.setMode(modeName);
    }

    protected final void engineSetPadding(String paddingName) throws javax.crypto.NoSuchPaddingException {
        this.setPadding(paddingName);
    }

    protected final byte[] engineUpdate(byte[] input, int inOff, int inLen) {
        return this.update(input, inOff, inLen);
    }

    protected final int engineUpdate(byte[] input, int inOff, int inLen, byte[] output, int outOff) throws javax.crypto.ShortBufferException {
        return this.update(input, inOff, inLen, output, outOff);
    }

    public abstract void initEncrypt(Key var1, AlgorithmParameterSpec var2, SecureRandom var3) throws InvalidKeyException, InvalidAlgorithmParameterException;

    public abstract void initDecrypt(Key var1, AlgorithmParameterSpec var2) throws InvalidKeyException, InvalidAlgorithmParameterException;

    public abstract String getName();

    public abstract int getBlockSize();

    public abstract int getOutputSize(int var1);

    public abstract int getKeySize(Key var1) throws InvalidKeyException;

    public abstract AlgorithmParameterSpec getParameters();

    public abstract byte[] getIV();

    protected abstract void setMode(String var1) throws NoSuchModeException;

    protected abstract void setPadding(String var1) throws NoSuchPaddingException;

    public final byte[] update(byte[] input) {
        return this.update(input, 0, input.length);
    }

    public abstract byte[] update(byte[] var1, int var2, int var3);

    public abstract int update(byte[] var1, int var2, int var3, byte[] var4, int var5) throws ShortBufferException;

    public final byte[] doFinal() throws IllegalBlockSizeException, BadPaddingException {
        return this.doFinal(null, 0, 0);
    }

    public final byte[] doFinal(byte[] input) throws IllegalBlockSizeException, BadPaddingException {
        return this.doFinal(input, 0, input.length);
    }

    public abstract byte[] doFinal(byte[] var1, int var2, int var3) throws IllegalBlockSizeException, BadPaddingException;

    public abstract int doFinal(byte[] var1, int var2, int var3, byte[] var4, int var5) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException;
}

