/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.api;

import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.NoSuchAlgorithmException;
import de.flexiprovider.api.exceptions.ShortBufferException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.PrivateKey;
import de.flexiprovider.api.keys.PublicKey;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.util.JavaSecureRandomWrapper;
import javax.crypto.KeyAgreementSpi;

public abstract class KeyAgreement
extends KeyAgreementSpi {
    protected final void engineInit(java.security.Key key, java.security.SecureRandom javaRand) throws java.security.InvalidKeyException {
        if (!(key instanceof PrivateKey)) {
            throw new java.security.InvalidKeyException();
        }
        try {
            JavaSecureRandomWrapper flexiRand = new JavaSecureRandomWrapper(javaRand);
            this.init((PrivateKey)key, null, flexiRand);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("algorithm parameters required");
        }
    }

    protected final void engineInit(java.security.Key key, java.security.spec.AlgorithmParameterSpec params, java.security.SecureRandom javaRand) throws java.security.InvalidKeyException, java.security.InvalidAlgorithmParameterException {
        if (!(key instanceof PrivateKey)) {
            throw new java.security.InvalidKeyException();
        }
        JavaSecureRandomWrapper flexiRand = new JavaSecureRandomWrapper(javaRand);
        this.init((PrivateKey)key, (AlgorithmParameterSpec)params, flexiRand);
    }

    protected final byte[] engineGenerateSecret() throws IllegalStateException {
        return this.generateSecret();
    }

    protected final int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, javax.crypto.ShortBufferException {
        return this.generateSecret(sharedSecret, offset);
    }

    protected final javax.crypto.SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, java.security.NoSuchAlgorithmException {
        return this.generateSecret(algorithm);
    }

    protected final java.security.Key engineDoPhase(java.security.Key key, boolean lastPhase) throws java.security.InvalidKeyException, IllegalStateException {
        if (!(key instanceof PublicKey)) {
            throw new java.security.InvalidKeyException();
        }
        return this.doPhase((PublicKey)key, lastPhase);
    }

    public abstract void init(PrivateKey var1, AlgorithmParameterSpec var2, SecureRandom var3) throws InvalidKeyException, InvalidAlgorithmParameterException;

    public abstract byte[] generateSecret() throws IllegalStateException;

    public abstract int generateSecret(byte[] var1, int var2) throws IllegalStateException, ShortBufferException;

    public abstract SecretKey generateSecret(String var1) throws IllegalStateException, NoSuchAlgorithmException;

    public abstract Key doPhase(PublicKey var1, boolean var2) throws InvalidKeyException, IllegalStateException;
}

