/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.api;

import de.flexiprovider.api.AsymmetricBlockCipher;
import de.flexiprovider.api.AsymmetricHybridCipher;
import de.flexiprovider.api.BlockCipher;
import de.flexiprovider.api.Cipher;
import de.flexiprovider.api.KeyAgreement;
import de.flexiprovider.api.KeyDerivation;
import de.flexiprovider.api.Mac;
import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.api.Mode;
import de.flexiprovider.api.PaddingScheme;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.Signature;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.NoSuchAlgorithmException;
import de.flexiprovider.api.exceptions.NoSuchModeException;
import de.flexiprovider.api.exceptions.NoSuchPaddingException;
import de.flexiprovider.api.exceptions.RegistrationException;
import de.flexiprovider.api.keys.KeyFactory;
import de.flexiprovider.api.keys.KeyPairGenerator;
import de.flexiprovider.api.keys.SecretKeyFactory;
import de.flexiprovider.api.keys.SecretKeyGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.api.parameters.AlgorithmParameters;
import de.flexiprovider.common.mode.CBC;
import de.flexiprovider.common.padding.PKCS5Padding;
import de.flexiprovider.common.util.DefaultPRNG;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Registry {
    public static final int ASYMMETRIC_BLOCK_CIPHER = 0;
    public static final int ASYMMETRIC_HYBRID_CIPHER = 1;
    public static final int BLOCK_CIPHER = 2;
    public static final int MODE = 3;
    public static final int PADDING_SCHEME = 4;
    public static final int CIPHER = 5;
    public static final int MAC = 6;
    public static final int MESSAGE_DIGEST = 7;
    public static final int SECURE_RANDOM = 8;
    public static final int SIGNATURE = 9;
    public static final int ALG_PARAM_SPEC = 10;
    public static final int ALG_PARAMS = 11;
    public static final int ALG_PARAM_GENERATOR = 12;
    public static final int SECRET_KEY_GENERATOR = 13;
    public static final int KEY_PAIR_GENERATOR = 14;
    public static final int SECRET_KEY_FACTORY = 15;
    public static final int KEY_FACTORY = 16;
    public static final int KEY_DERIVATION = 17;
    public static final int KEY_AGREEMENT = 18;
    private static final Hashtable asymBlockCiphers = new Hashtable();
    private static final Hashtable asymHybridCiphers = new Hashtable();
    private static final Hashtable blockCiphers = new Hashtable();
    private static final Hashtable modes = new Hashtable();
    private static final Hashtable paddingSchemes = new Hashtable();
    private static final Hashtable ciphers = new Hashtable();
    private static final Hashtable macs = new Hashtable();
    private static final Hashtable messageDigests = new Hashtable();
    private static final Hashtable secureRandoms = new Hashtable();
    private static final Hashtable signatures = new Hashtable();
    private static final Hashtable algParamSpecs = new Hashtable();
    private static final Hashtable algParams = new Hashtable();
    private static final Hashtable algParamGenerators = new Hashtable();
    private static final Hashtable secretKeyGenerators = new Hashtable();
    private static final Hashtable keyPairGenerators = new Hashtable();
    private static final Hashtable secretKeyFactories = new Hashtable();
    private static final Hashtable keyFactories = new Hashtable();
    private static final Hashtable keyDerivations = new Hashtable();
    private static final Hashtable keyAgreements = new Hashtable();
    private static final Hashtable[] hashtables = new Hashtable[]{asymBlockCiphers, asymHybridCiphers, blockCiphers, modes, paddingSchemes, ciphers, macs, messageDigests, secureRandoms, signatures, algParamSpecs, algParams, algParamGenerators, secretKeyGenerators, keyPairGenerators, secretKeyFactories, keyFactories, keyDerivations, keyAgreements};
    private static final Class[] algClasses = new Class[]{class$de$flexiprovider$api$AsymmetricBlockCipher == null ? (class$de$flexiprovider$api$AsymmetricBlockCipher = Registry.class$("de.flexiprovider.api.AsymmetricBlockCipher")) : class$de$flexiprovider$api$AsymmetricBlockCipher, class$de$flexiprovider$api$AsymmetricHybridCipher == null ? (class$de$flexiprovider$api$AsymmetricHybridCipher = Registry.class$("de.flexiprovider.api.AsymmetricHybridCipher")) : class$de$flexiprovider$api$AsymmetricHybridCipher, class$de$flexiprovider$api$BlockCipher == null ? (class$de$flexiprovider$api$BlockCipher = Registry.class$("de.flexiprovider.api.BlockCipher")) : class$de$flexiprovider$api$BlockCipher, class$de$flexiprovider$api$Mode == null ? (class$de$flexiprovider$api$Mode = Registry.class$("de.flexiprovider.api.Mode")) : class$de$flexiprovider$api$Mode, class$de$flexiprovider$api$PaddingScheme == null ? (class$de$flexiprovider$api$PaddingScheme = Registry.class$("de.flexiprovider.api.PaddingScheme")) : class$de$flexiprovider$api$PaddingScheme, class$de$flexiprovider$api$Cipher == null ? (class$de$flexiprovider$api$Cipher = Registry.class$("de.flexiprovider.api.Cipher")) : class$de$flexiprovider$api$Cipher, class$de$flexiprovider$api$Mac == null ? (class$de$flexiprovider$api$Mac = Registry.class$("de.flexiprovider.api.Mac")) : class$de$flexiprovider$api$Mac, class$de$flexiprovider$api$MessageDigest == null ? (class$de$flexiprovider$api$MessageDigest = Registry.class$("de.flexiprovider.api.MessageDigest")) : class$de$flexiprovider$api$MessageDigest, class$de$flexiprovider$api$SecureRandom == null ? (class$de$flexiprovider$api$SecureRandom = Registry.class$("de.flexiprovider.api.SecureRandom")) : class$de$flexiprovider$api$SecureRandom, class$de$flexiprovider$api$Signature == null ? (class$de$flexiprovider$api$Signature = Registry.class$("de.flexiprovider.api.Signature")) : class$de$flexiprovider$api$Signature, class$de$flexiprovider$api$parameters$AlgorithmParameterSpec == null ? (class$de$flexiprovider$api$parameters$AlgorithmParameterSpec = Registry.class$("de.flexiprovider.api.parameters.AlgorithmParameterSpec")) : class$de$flexiprovider$api$parameters$AlgorithmParameterSpec, class$de$flexiprovider$api$parameters$AlgorithmParameters == null ? (class$de$flexiprovider$api$parameters$AlgorithmParameters = Registry.class$("de.flexiprovider.api.parameters.AlgorithmParameters")) : class$de$flexiprovider$api$parameters$AlgorithmParameters, class$de$flexiprovider$api$parameters$AlgorithmParameterGenerator == null ? (class$de$flexiprovider$api$parameters$AlgorithmParameterGenerator = Registry.class$("de.flexiprovider.api.parameters.AlgorithmParameterGenerator")) : class$de$flexiprovider$api$parameters$AlgorithmParameterGenerator, class$de$flexiprovider$api$keys$SecretKeyGenerator == null ? (class$de$flexiprovider$api$keys$SecretKeyGenerator = Registry.class$("de.flexiprovider.api.keys.SecretKeyGenerator")) : class$de$flexiprovider$api$keys$SecretKeyGenerator, class$de$flexiprovider$api$keys$KeyPairGenerator == null ? (class$de$flexiprovider$api$keys$KeyPairGenerator = Registry.class$("de.flexiprovider.api.keys.KeyPairGenerator")) : class$de$flexiprovider$api$keys$KeyPairGenerator, class$de$flexiprovider$api$keys$SecretKeyFactory == null ? (class$de$flexiprovider$api$keys$SecretKeyFactory = Registry.class$("de.flexiprovider.api.keys.SecretKeyFactory")) : class$de$flexiprovider$api$keys$SecretKeyFactory, class$de$flexiprovider$api$keys$KeyFactory == null ? (class$de$flexiprovider$api$keys$KeyFactory = Registry.class$("de.flexiprovider.api.keys.KeyFactory")) : class$de$flexiprovider$api$keys$KeyFactory, class$de$flexiprovider$api$KeyDerivation == null ? (class$de$flexiprovider$api$KeyDerivation = Registry.class$("de.flexiprovider.api.KeyDerivation")) : class$de$flexiprovider$api$KeyDerivation, class$de$flexiprovider$api$KeyAgreement == null ? (class$de$flexiprovider$api$KeyAgreement = Registry.class$("de.flexiprovider.api.KeyAgreement")) : class$de$flexiprovider$api$KeyAgreement};
    private static final Hashtable standardAlgParams = new Hashtable();
    static /* synthetic */ Class class$de$flexiprovider$api$AsymmetricBlockCipher;
    static /* synthetic */ Class class$de$flexiprovider$api$AsymmetricHybridCipher;
    static /* synthetic */ Class class$de$flexiprovider$api$BlockCipher;
    static /* synthetic */ Class class$de$flexiprovider$api$Mode;
    static /* synthetic */ Class class$de$flexiprovider$api$PaddingScheme;
    static /* synthetic */ Class class$de$flexiprovider$api$Cipher;
    static /* synthetic */ Class class$de$flexiprovider$api$Mac;
    static /* synthetic */ Class class$de$flexiprovider$api$MessageDigest;
    static /* synthetic */ Class class$de$flexiprovider$api$SecureRandom;
    static /* synthetic */ Class class$de$flexiprovider$api$Signature;
    static /* synthetic */ Class class$de$flexiprovider$api$parameters$AlgorithmParameterSpec;
    static /* synthetic */ Class class$de$flexiprovider$api$parameters$AlgorithmParameters;
    static /* synthetic */ Class class$de$flexiprovider$api$parameters$AlgorithmParameterGenerator;
    static /* synthetic */ Class class$de$flexiprovider$api$keys$SecretKeyGenerator;
    static /* synthetic */ Class class$de$flexiprovider$api$keys$KeyPairGenerator;
    static /* synthetic */ Class class$de$flexiprovider$api$keys$SecretKeyFactory;
    static /* synthetic */ Class class$de$flexiprovider$api$keys$KeyFactory;
    static /* synthetic */ Class class$de$flexiprovider$api$KeyDerivation;
    static /* synthetic */ Class class$de$flexiprovider$api$KeyAgreement;
    static /* synthetic */ Class class$de$flexiprovider$common$mode$CFBParameterSpec;
    static /* synthetic */ Class class$de$flexiprovider$common$mode$OFBParameterSpec;
    static /* synthetic */ Class class$de$flexiprovider$common$mode$ModeParameterSpec;
    static /* synthetic */ Class class$de$flexiprovider$common$mode$ModeParameters;
    static /* synthetic */ Class class$de$flexiprovider$common$mode$ModeParamGenParameterSpec;
    static /* synthetic */ Class class$de$flexiprovider$common$mode$ModeParameterGenerator;
    static /* synthetic */ Class class$de$flexiprovider$common$mode$ECB;
    static /* synthetic */ Class class$de$flexiprovider$common$mode$CBC;
    static /* synthetic */ Class class$de$flexiprovider$common$mode$OFB;
    static /* synthetic */ Class class$de$flexiprovider$common$mode$CFB;
    static /* synthetic */ Class class$de$flexiprovider$common$mode$CTR;
    static /* synthetic */ Class class$de$flexiprovider$common$padding$NoPadding;
    static /* synthetic */ Class class$de$flexiprovider$common$padding$OneAndZeroesPadding;
    static /* synthetic */ Class class$de$flexiprovider$common$padding$PKCS5Padding;

    protected Registry() {
    }

    public static final void add(int type, Class algClass, String algName) {
        Registry.add(type, algClass, new String[]{algName});
    }

    public static final void add(int type, Class algClass, String[] algNames) {
        Hashtable table = Registry.getHashtable(type);
        if (table == null || algClass == null || algNames == null || algNames.length == 0) {
            return;
        }
        Class expClass = algClasses[type];
        if (!expClass.isAssignableFrom(algClass)) {
            throw new RegistrationException("expected and actual algorithm types do not match");
        }
        table.put(algNames[0], algClass);
        int i = 1;
        while (i < algNames.length) {
            table.put(algNames[i], algNames[0]);
            ++i;
        }
    }

    public static final Enumeration getAlgorithms(int type) {
        Hashtable table = Registry.getHashtable(type);
        if (table == null) {
            return null;
        }
        return table.keys();
    }

    public static final Vector getNames(int type, String name) {
        Hashtable table = Registry.getHashtable(type);
        if (table == null) {
            return null;
        }
        Enumeration algorithms = Registry.getAlgorithms(type);
        Object target = Registry.resolveAlias(table, name);
        Vector<String> result = new Vector<String>();
        while (algorithms.hasMoreElements()) {
            String key = (String)algorithms.nextElement();
            if (!Registry.resolveAlias(table, key).equals(target)) continue;
            result.addElement(key);
        }
        return result;
    }

    public static final AsymmetricBlockCipher getAsymmetricBlockCipher(String algName) throws NoSuchAlgorithmException {
        return (AsymmetricBlockCipher)Registry.getInstance(asymBlockCiphers, algName);
    }

    public static final AsymmetricHybridCipher getAsymmetricHybridCipher(String algName) throws NoSuchAlgorithmException {
        return (AsymmetricHybridCipher)Registry.getInstance(asymHybridCiphers, algName);
    }

    public static final BlockCipher getBlockCipher(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        String algName;
        String modeName = null;
        String paddingName = null;
        int endIndex = transformation.indexOf(47);
        if (endIndex < 0) {
            algName = transformation;
        } else {
            algName = transformation.substring(0, endIndex);
            String modePadding = transformation.substring(endIndex + 1);
            if ((endIndex = modePadding.indexOf("/")) == -1) {
                throw new NoSuchAlgorithmException("Badly formed transformation: only 'algorithm' or 'algorithm/mode/padding' allowed.");
            }
            modeName = modePadding.substring(0, endIndex);
            paddingName = modePadding.substring(endIndex + 1);
            if (paddingName.indexOf("/") != -1) {
                throw new NoSuchAlgorithmException("Badly formed transformation: only 'algorithm' or 'algorithm/mode/padding' allowed.");
            }
        }
        BlockCipher result = (BlockCipher)Registry.getInstance(blockCiphers, algName);
        result.setMode(modeName);
        result.setPadding(paddingName);
        return result;
    }

    protected static final Mode getMode() {
        return new CBC();
    }

    protected static final Mode getMode(String modeName) throws NoSuchModeException {
        try {
            return (Mode)Registry.getInstance(modes, modeName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchModeException(e.getMessage());
        }
    }

    protected static final PaddingScheme getPaddingScheme() {
        return new PKCS5Padding();
    }

    protected static final PaddingScheme getPaddingScheme(String paddingName) throws NoSuchPaddingException {
        try {
            return (PaddingScheme)Registry.getInstance(paddingSchemes, paddingName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchPaddingException(e.getMessage());
        }
    }

    public static final Cipher getCipher(String algName) throws NoSuchAlgorithmException {
        return (Cipher)Registry.getInstance(ciphers, algName);
    }

    public static final Mac getMac(String algName) throws NoSuchAlgorithmException {
        return (Mac)Registry.getInstance(macs, algName);
    }

    public static final MessageDigest getMessageDigest(String algName) throws NoSuchAlgorithmException {
        return (MessageDigest)Registry.getInstance(messageDigests, algName);
    }

    public static final SecureRandom getSecureRandom(String algName) throws NoSuchAlgorithmException {
        return (SecureRandom)Registry.getInstance(secureRandoms, algName);
    }

    public static final SecureRandom getSecureRandom() {
        return new DefaultPRNG();
    }

    public static final Signature getSignature(String algName) throws NoSuchAlgorithmException {
        return (Signature)Registry.getInstance(signatures, algName);
    }

    public static final Class getAlgParamSpecClass(String algName) throws NoSuchAlgorithmException {
        Class algorithmClass = (Class)Registry.resolveAlias(algParamSpecs, algName);
        if (algorithmClass == null) {
            throw new NoSuchAlgorithmException(algName);
        }
        return algorithmClass;
    }

    public static final AlgorithmParameterSpec getAlgParamSpec(String paramName) throws InvalidAlgorithmParameterException {
        try {
            return (AlgorithmParameterSpec)Registry.getInstance(algParamSpecs, paramName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidAlgorithmParameterException("Unknown parameters: '" + paramName + "'.");
        }
    }

    public static final void addStandardAlgParams(String algName, String[] paramNames) {
        Registry.addStandardAlgParams(new String[]{algName}, paramNames);
    }

    public static final void addStandardAlgParams(String[] algNames, String[] paramNames) {
        if (algNames == null || paramNames == null) {
            return;
        }
        Vector<String> params = new Vector<String>(paramNames.length);
        int i = 0;
        while (i < paramNames.length) {
            params.addElement(paramNames[i]);
            ++i;
        }
        standardAlgParams.put(algNames[0], params);
        int i2 = 1;
        while (i2 < algNames.length) {
            standardAlgParams.put(algNames[i2], algNames[0]);
            ++i2;
        }
    }

    public static final Vector getStandardAlgParams(String algName) {
        return (Vector)Registry.resolveAlias(standardAlgParams, algName);
    }

    public static final AlgorithmParameters getAlgParams(String algName) throws NoSuchAlgorithmException {
        return (AlgorithmParameters)Registry.getInstance(algParams, algName);
    }

    public static final AlgorithmParameterGenerator getAlgParamGenerator(String algName) throws NoSuchAlgorithmException {
        return (AlgorithmParameterGenerator)Registry.getInstance(algParamGenerators, algName);
    }

    public static final SecretKeyGenerator getSecretKeyGenerator(String algName) throws NoSuchAlgorithmException {
        return (SecretKeyGenerator)Registry.getInstance(secretKeyGenerators, algName);
    }

    public static final KeyPairGenerator getKeyPairGenerator(String algName) throws NoSuchAlgorithmException {
        return (KeyPairGenerator)Registry.getInstance(keyPairGenerators, algName);
    }

    public static final SecretKeyFactory getSecretKeyFactory(String algName) throws NoSuchAlgorithmException {
        return (SecretKeyFactory)Registry.getInstance(secretKeyFactories, algName);
    }

    public static final KeyFactory getKeyFactory(String algName) throws NoSuchAlgorithmException {
        return (KeyFactory)Registry.getInstance(keyFactories, algName);
    }

    public static final KeyDerivation getKeyDerivation(String algName) throws NoSuchAlgorithmException {
        return (KeyDerivation)Registry.getInstance(keyDerivations, algName);
    }

    public static final KeyAgreement getKeyAgreement(String algName) throws NoSuchAlgorithmException {
        return (KeyAgreement)Registry.getInstance(keyAgreements, algName);
    }

    private static Hashtable getHashtable(int type) {
        if (type > hashtables.length) {
            return null;
        }
        return hashtables[type];
    }

    private static Object resolveAlias(Hashtable table, String name) {
        String algName;
        String value = name;
        while ((value = table.get(algName = value)) != null && value instanceof String) {
        }
        return value;
    }

    private static Object getInstance(Hashtable table, String name) throws NoSuchAlgorithmException {
        if (name == null) {
            return null;
        }
        Class algClass = (Class)Registry.resolveAlias(table, name);
        if (algClass == null) {
            throw new NoSuchAlgorithmException(name);
        }
        try {
            return algClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RegistrationException("Instantiation exception: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RegistrationException("Illegal access exception: " + e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Registry.add(10, class$de$flexiprovider$common$mode$CFBParameterSpec == null ? (class$de$flexiprovider$common$mode$CFBParameterSpec = Registry.class$("de.flexiprovider.common.mode.CFBParameterSpec")) : class$de$flexiprovider$common$mode$CFBParameterSpec, "CFB");
        Registry.add(10, class$de$flexiprovider$common$mode$OFBParameterSpec == null ? (class$de$flexiprovider$common$mode$OFBParameterSpec = Registry.class$("de.flexiprovider.common.mode.OFBParameterSpec")) : class$de$flexiprovider$common$mode$OFBParameterSpec, "OFB");
        Registry.add(10, class$de$flexiprovider$common$mode$ModeParameterSpec == null ? (class$de$flexiprovider$common$mode$ModeParameterSpec = Registry.class$("de.flexiprovider.common.mode.ModeParameterSpec")) : class$de$flexiprovider$common$mode$ModeParameterSpec, new String[]{"Mode", "IV"});
        Registry.add(11, class$de$flexiprovider$common$mode$ModeParameters == null ? (class$de$flexiprovider$common$mode$ModeParameters = Registry.class$("de.flexiprovider.common.mode.ModeParameters")) : class$de$flexiprovider$common$mode$ModeParameters, new String[]{"Mode", "IV"});
        Registry.add(10, class$de$flexiprovider$common$mode$ModeParamGenParameterSpec == null ? (class$de$flexiprovider$common$mode$ModeParamGenParameterSpec = Registry.class$("de.flexiprovider.common.mode.ModeParamGenParameterSpec")) : class$de$flexiprovider$common$mode$ModeParamGenParameterSpec, new String[]{"ModeParamGen", "IVParamGen"});
        Registry.add(12, class$de$flexiprovider$common$mode$ModeParameterGenerator == null ? (class$de$flexiprovider$common$mode$ModeParameterGenerator = Registry.class$("de.flexiprovider.common.mode.ModeParameterGenerator")) : class$de$flexiprovider$common$mode$ModeParameterGenerator, new String[]{"Mode", "IV"});
        Registry.add(3, class$de$flexiprovider$common$mode$ECB == null ? (class$de$flexiprovider$common$mode$ECB = Registry.class$("de.flexiprovider.common.mode.ECB")) : class$de$flexiprovider$common$mode$ECB, "ECB");
        Registry.add(3, class$de$flexiprovider$common$mode$CBC == null ? (class$de$flexiprovider$common$mode$CBC = Registry.class$("de.flexiprovider.common.mode.CBC")) : class$de$flexiprovider$common$mode$CBC, "CBC");
        Registry.add(3, class$de$flexiprovider$common$mode$OFB == null ? (class$de$flexiprovider$common$mode$OFB = Registry.class$("de.flexiprovider.common.mode.OFB")) : class$de$flexiprovider$common$mode$OFB, "OFB");
        Registry.add(3, class$de$flexiprovider$common$mode$CFB == null ? (class$de$flexiprovider$common$mode$CFB = Registry.class$("de.flexiprovider.common.mode.CFB")) : class$de$flexiprovider$common$mode$CFB, "CFB");
        Registry.add(3, class$de$flexiprovider$common$mode$CTR == null ? (class$de$flexiprovider$common$mode$CTR = Registry.class$("de.flexiprovider.common.mode.CTR")) : class$de$flexiprovider$common$mode$CTR, "CTR");
        Registry.add(4, class$de$flexiprovider$common$padding$NoPadding == null ? (class$de$flexiprovider$common$padding$NoPadding = Registry.class$("de.flexiprovider.common.padding.NoPadding")) : class$de$flexiprovider$common$padding$NoPadding, "NoPadding");
        Registry.add(4, class$de$flexiprovider$common$padding$OneAndZeroesPadding == null ? (class$de$flexiprovider$common$padding$OneAndZeroesPadding = Registry.class$("de.flexiprovider.common.padding.OneAndZeroesPadding")) : class$de$flexiprovider$common$padding$OneAndZeroesPadding, "OneAndZeroesPadding");
        Registry.add(4, class$de$flexiprovider$common$padding$PKCS5Padding == null ? (class$de$flexiprovider$common$padding$PKCS5Padding = Registry.class$("de.flexiprovider.common.padding.PKCS5Padding")) : class$de$flexiprovider$common$padding$PKCS5Padding, "PKCS5Padding");
    }
}

