/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.api.keys;

import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.keys.KeySpec;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeySpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactorySpi;

public abstract class SecretKeyFactory
extends SecretKeyFactorySpi {
    protected javax.crypto.SecretKey engineGenerateSecret(java.security.spec.KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec == null) {
            throw new InvalidKeySpecException();
        }
        if (!(keySpec instanceof KeySpec)) {
            if (keySpec instanceof javax.crypto.spec.SecretKeySpec) {
                javax.crypto.spec.SecretKeySpec javaSpec = (javax.crypto.spec.SecretKeySpec)keySpec;
                SecretKeySpec secretKeySpec = new SecretKeySpec(javaSpec.getEncoded(), javaSpec.getAlgorithm());
                return this.generateSecret(secretKeySpec);
            }
            throw new InvalidKeySpecException();
        }
        return this.generateSecret((KeySpec)keySpec);
    }

    protected java.security.spec.KeySpec engineGetKeySpec(javax.crypto.SecretKey key, Class keySpec) throws InvalidKeySpecException {
        if (key == null || keySpec == null || !(key instanceof SecretKey)) {
            throw new InvalidKeySpecException();
        }
        return this.getKeySpec((SecretKey)key, keySpec);
    }

    protected javax.crypto.SecretKey engineTranslateKey(javax.crypto.SecretKey key) throws java.security.InvalidKeyException {
        if (key == null || !(key instanceof SecretKey)) {
            throw new java.security.InvalidKeyException();
        }
        return this.translateKey((SecretKey)key);
    }

    public abstract SecretKey generateSecret(KeySpec var1) throws de.flexiprovider.api.exceptions.InvalidKeySpecException;

    public abstract KeySpec getKeySpec(SecretKey var1, Class var2) throws de.flexiprovider.api.exceptions.InvalidKeySpecException;

    public abstract SecretKey translateKey(SecretKey var1) throws InvalidKeyException;
}

