/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.ies;

import de.flexiprovider.api.keys.PrivateKey;
import de.flexiprovider.api.keys.PublicKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.util.ByteUtils;
import java.security.InvalidParameterException;
import java.security.KeyPair;

public class IESParameterSpec
implements AlgorithmParameterSpec {
    public static final String DEFAULT_SYM_CIPHER = "AES128_CBC";
    public static final String DEFAULT_MAC = "HmacSHA1";
    private de.flexiprovider.api.keys.KeyPair ephKeyPair;
    private String symCipherName;
    private String mSymKFName;
    private int mSymKeyLength;
    private String macName;
    private String mMacKFName;
    private byte[] macEncParam;
    private byte[] sharedInfo;

    public IESParameterSpec(KeyPair ephKeyPair, String symCipherName, String macName, byte[] macEncParam, byte[] sharedInfo) throws InvalidParameterException {
        this(ephKeyPair == null ? null : new de.flexiprovider.api.keys.KeyPair((PublicKey)ephKeyPair.getPublic(), (PrivateKey)ephKeyPair.getPrivate()), symCipherName, macName, macEncParam, sharedInfo);
    }

    public IESParameterSpec() {
        this((de.flexiprovider.api.keys.KeyPair)null, DEFAULT_SYM_CIPHER, DEFAULT_MAC, null, null);
    }

    public IESParameterSpec(String symCipherName, String macName, byte[] macEncParam, byte[] sharedInfo) throws de.flexiprovider.api.exceptions.InvalidParameterException {
        this((de.flexiprovider.api.keys.KeyPair)null, symCipherName, macName, macEncParam, sharedInfo);
    }

    public IESParameterSpec(de.flexiprovider.api.keys.KeyPair ephKeyPair, String symCipherName, String macName, byte[] macEncParam, byte[] sharedInfo) throws de.flexiprovider.api.exceptions.InvalidParameterException {
        this.ephKeyPair = ephKeyPair;
        this.setSymCipher(symCipherName);
        this.setMac(macName);
        this.macEncParam = ByteUtils.clone(macEncParam);
        this.sharedInfo = ByteUtils.clone(sharedInfo);
    }

    public de.flexiprovider.api.keys.KeyPair getEphKeyPair() {
        return this.ephKeyPair;
    }

    public String getSymCipherName() {
        return this.symCipherName;
    }

    protected String getSymKFName() {
        return this.mSymKFName;
    }

    protected int getSymKeyLength() {
        return this.mSymKeyLength;
    }

    public String getMacName() {
        return this.macName;
    }

    protected String getMacKFName() {
        return this.mMacKFName;
    }

    public byte[] getMacEncParam() {
        return ByteUtils.clone(this.macEncParam);
    }

    public byte[] getSharedInfo() {
        return ByteUtils.clone(this.sharedInfo);
    }

    private void setSymCipher(String symCipherName) throws de.flexiprovider.api.exceptions.InvalidParameterException {
        if (symCipherName == null || symCipherName.equals("")) {
            symCipherName = DEFAULT_SYM_CIPHER;
        }
        if (symCipherName.equals("internal")) {
            this.symCipherName = null;
            this.mSymKFName = null;
            this.mSymKeyLength = 0;
        } else if (symCipherName.equals("DESede_CBC")) {
            this.symCipherName = symCipherName;
            this.mSymKFName = "DESede";
            this.mSymKeyLength = 24;
        } else if (symCipherName.equals(DEFAULT_SYM_CIPHER)) {
            this.symCipherName = symCipherName;
            this.mSymKFName = "AES";
            this.mSymKeyLength = 16;
        } else if (symCipherName.equals("AES192_CBC")) {
            this.symCipherName = symCipherName;
            this.mSymKFName = "AES";
            this.mSymKeyLength = 24;
        } else if (symCipherName.equals("AES256_CBC")) {
            this.symCipherName = symCipherName;
            this.mSymKFName = "AES";
            this.mSymKeyLength = 32;
        } else {
            throw new de.flexiprovider.api.exceptions.InvalidParameterException("Unsupported symmetric cipher algorithm: '" + symCipherName + "'.");
        }
    }

    private void setMac(String macName) throws de.flexiprovider.api.exceptions.InvalidParameterException {
        if (macName == null || macName.equals("")) {
            this.macName = DEFAULT_MAC;
            this.mMacKFName = "Hmac";
        } else if (macName.equals(DEFAULT_MAC) || macName.equals("HmacSHA256") || macName.equals("HmacSHA384") || macName.equals("HmacSHA512") || macName.equals("HmacRIPEMD160")) {
            this.macName = macName;
            this.mMacKFName = "Hmac";
        } else {
            throw new de.flexiprovider.api.exceptions.InvalidParameterException("Unsupported MAC function: '" + macName + "'.");
        }
    }
}

